/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.collections;

import org.apache.mahout.collections.Constants;

public final class Arithmetic
extends Constants {
    private static final double[] STIRLING_CORRECTION = new double[]{0.0, 0.08106146679532726, 0.04134069595540929, 0.02767792568499834, 0.02079067210376509, 0.01664469118982119, 0.01387612882307075, 0.01189670994589177, 0.01041126526197209, 0.009255462182712733, 0.00833056343336287, 0.007573675487951841, 0.00694284010720953, 0.006408994188004207, 0.005951370112758848, 0.005554733551962801, 0.00520765591960964, 0.004901395948434738, 0.004629153749334029, 0.004385560249232324, 0.004166319691996922, 0.00396795421864086, 0.00378761806844443, 0.00362296022468309, 0.00347202138297877, 0.00333315563672809, 0.00320497022805504, 0.00308627868260878, 0.00297606398355041, 0.00287344936235247, 0.00277767492975269};
    private static final double[] LOG_FACTORIALS = new double[]{0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.1780538303479458, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.801827480081469, 15.104412573075516, 17.502307845873887, 19.987214495661885, 22.552163853123425, 25.19122118273868, 27.89927138384089, 30.671860106080672, 33.50507345013689, 36.39544520803305, 39.339884187199495, 42.335616460753485, 45.38013889847691, 48.47118135183523, 51.60667556776438, 54.78472939811232, 58.00360522298052, 61.261701761002, 64.55753862700634, 67.88974313718154, 71.25703896716801};
    private static final long[] LONG_FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private static final double[] DOUBLE_FACTORIALS = new double[]{5.109094217170944E19, 1.1240007277776077E21, 2.585201673888498E22, 6.204484017332394E23, 1.5511210043330984E25, 4.032914611266057E26, 1.0888869450418352E28, 3.048883446117138E29, 8.841761993739701E30, 2.652528598121911E32, 8.222838654177924E33, 2.6313083693369355E35, 8.68331761881189E36, 2.952327990396041E38, 1.0333147966386144E40, 3.719933267899013E41, 1.3763753091226346E43, 5.23022617466601E44, 2.0397882081197447E46, 8.15915283247898E47, 3.34525266131638E49, 1.4050061177528801E51, 6.041526306337384E52, 2.6582715747884495E54, 1.196222208654802E56, 5.502622159812089E57, 2.5862324151116827E59, 1.2413915592536068E61, 6.082818640342679E62, 3.0414093201713376E64, 1.5511187532873816E66, 8.06581751709439E67, 4.274883284060024E69, 2.308436973392413E71, 1.2696403353658264E73, 7.109985878048632E74, 4.052691950487723E76, 2.350561331282879E78, 1.386831185456898E80, 8.32098711274139E81, 5.075802138772246E83, 3.146997326038794E85, 1.9826083154044396E87, 1.2688693218588414E89, 8.247650592082472E90, 5.443449390774432E92, 3.6471110918188705E94, 2.48003554243683E96, 1.7112245242814127E98, 1.1978571669969892E100, 8.504785885678624E101, 6.123445837688612E103, 4.470115461512686E105, 3.307885441519387E107, 2.4809140811395404E109, 1.8854947016660506E111, 1.451830920282859E113, 1.1324281178206295E115, 8.94618213078298E116, 7.15694570462638E118, 5.797126020747369E120, 4.7536433370128435E122, 3.94552396972066E124, 3.314240134565354E126, 2.8171041143805494E128, 2.4227095383672744E130, 2.107757298379527E132, 1.854826422573984E134, 1.6507955160908465E136, 1.4857159644817605E138, 1.3520015276784033E140, 1.2438414054641305E142, 1.156772507081641E144, 1.0873661566567426E146, 1.0329978488239061E148, 9.916779348709491E149, 9.619275968248216E151, 9.426890448883248E153, 9.332621544394415E155, 9.332621544394418E157, 9.42594775983836E159, 9.614466715035125E161, 9.902900716486178E163, 1.0299016745145631E166, 1.0813967582402912E168, 1.1462805637347086E170, 1.2265202031961373E172, 1.324641819451829E174, 1.4438595832024942E176, 1.5882455415227423E178, 1.7629525510902457E180, 1.974506857221075E182, 2.2311927486598138E184, 2.543559733472186E186, 2.925093693493014E188, 3.393108684451899E190, 3.96993716080872E192, 4.6845258497542896E194, 5.574585761207606E196, 6.689502913449135E198, 8.094298525273444E200, 9.875044200833601E202, 1.2146304367025332E205, 1.506141741511141E207, 1.882677176888926E209, 2.3721732428800483E211, 3.0126600184576624E213, 3.856204823625808E215, 4.974504222477287E217, 6.466855489220473E219, 8.471580690878813E221, 1.1182486511960037E224, 1.4872707060906847E226, 1.99294274616152E228, 2.690472707318049E230, 3.6590428819525483E232, 5.0128887482749884E234, 6.917786472619482E236, 9.615723196941089E238, 1.3462012475717523E241, 1.8981437590761713E243, 2.6953641378881633E245, 3.8543707171800694E247, 5.550293832739308E249, 8.047926057471989E251, 1.1749972043909107E254, 1.72724589045464E256, 2.5563239178728637E258, 3.8089226376305687E260, 5.7133839564458575E262, 8.627209774233244E264, 1.3113358856834527E267, 2.0063439050956838E269, 3.0897696138473515E271, 4.789142901463393E273, 7.471062926282892E275, 1.1729568794264134E278, 1.8532718694937346E280, 2.946702272495036E282, 4.714723635992061E284, 7.590705053947223E286, 1.2296942187394494E289, 2.0044015765453032E291, 3.287218585534299E293, 5.423910666131583E295, 9.003691705778434E297, 1.5036165148649983E300, 2.5260757449731988E302, 4.2690680090047056E304, 7.257415615308004E306};

    Arithmetic() {
    }

    public static double binomial(double n, long k) {
        if (k < 0L) {
            return 0.0;
        }
        if (k == 0L) {
            return 1.0;
        }
        if (k == 1L) {
            return n;
        }
        double a = n - (double)k + 1.0;
        double b = 1.0;
        double binomial = 1.0;
        long i = k;
        while (i-- > 0L) {
            double d = a;
            a = d + 1.0;
            double d2 = b;
            b = d2 + 1.0;
            binomial *= d / d2;
        }
        return binomial;
    }

    public static double binomial(long n, long k) {
        if (k < 0L) {
            return 0.0;
        }
        if (k == 0L || k == n) {
            return 1.0;
        }
        if (k == 1L || k == n - 1L) {
            return n;
        }
        if (n > k) {
            int max = LONG_FACTORIALS.length + DOUBLE_FACTORIALS.length;
            if (n < (long)max) {
                double n_fac = Arithmetic.factorial((int)n);
                double k_fac = Arithmetic.factorial((int)k);
                double n_minus_k_fac = Arithmetic.factorial((int)(n - k));
                double nk = n_minus_k_fac * k_fac;
                if (nk != Double.POSITIVE_INFINITY) {
                    return n_fac / nk;
                }
            }
            if (k > n / 2L) {
                k = n - k;
            }
        }
        long a = n - k + 1L;
        long b = 1L;
        double binomial = 1.0;
        long i = k;
        while (i-- > 0L) {
            binomial *= (double)a++ / (double)b++;
        }
        return binomial;
    }

    public static long ceil(double value) {
        return Math.round(Math.ceil(value));
    }

    public static double chbevl(double x, double[] coef, int N) {
        double b2;
        int p = 0;
        double b0 = coef[p++];
        double b1 = 0.0;
        int i = N - 1;
        do {
            b2 = b1;
            b1 = b0;
            b0 = x * b1 - b2 + coef[p++];
        } while (--i > 0);
        return 0.5 * (b0 - b2);
    }

    private static double factorial(int k) {
        if (k < 0) {
            throw new IllegalArgumentException();
        }
        int length1 = LONG_FACTORIALS.length;
        if (k < length1) {
            return LONG_FACTORIALS[k];
        }
        int length2 = DOUBLE_FACTORIALS.length;
        if (k < length1 + length2) {
            return DOUBLE_FACTORIALS[k - length1];
        }
        return Double.POSITIVE_INFINITY;
    }

    public static long floor(double value) {
        return Math.round(Math.floor(value));
    }

    public static double log(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    public static double log10(double value) {
        return Math.log(value) * 0.43429448190325176;
    }

    public static double log2(double value) {
        return Math.log(value) * 1.4426950408889634;
    }

    public static double logFactorial(int k) {
        if (k >= 30) {
            double r = 1.0 / (double)k;
            double rr = r * r;
            double C7 = -5.952380952380953E-4;
            double C5 = 7.936507936507937E-4;
            double C3 = -0.002777777777777778;
            double C1 = 0.08333333333333333;
            double C0 = 0.9189385332046728;
            return ((double)k + 0.5) * Math.log(k) - (double)k + C0 + r * (C1 + rr * (C3 + rr * (C5 + rr * C7)));
        }
        return LOG_FACTORIALS[k];
    }

    public static long longFactorial(int k) {
        if (k < 0) {
            throw new IllegalArgumentException("Negative k");
        }
        if (k < LONG_FACTORIALS.length) {
            return LONG_FACTORIALS[k];
        }
        throw new IllegalArgumentException("Overflow");
    }

    public static double stirlingCorrection(int k) {
        if (k > 30) {
            double r = 1.0 / (double)k;
            double rr = r * r;
            double C7 = -5.952380952380953E-4;
            double C5 = 7.936507936507937E-4;
            double C3 = -0.002777777777777778;
            double C1 = 0.08333333333333333;
            return r * (C1 + rr * (C3 + rr * (C5 + rr * C7)));
        }
        return STIRLING_CORRECTION[k];
    }
}

