/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.CharObjectProcedure;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractCharObjectMap<T>
extends AbstractSet {
    public boolean containsKey(final char key) {
        return !this.forEachKey(new CharProcedure(){

            @Override
            public boolean apply(char iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final T value) {
        return !this.forEachPair(new CharObjectProcedure<T>(){

            @Override
            public boolean apply(char iterKey, Object iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractCharObjectMap<T> copy() {
        return (AbstractCharObjectMap)this.getClass().cast(this.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractCharObjectMap)) {
            return false;
        }
        final AbstractCharObjectMap other = (AbstractCharObjectMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new CharObjectProcedure(){

            public boolean apply(char key, Object value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new CharObjectProcedure(){

            public boolean apply(char key, Object value) {
                return AbstractCharObjectMap.this.containsKey(key) && AbstractCharObjectMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new CharObjectProcedure(){
            int i = 0;

            public boolean apply(char key, Object value) {
                buf[this.i++] = HashUtils.hash(key) ^ value.hashCode();
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(CharProcedure var1);

    public boolean forEachPair(final CharObjectProcedure<T> procedure) {
        return this.forEachKey(new CharProcedure(){

            @Override
            public boolean apply(char key) {
                return procedure.apply(key, AbstractCharObjectMap.this.get(key));
            }
        });
    }

    public abstract T get(char var1);

    public CharArrayList keys() {
        CharArrayList list = new CharArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final CharArrayList list) {
        list.clear();
        this.forEachKey(new CharProcedure(){

            @Override
            public boolean apply(char key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(CharArrayList keyList) {
        this.pairsSortedByValue(keyList, new ArrayList(this.size()));
    }

    public void pairsMatching(final CharObjectProcedure<T> condition, final CharArrayList keyList, final List<T> valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new CharObjectProcedure<T>(){

            @Override
            public boolean apply(char key, T value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(CharArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        keyList.sort();
        Object[] tempValueList = new Object[keyList.size()];
        int i = keyList.size();
        while (--i >= 0) {
            tempValueList[i] = this.get(keyList.getQuick(i));
        }
        valueList.clear();
        for (Object value : tempValueList) {
            valueList.add(value);
        }
    }

    public void pairsSortedByValue(CharArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        this.values(valueList);
        if (!valueList.isEmpty() && !(valueList.get(0) instanceof Comparable)) {
            throw new UnsupportedOperationException("Cannot sort the values; " + valueList.get(0).getClass() + " does not implement Comparable");
        }
        final char[] k = keyList.elements();
        final List<T> valueRef = valueList;
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object t1 = valueRef.get(a);
                valueRef.set(a, valueRef.get(b));
                valueRef.set(b, t1);
                char t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                int ab = ((Comparable)valueRef.get(a)).compareTo(valueRef.get(b));
                return ab < 0 ? -1 : (ab > 0 ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(char var1, T var2);

    public abstract boolean removeKey(char var1);

    public String toString() {
        CharArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            char key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        CharArrayList theKeys = new CharArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            char key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public List<T> values() {
        ArrayList list = new ArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final List<T> list) {
        list.clear();
        this.forEachKey(new CharProcedure(){

            @Override
            public boolean apply(char key) {
                list.add(AbstractCharObjectMap.this.get(key));
                return true;
            }
        });
    }
}

