/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.random.Sampler;

public final class ChineseRestaurant
implements Sampler<Integer> {
    private final double alpha;
    private double weight = 0.0;
    private double discount = 0.0;
    private final DoubleArrayList weights = new DoubleArrayList();
    private final Random rand = RandomUtils.getRandom();

    public ChineseRestaurant(double alpha) {
        this(alpha, 0.0);
    }

    public ChineseRestaurant(double alpha, double discount) {
        Preconditions.checkArgument((alpha > 0.0 ? 1 : 0) != 0, (Object)"Strength Parameter, alpha must be greater then 0!");
        Preconditions.checkArgument((discount >= 0.0 && discount <= 1.0 ? 1 : 0) != 0, (Object)"Must be: 0 <= discount <= 1");
        this.alpha = alpha;
        this.discount = discount;
    }

    @Override
    public Integer sample() {
        double u = this.rand.nextDouble() * (this.alpha + this.weight);
        for (int j = 0; j < this.weights.size(); ++j) {
            if (u < this.weights.get(j) - this.discount) {
                this.weights.set(j, this.weights.get(j) + 1.0);
                this.weight += 1.0;
                return j;
            }
            u -= this.weights.get(j) - this.discount;
        }
        this.weights.add(1.0);
        this.weight += 1.0;
        return this.weights.size() - 1;
    }

    public int size() {
        return this.weights.size();
    }

    public int count() {
        return (int)this.weight;
    }

    public int count(int j) {
        Preconditions.checkArgument((j >= 0 ? 1 : 0) != 0);
        if (j < this.weights.size()) {
            return (int)this.weights.get(j);
        }
        return 0;
    }
}

