/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.random.Sampler;
import org.apache.mahout.math.random.WeightedThing;

public final class Multinomial<T>
implements Sampler<T>,
Iterable<T> {
    private final DoubleArrayList weight = new DoubleArrayList();
    private final List<T> values = Lists.newArrayList();
    private final Map<T, Integer> items = Maps.newHashMap();
    private Random rand = RandomUtils.getRandom();

    public Multinomial() {
        this.weight.add(0.0);
        this.values.add(null);
    }

    public Multinomial(Multiset<T> counts) {
        this();
        Preconditions.checkArgument((!counts.isEmpty() ? 1 : 0) != 0, (Object)"Need some data to build sampler");
        this.rand = RandomUtils.getRandom();
        for (Object t : counts.elementSet()) {
            this.add(t, counts.count(t));
        }
    }

    public Multinomial(Iterable<WeightedThing<T>> things) {
        this();
        for (WeightedThing<T> thing : things) {
            this.add(thing.getValue(), thing.getWeight());
        }
    }

    public void add(T value, double w) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument((!this.items.containsKey(value) ? 1 : 0) != 0);
        int n = this.weight.size();
        if (n == 1) {
            this.weight.add(w);
            this.values.add(value);
            this.items.put(value, 1);
        } else {
            this.weight.add(this.weight.get(n / 2));
            this.values.add(this.values.get(n / 2));
            this.items.put(this.values.get(n / 2), n);
            this.items.put(value, ++n);
            this.weight.add(w);
            this.values.add(value);
            while (n > 1) {
                this.weight.set(n /= 2, this.weight.get(n) + w);
            }
        }
    }

    public double getWeight(T value) {
        if (this.items.containsKey(value)) {
            return this.weight.get(this.items.get(value));
        }
        return 0.0;
    }

    public double getProbability(T value) {
        if (this.items.containsKey(value)) {
            return this.weight.get(this.items.get(value)) / this.weight.get(1);
        }
        return 0.0;
    }

    public double getWeight() {
        if (this.weight.size() > 1) {
            return this.weight.get(1);
        }
        return 0.0;
    }

    public void delete(T value) {
        this.set(value, 0.0);
    }

    public void set(T value, double newP) {
        Preconditions.checkArgument((boolean)this.items.containsKey(value));
        int n = this.items.get(value);
        if (newP <= 0.0) {
            this.items.remove(value);
        }
        double oldP = this.weight.get(n);
        while (n > 0) {
            this.weight.set(n, this.weight.get(n) - oldP + newP);
            n /= 2;
        }
    }

    @Override
    public T sample() {
        Preconditions.checkArgument((!this.weight.isEmpty() ? 1 : 0) != 0);
        return this.sample(this.rand.nextDouble());
    }

    public T sample(double u) {
        u *= this.weight.get(1);
        int n = 1;
        while (2 * n < this.weight.size()) {
            double left = this.weight.get(2 * n);
            if (u <= left) {
                n = 2 * n;
                continue;
            }
            u -= left;
            n = 2 * n + 1;
        }
        return this.values.get(n);
    }

    List<Double> getWeights() {
        int i;
        ArrayList r = Lists.newArrayList();
        for (i = Integer.highestOneBit(this.weight.size()); i < this.weight.size(); ++i) {
            r.add(this.weight.get(i));
        }
        i /= 2;
        while (i < Integer.highestOneBit(this.weight.size())) {
            r.add(this.weight.get(i));
            ++i;
        }
        return r;
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){
            Iterator<T> valuesIterator;
            {
                this.valuesIterator = Iterables.skip((Iterable)Multinomial.this.values, (int)1).iterator();
            }

            protected T computeNext() {
                while (this.valuesIterator.hasNext()) {
                    Object next = this.valuesIterator.next();
                    if (!Multinomial.this.items.containsKey(next)) continue;
                    return next;
                }
                return this.endOfData();
            }
        };
    }
}

