/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractByteSet
extends AbstractSet {
    public boolean contains(final byte key) {
        return !this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractByteSet copy() {
        return (AbstractByteSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractByteSet)) {
            return false;
        }
        final AbstractByteSet other = (AbstractByteSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                return other.contains(key);
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachKey(new ByteProcedure(){
            int i = 0;

            @Override
            public boolean apply(byte iterKey) {
                buf[this.i++] = HashUtils.hash(iterKey);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ByteProcedure var1);

    public ByteArrayList keys() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(byte var1);

    public abstract boolean remove(byte var1);

    public String toString() {
        ByteArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

