/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

class DefaultModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context;
    private List<RemoteRepository> repositories;
    private final List<RemoteRepository> externalRepositories;
    private final ArtifactResolver resolver;
    private final VersionRangeResolver versionRangeResolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;

    public DefaultModelResolver(RepositorySystemSession session, RequestTrace trace, String context, ArtifactResolver resolver, VersionRangeResolver versionRangeResolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        this.session = session;
        this.trace = trace;
        this.context = context;
        this.resolver = resolver;
        this.versionRangeResolver = versionRangeResolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = repositories;
        ArrayList<RemoteRepository> externalRepositories = new ArrayList<RemoteRepository>();
        externalRepositories.addAll(repositories);
        this.externalRepositories = Collections.unmodifiableList(externalRepositories);
        this.repositoryIds = new HashSet<String>();
    }

    private DefaultModelResolver(DefaultModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.context = original.context;
        this.resolver = original.resolver;
        this.versionRangeResolver = original.versionRangeResolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.repositories = original.repositories;
        this.externalRepositories = original.externalRepositories;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (this.session.isIgnoreArtifactDescriptorRepositories() || !this.repositoryIds.add(repository.getId())) {
            return;
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository(repository));
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
    }

    public void resetRepositories() {
        this.repositoryIds.clear();
        this.repositories.clear();
        this.repositories.addAll(this.externalRepositories);
    }

    public ModelResolver newCopy() {
        return new DefaultModelResolver(this);
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, this.context);
            request.setTrace(this.trace);
            pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        DefaultArtifact artifact = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "", "pom", parent.getVersion());
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, this.repositories, this.context);
        versionRangeRequest.setTrace(this.trace);
        try {
            VersionRangeResult versionRangeResult = this.versionRangeResolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException("No versions matched the requested range '" + parent.getVersion() + "'", parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException("The requested version range '" + parent.getVersion() + "' does not specify an upper bound", parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            parent.setVersion(versionRangeResult.getHighestVersion().toString());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), (Throwable)e);
        }
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }
}

