/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CleanArgument;

public class CLIManager {
    public static final char ALTERNATE_POM_FILE = 'f';
    public static final char BATCH_MODE = 'B';
    public static final char SET_SYSTEM_PROPERTY = 'D';
    public static final char OFFLINE = 'o';
    public static final char QUIET = 'q';
    public static final char DEBUG = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char SHOW_VERSION = 'V';
    public static final char NON_RECURSIVE = 'N';
    public static final char UPDATE_SNAPSHOTS = 'U';
    public static final char ACTIVATE_PROFILES = 'P';
    public static final String SUPRESS_SNAPSHOT_UPDATES = "nsu";
    public static final char CHECKSUM_FAILURE_POLICY = 'C';
    public static final char CHECKSUM_WARNING_POLICY = 'c';
    public static final char ALTERNATE_USER_SETTINGS = 's';
    public static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
    public static final char ALTERNATE_USER_TOOLCHAINS = 't';
    public static final String ALTERNATE_GLOBAL_TOOLCHAINS = "gt";
    public static final String FAIL_FAST = "ff";
    public static final String FAIL_AT_END = "fae";
    public static final String FAIL_NEVER = "fn";
    public static final String RESUME_FROM = "rf";
    public static final String PROJECT_LIST = "pl";
    public static final String ALSO_MAKE = "am";
    public static final String ALSO_MAKE_DEPENDENTS = "amd";
    public static final String LOG_FILE = "l";
    public static final String ENCRYPT_MASTER_PASSWORD = "emp";
    public static final String ENCRYPT_PASSWORD = "ep";
    public static final String THREADS = "T";
    public static final String LEGACY_LOCAL_REPOSITORY = "llr";
    public static final String BUILDER = "b";
    public static final String NO_TRANSFER_PROGRESS = "ntp";
    public static final String COLOR = "color";
    protected Options options = new Options();

    public CLIManager() {
        this.options.addOption(Option.builder((String)Character.toString('h')).longOpt("help").desc("Display help information").build());
        this.options.addOption(Option.builder((String)Character.toString('f')).longOpt("file").hasArg().desc("Force the use of an alternate POM file (or directory with pom.xml)").build());
        this.options.addOption(Option.builder((String)Character.toString('D')).longOpt("define").hasArg().desc("Define a system property").build());
        this.options.addOption(Option.builder((String)Character.toString('o')).longOpt("offline").desc("Work offline").build());
        this.options.addOption(Option.builder((String)Character.toString('v')).longOpt("version").desc("Display version information").build());
        this.options.addOption(Option.builder((String)Character.toString('q')).longOpt("quiet").desc("Quiet output - only show errors").build());
        this.options.addOption(Option.builder((String)Character.toString('X')).longOpt("debug").desc("Produce execution debug output").build());
        this.options.addOption(Option.builder((String)Character.toString('e')).longOpt("errors").desc("Produce execution error messages").build());
        this.options.addOption(Option.builder((String)Character.toString('N')).longOpt("non-recursive").desc("Do not recurse into sub-projects").build());
        this.options.addOption(Option.builder((String)Character.toString('U')).longOpt("update-snapshots").desc("Forces a check for missing releases and updated snapshots on remote repositories").build());
        this.options.addOption(Option.builder((String)Character.toString('P')).longOpt("activate-profiles").desc("Comma-delimited list of profiles to activate").hasArg().build());
        this.options.addOption(Option.builder((String)Character.toString('B')).longOpt("batch-mode").desc("Run in non-interactive (batch) mode (disables output color)").build());
        this.options.addOption(Option.builder((String)SUPRESS_SNAPSHOT_UPDATES).longOpt("no-snapshot-updates").desc("Suppress SNAPSHOT updates").build());
        this.options.addOption(Option.builder((String)Character.toString('C')).longOpt("strict-checksums").desc("Fail the build if checksums don't match").build());
        this.options.addOption(Option.builder((String)Character.toString('c')).longOpt("lax-checksums").desc("Warn if checksums don't match").build());
        this.options.addOption(Option.builder((String)Character.toString('s')).longOpt("settings").desc("Alternate path for the user settings file").hasArg().build());
        this.options.addOption(Option.builder((String)ALTERNATE_GLOBAL_SETTINGS).longOpt("global-settings").desc("Alternate path for the global settings file").hasArg().build());
        this.options.addOption(Option.builder((String)Character.toString('t')).longOpt("toolchains").desc("Alternate path for the user toolchains file").hasArg().build());
        this.options.addOption(Option.builder((String)ALTERNATE_GLOBAL_TOOLCHAINS).longOpt("global-toolchains").desc("Alternate path for the global toolchains file").hasArg().build());
        this.options.addOption(Option.builder((String)FAIL_FAST).longOpt("fail-fast").desc("Stop at first failure in reactorized builds").build());
        this.options.addOption(Option.builder((String)FAIL_AT_END).longOpt("fail-at-end").desc("Only fail the build afterwards; allow all non-impacted builds to continue").build());
        this.options.addOption(Option.builder((String)FAIL_NEVER).longOpt("fail-never").desc("NEVER fail the build, regardless of project result").build());
        this.options.addOption(Option.builder((String)RESUME_FROM).longOpt("resume-from").hasArg().desc("Resume reactor from specified project").build());
        this.options.addOption(Option.builder((String)PROJECT_LIST).longOpt("projects").desc("Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path").hasArg().build());
        this.options.addOption(Option.builder((String)ALSO_MAKE).longOpt("also-make").desc("If project list is specified, also build projects required by the list").build());
        this.options.addOption(Option.builder((String)ALSO_MAKE_DEPENDENTS).longOpt("also-make-dependents").desc("If project list is specified, also build projects that depend on projects on the list").build());
        this.options.addOption(Option.builder((String)LOG_FILE).longOpt("log-file").hasArg().desc("Log file where all build output will go (disables output color)").build());
        this.options.addOption(Option.builder((String)Character.toString('V')).longOpt("show-version").desc("Display version information WITHOUT stopping build").build());
        this.options.addOption(Option.builder((String)ENCRYPT_MASTER_PASSWORD).longOpt("encrypt-master-password").hasArg().optionalArg(true).desc("Encrypt master security password").build());
        this.options.addOption(Option.builder((String)ENCRYPT_PASSWORD).longOpt("encrypt-password").hasArg().optionalArg(true).desc("Encrypt server password").build());
        this.options.addOption(Option.builder((String)THREADS).longOpt("threads").hasArg().desc("Thread count, for instance 2.0C where C is core multiplied").build());
        this.options.addOption(Option.builder((String)LEGACY_LOCAL_REPOSITORY).longOpt("legacy-local-repository").desc("Use Maven 2 Legacy Local Repository behaviour, ie no use of _remote.repositories. Can also be activated by using -Dmaven.legacyLocalRepo=true").build());
        this.options.addOption(Option.builder((String)BUILDER).longOpt("builder").hasArg().desc("The id of the build strategy to use").build());
        this.options.addOption(Option.builder((String)NO_TRANSFER_PROGRESS).longOpt("no-transfer-progress").desc("Do not display transfer progress when downloading or uploading").build());
        this.options.addOption(Option.builder((String)"npr").longOpt("no-plugin-registry").desc("Ineffective, only kept for backward compatibility").build());
        this.options.addOption(Option.builder((String)"cpu").longOpt("check-plugin-updates").desc("Ineffective, only kept for backward compatibility").build());
        this.options.addOption(Option.builder((String)"up").longOpt("update-plugins").desc("Ineffective, only kept for backward compatibility").build());
        this.options.addOption(Option.builder((String)"npu").longOpt("no-plugin-updates").desc("Ineffective, only kept for backward compatibility").build());
        this.options.addOption(Option.builder().longOpt(COLOR).hasArg().optionalArg(true).desc("Defines the color mode of the output. Supported are 'auto', 'always', 'never'.").build());
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = CleanArgument.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.options, cleanArgs);
    }

    public void displayHelp(PrintStream stdout) {
        stdout.println();
        PrintWriter pw = new PrintWriter(stdout);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 74, "mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, 1, 3, "\n", false);
        pw.flush();
    }
}

