/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.local.m2;

import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.util.FileUtil;

public class ArtifactLocation {
    public static final String POM_EXT = ".pom";
    private String prefix;
    private String gaPath;
    private String versionDir;
    private String baseName;
    private String version;
    private String classifier;
    private String type;
    private ArtifactBasicMetadata bmd;

    public ArtifactLocation(String prefix, ArtifactBasicMetadata bmd) {
        if (prefix == null || bmd == null || bmd.getGroupId() == null || bmd.getArtifactId() == null || bmd.getVersion() == null) {
            return;
        }
        this.bmd = bmd;
        this.prefix = prefix;
        this.gaPath = bmd.getGroupId().replace('.', FileUtil.SEP_CHAR) + "/" + bmd.getArtifactId();
        this.version = bmd.getVersion();
        this.baseName = bmd.getArtifactId();
        this.versionDir = this.version;
        this.classifier = bmd.getClassifier();
        this.type = bmd.getType();
    }

    public String getRelPath() {
        return this.gaPath + "/" + this.versionDir + "/" + this.baseName + "-" + this.version + this.getDashedClassifier() + '.' + this.type;
    }

    public String getRelPomPath() {
        return this.gaPath + "/" + this.versionDir + "/" + this.baseName + "-" + this.version + POM_EXT;
    }

    public String getAbsPath() {
        if (this.prefix == null) {
            return null;
        }
        return this.getSeparatedPrefix() + this.getRelPath();
    }

    public String getAbsPomPath() {
        if (this.prefix == null) {
            return null;
        }
        return this.getSeparatedPrefix() + this.getRelPomPath();
    }

    public String getGavPath() {
        return this.getGaPath() + "/" + this.versionDir;
    }

    public String getBaseVersion() {
        if (this.version == null) {
            return null;
        }
        DefaultArtifactVersion dav = new DefaultArtifactVersion(this.version);
        return dav.getBase();
    }

    public String getGaPath() {
        return this.gaPath;
    }

    public void setGaPath(String gaPath) {
        this.gaPath = gaPath;
    }

    public String getVersionDir() {
        return this.versionDir;
    }

    public void setVersionDir(String versionDir) {
        this.versionDir = versionDir;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getDashedClassifier() {
        return this.classifier == null || this.classifier.length() < 1 ? "" : "-" + this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSeparatedPrefix() {
        if (this.prefix == null) {
            return null;
        }
        return this.prefix + (this.prefix.endsWith("/") ? "" : "/");
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        return this.bmd == null ? "no ArtifactBasicMetadata" : this.bmd.toString();
    }
}

