/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.archiver;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;

public class PrefixingProxyArchiver
implements Archiver {
    private Archiver delegate;
    private String rootPrefix;

    public PrefixingProxyArchiver(String rootPrefix, Archiver delegate) {
        this.rootPrefix = rootPrefix;
        this.delegate = delegate;
        if (!rootPrefix.endsWith("/")) {
            this.rootPrefix = this.rootPrefix + "/";
        }
    }

    public void addArchivedFileSet(File archiveFile, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        this.delegate.addArchivedFileSet(archiveFile, this.rootPrefix + prefix, includes, excludes);
    }

    public void addArchivedFileSet(File archiveFile, String prefix) throws ArchiverException {
        this.delegate.addArchivedFileSet(archiveFile, this.rootPrefix + prefix);
    }

    public void addArchivedFileSet(File archiveFile, String[] includes, String[] excludes) throws ArchiverException {
        this.delegate.addArchivedFileSet(archiveFile, this.rootPrefix, includes, excludes);
    }

    public void addArchivedFileSet(File archiveFile) throws ArchiverException {
        this.delegate.addArchivedFileSet(archiveFile, this.rootPrefix);
    }

    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        this.delegate.addDirectory(directory, this.rootPrefix + prefix, includes, excludes);
    }

    public void addDirectory(File directory, String prefix) throws ArchiverException {
        this.delegate.addDirectory(directory, this.rootPrefix + prefix);
    }

    public void addDirectory(File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.delegate.addDirectory(directory, this.rootPrefix, includes, excludes);
    }

    public void addDirectory(File directory) throws ArchiverException {
        this.delegate.addDirectory(directory, this.rootPrefix);
    }

    public void addFile(File inputFile, String destFileName, int permissions) throws ArchiverException {
        this.delegate.addFile(inputFile, this.rootPrefix + destFileName, permissions);
    }

    public void addFile(File inputFile, String destFileName) throws ArchiverException {
        this.delegate.addFile(inputFile, this.rootPrefix + destFileName);
    }

    public void createArchive() throws ArchiverException, IOException {
        this.delegate.createArchive();
    }

    public int getDefaultDirectoryMode() {
        return this.delegate.getDefaultDirectoryMode();
    }

    public int getDefaultFileMode() {
        return this.delegate.getDefaultFileMode();
    }

    public File getDestFile() {
        return this.delegate.getDestFile();
    }

    public Map getFiles() {
        return this.delegate.getFiles();
    }

    public boolean getIncludeEmptyDirs() {
        return this.delegate.getIncludeEmptyDirs();
    }

    public boolean isForced() {
        return this.delegate.isForced();
    }

    public boolean isSupportingForced() {
        return this.delegate.isSupportingForced();
    }

    public void setDefaultDirectoryMode(int mode) {
        this.delegate.setDefaultDirectoryMode(mode);
    }

    public void setDefaultFileMode(int mode) {
        this.delegate.setDefaultFileMode(mode);
    }

    public void setDestFile(File destFile) {
        this.delegate.setDestFile(destFile);
    }

    public void setForced(boolean forced) {
        this.delegate.setForced(forced);
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.delegate.setIncludeEmptyDirs(includeEmptyDirs);
    }

    public void setDotFileDirectory(File dotFileDirectory) {
        throw new UnsupportedOperationException("Undocumented feature of plexus-archiver; this is not yet supported.");
    }
}

