/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.interpolation;

import java.io.File;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugin.assembly.utils.InterpolationConstants;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;

public class AssemblyExpressionEvaluator
implements ExpressionEvaluator {
    private final AssemblerConfigurationSource configSource;
    private final Interpolator interpolator;
    private final PrefixAwareRecursionInterceptor interceptor;

    public AssemblyExpressionEvaluator(AssemblerConfigurationSource configSource) {
        this.configSource = configSource;
        this.interpolator = AssemblyInterpolator.buildInterpolator(configSource.getProject(), configSource);
        this.interceptor = new PrefixAwareRecursionInterceptor(InterpolationConstants.PROJECT_PREFIXES, true);
    }

    public File alignToBaseDirectory(File f) {
        String basePath = this.configSource.getBasedir().getAbsolutePath();
        String path = f.getPath();
        if (!f.isAbsolute() && !path.startsWith(basePath)) {
            return new File(this.configSource.getBasedir(), path);
        }
        return f;
    }

    public Object evaluate(String expression) throws ExpressionEvaluationException {
        try {
            return this.interpolator.interpolate(expression, (RecursionInterceptor)this.interceptor);
        }
        catch (InterpolationException e) {
            throw new ExpressionEvaluationException("Interpolation failed for archiver expression: " + expression, (Throwable)e);
        }
    }
}

