/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class ManifestCreationFinalizer
extends AbstractArchiveFinalizer {
    private final MavenProject project;
    private final MavenSession session;
    private final MavenArchiveConfiguration archiveConfiguration;
    private final MavenArchiver mavenArchiver = new MavenArchiver();

    public ManifestCreationFinalizer(MavenSession session, MavenProject project, MavenArchiveConfiguration archiveConfiguration) {
        this.session = session;
        this.project = project;
        this.archiveConfiguration = archiveConfiguration;
    }

    public void finalizeArchiveCreation(Archiver archiver) {
        if (this.archiveConfiguration != null) {
            try {
                Manifest manifest;
                block14: {
                    File manifestFile = this.archiveConfiguration.getManifestFile();
                    if (manifestFile != null) {
                        try (FileInputStream in = new FileInputStream(manifestFile);){
                            manifest = new Manifest((InputStream)in);
                            break block14;
                        }
                        catch (FileNotFoundException e) {
                            throw new ArchiverException("Manifest not found: " + e.getMessage(), (Throwable)e);
                        }
                        catch (IOException e) {
                            throw new ArchiverException("Error processing manifest: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    manifest = this.mavenArchiver.getManifest(this.session, this.project, this.archiveConfiguration);
                }
                if (manifest != null && archiver instanceof JarArchiver) {
                    JarArchiver jarArchiver = (JarArchiver)archiver;
                    jarArchiver.addConfiguredManifest(manifest);
                }
            }
            catch (ManifestException e) {
                throw new ArchiverException("Error creating manifest: " + e.getMessage(), (Throwable)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new ArchiverException("Dependencies were not resolved: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<String> getVirtualFiles() {
        if (this.archiveConfiguration != null) {
            try {
                if (this.mavenArchiver.getManifest(this.project, this.archiveConfiguration.getManifest()) != null) {
                    return Collections.singletonList("META-INF/MANIFEST.MF");
                }
            }
            catch (DependencyResolutionRequiredException | ManifestException throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

