/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.jira.JiraHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.proxy.ProxyInfo;

public abstract class AbstractJiraDownloader {
    protected static final String UTF_8 = "UTF-8";
    protected Log log;
    protected File output;
    protected int nbEntriesMax;
    protected String filter;
    protected String fixVersionIds;
    protected String statusIds;
    protected String resolutionIds;
    protected String priorityIds;
    protected String component;
    protected String typeIds;
    protected String sortColumnNames;
    protected String jiraUser;
    protected String jiraPassword;
    protected String webUser;
    protected String webPassword;
    protected MavenProject project;
    protected Settings settings;
    protected boolean useJql;
    protected boolean onlyCurrentVersion;
    protected String versionPrefix;
    protected String jiraDatePattern;
    protected String proxyHost;
    protected int proxyPort;
    protected String proxyUser;
    protected String proxyPass;
    protected int connectionTimeout;
    protected int receiveTimout;

    public abstract void doExecute() throws Exception;

    protected boolean isJiraAuthenticationConfigured() {
        return this.jiraUser != null && this.jiraUser.length() > 0 && this.jiraPassword != null;
    }

    protected void getProxyInfo(String jiraUrl) {
        Proxy proxy = null;
        if (this.project == null) {
            this.getLog().error((CharSequence)"No project set. No proxy info available.");
            return;
        }
        if (this.settings != null) {
            proxy = this.settings.getActiveProxy();
        }
        if (proxy != null) {
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            URL url = null;
            try {
                url = new URL(jiraUrl);
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("Invalid JIRA URL: " + jiraUrl + ". " + e.getMessage()));
            }
            String jiraHost = null;
            if (url != null) {
                jiraHost = url.getHost();
            }
            if (JiraHelper.validateNonProxyHosts(proxyInfo, jiraHost)) {
                return;
            }
            this.proxyHost = this.settings.getActiveProxy().getHost();
            this.proxyPort = this.settings.getActiveProxy().getPort();
            this.proxyUser = this.settings.getActiveProxy().getUsername();
            this.proxyPass = this.settings.getActiveProxy().getPassword();
        }
    }

    protected String getFixFor() {
        if (this.onlyCurrentVersion && this.useJql) {
            String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.project.getVersion();
            if (version.endsWith("-SNAPSHOT")) {
                return version.substring(0, version.length() - "-SNAPSHOT".length());
            }
            return version;
        }
        return null;
    }

    public abstract List<Issue> getIssueList() throws MojoExecutionException;

    public void setJiraDatePattern(String jiraDatePattern) {
        this.jiraDatePattern = jiraDatePattern;
    }

    public void setOutput(File thisOutput) {
        this.output = thisOutput;
    }

    public File getOutput() {
        return this.output;
    }

    public void setMavenProject(Object thisProject) {
        this.project = (MavenProject)thisProject;
    }

    public void setNbEntries(int nbEntries) {
        this.nbEntriesMax = nbEntries;
    }

    public void setStatusIds(String thisStatusIds) {
        this.statusIds = thisStatusIds;
    }

    public void setPriorityIds(String thisPriorityIds) {
        this.priorityIds = thisPriorityIds;
    }

    public void setResolutionIds(String thisResolutionIds) {
        this.resolutionIds = thisResolutionIds;
    }

    public void setSortColumnNames(String thisSortColumnNames) {
        this.sortColumnNames = thisSortColumnNames;
    }

    public void setWebPassword(String thisWebPassword) {
        this.webPassword = thisWebPassword;
    }

    public void setWebUser(String thisWebUser) {
        this.webUser = thisWebUser;
    }

    public void setJiraPassword(String thisJiraPassword) {
        this.jiraPassword = thisJiraPassword;
    }

    public void setJiraUser(String thisJiraUser) {
        this.jiraUser = thisJiraUser;
    }

    public void setFilter(String thisFilter) {
        this.filter = thisFilter;
    }

    public void setComponent(String theseComponents) {
        this.component = theseComponents;
    }

    public void setFixVersionIds(String theseFixVersionIds) {
        this.fixVersionIds = theseFixVersionIds;
    }

    public void setTypeIds(String theseTypeIds) {
        this.typeIds = theseTypeIds;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected Log getLog() {
        return this.log;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isUseJql() {
        return this.useJql;
    }

    public void setUseJql(boolean useJql) {
        this.useJql = useJql;
    }

    public boolean isOnlyCurrentVersion() {
        return this.onlyCurrentVersion;
    }

    public void setOnlyCurrentVersion(boolean onlyCurrentVersion) {
        this.onlyCurrentVersion = onlyCurrentVersion;
    }

    public String getVersionPrefix() {
        return this.versionPrefix;
    }

    public void setVersionPrefix(String versionPrefix) {
        this.versionPrefix = versionPrefix;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReceiveTimout(int receiveTimout) {
        this.receiveTimout = receiveTimout;
    }
}

