/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.checkstyle.IconTool;
import org.apache.maven.plugins.checkstyle.RuleUtil;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleResults;
import org.codehaus.plexus.util.StringUtils;

public class CheckstyleReportGenerator {
    private Log log;
    private final File basedir;
    private final ResourceBundle bundle;
    private final Sink sink;
    private SeverityLevel severityLevel;
    private Configuration checkstyleConfig;
    private boolean enableRulesSummary;
    private boolean enableSeveritySummary;
    private boolean enableFilesSummary;
    private boolean enableRSS;
    private final SiteTool siteTool;
    private String xrefLocation;
    private List<String> treeWalkerNames = Collections.singletonList("TreeWalker");
    private final IconTool iconTool;
    private final String ruleset;

    public CheckstyleReportGenerator(Sink sink, ResourceBundle bundle, File basedir, SiteTool siteTool, String ruleset) {
        this.bundle = bundle;
        this.sink = sink;
        this.basedir = basedir;
        this.siteTool = siteTool;
        this.ruleset = ruleset;
        this.enableRulesSummary = true;
        this.enableSeveritySummary = true;
        this.enableFilesSummary = true;
        this.enableRSS = true;
        this.iconTool = new IconTool(sink, bundle);
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private String getTitle() {
        String title = this.getSeverityLevel() == null ? this.bundle.getString("report.checkstyle.title") : this.bundle.getString("report.checkstyle.severity_title") + this.severityLevel.getName();
        return title;
    }

    public void generateReport(CheckstyleResults results) {
        this.doHeading();
        if (this.getSeverityLevel() == null) {
            if (this.enableSeveritySummary) {
                this.doSeveritySummary(results);
            }
            if (this.enableFilesSummary) {
                this.doFilesSummary(results);
            }
            if (this.enableRulesSummary) {
                this.doRulesSummary(results);
            }
        }
        this.doDetails(results);
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    private void doHeading() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.checkstyle.checkstylelink") + " ");
        this.sink.link("http://checkstyle.sourceforge.net/");
        this.sink.text("Checkstyle");
        this.sink.link_();
        String version = this.getCheckstyleVersion();
        if (version != null) {
            this.sink.text(" ");
            this.sink.text(version);
        }
        this.sink.text(" ");
        this.sink.text(String.format(this.bundle.getString("report.checkstyle.ruleset"), this.ruleset));
        this.sink.text(".");
        if (this.enableRSS) {
            this.sink.nonBreakingSpace();
            this.sink.link("checkstyle.rss");
            this.sink.figure();
            this.sink.figureCaption();
            this.sink.text("rss feed");
            this.sink.figureCaption_();
            this.sink.figureGraphics("images/rss.png");
            this.sink.figure_();
            this.sink.link_();
        }
        this.sink.paragraph_();
        this.sink.section1_();
    }

    private String getConfigAttribute(Configuration config, ChainedItem<Configuration> parentConfiguration, String attributeName, String defaultValue) {
        String ret;
        try {
            ret = config.getAttribute(attributeName);
        }
        catch (CheckstyleException e) {
            ret = parentConfiguration != null ? this.getConfigAttribute((Configuration)((ChainedItem)parentConfiguration).value, ((ChainedItem)parentConfiguration).parent, attributeName, defaultValue) : defaultValue;
        }
        return ret;
    }

    private void doRulesSummary(CheckstyleResults results) {
        if (this.checkstyleConfig == null) {
            return;
        }
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.rules"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.rule.category"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.rule"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.violations"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.column.severity"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        if ("checker".equalsIgnoreCase(this.checkstyleConfig.getName())) {
            String category = null;
            for (ConfReference ref : this.sortConfiguration(results)) {
                this.doRuleRow(ref, results, category);
                category = ref.category;
            }
        } else {
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(this.bundle.getString("report.checkstyle.norule"));
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.table_();
        this.sink.section1_();
    }

    private void doRuleRow(ConfReference ref, CheckstyleResults results, String previousCategory) {
        Configuration checkerConfig = ref.configuration;
        ChainedItem parentConfiguration = ref.parentConfiguration;
        String ruleName = checkerConfig.getName();
        this.sink.tableRow();
        this.sink.tableCell();
        String category = ref.category;
        if (!category.equals(previousCategory)) {
            this.sink.text(category);
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (!"extension".equals(category)) {
            this.sink.link("http://checkstyle.sourceforge.net/config_" + category + ".html#" + ruleName);
            this.sink.text(ruleName);
            this.sink.link_();
        } else {
            this.sink.text(ruleName);
        }
        ArrayList<String> attribnames = new ArrayList<String>(Arrays.asList(checkerConfig.getAttributeNames()));
        attribnames.remove("severity");
        if (!attribnames.isEmpty()) {
            this.sink.list();
            for (String name : attribnames) {
                this.sink.listItem();
                this.sink.text(name);
                String value = this.getConfigAttribute(checkerConfig, null, name, "");
                if ("header".equals(name) && ("Header".equals(ruleName) || "RegexpHeader".equals(ruleName))) {
                    String[] lines = StringUtils.split((String)value, (String)"\\n");
                    int linenum = 1;
                    for (String line : lines) {
                        this.sink.lineBreak();
                        this.sink.rawText("<span style=\"color: gray\">");
                        this.sink.text(linenum + ":");
                        this.sink.rawText("</span>");
                        this.sink.nonBreakingSpace();
                        this.sink.monospaced();
                        this.sink.text(line);
                        this.sink.monospaced_();
                        ++linenum;
                    }
                } else if ("headerFile".equals(name) && "RegexpHeader".equals(ruleName)) {
                    this.sink.text(": ");
                    this.sink.monospaced();
                    this.sink.text("\"");
                    if (this.basedir != null) {
                        String path = this.siteTool.getRelativePath(value, this.basedir.getAbsolutePath());
                        this.sink.text(path.replace('\\', '/'));
                    } else {
                        this.sink.text(value);
                    }
                    this.sink.text("\"");
                    this.sink.monospaced_();
                } else {
                    this.sink.text(": ");
                    this.sink.monospaced();
                    this.sink.text("\"");
                    this.sink.text(value);
                    this.sink.text("\"");
                    this.sink.monospaced_();
                }
                this.sink.listItem_();
            }
            this.sink.list_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(ref.violations));
        this.sink.tableCell_();
        this.sink.tableCell();
        String severity = this.getConfigAttribute(checkerConfig, parentConfiguration, "severity", "error");
        this.iconTool.iconSeverity(severity, 1);
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    public boolean matchRule(AuditEvent event, String ruleName, String expectedMessage, String expectedSeverity) {
        if (!ruleName.equals(RuleUtil.getName(event))) {
            return false;
        }
        if (expectedMessage != null) {
            String msgWithoutSingleQuote = StringUtils.replace((String)expectedMessage, (String)"'", (String)"");
            if (!expectedMessage.equals(event.getMessage()) && !msgWithoutSingleQuote.equals(event.getMessage())) {
                return false;
            }
        }
        return expectedSeverity == null || expectedSeverity.equals(event.getSeverityLevel().getName());
    }

    private void doSeveritySummary(CheckstyleResults results) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.summary"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.files"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconTool.iconInfo(2);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconTool.iconWarning(2);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconTool.iconError(2);
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getFileCount()));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getSeverityCount(SeverityLevel.INFO)));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getSeverityCount(SeverityLevel.WARNING)));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getSeverityCount(SeverityLevel.ERROR)));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
        this.sink.section1_();
    }

    private void doFilesSummary(CheckstyleResults results) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.files"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.file"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconTool.iconInfo(3);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconTool.iconWarning(3);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.iconTool.iconError(3);
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        ArrayList<String> fileList = new ArrayList<String>(results.getFiles().keySet());
        Collections.sort(fileList);
        for (String filename : fileList) {
            List<AuditEvent> violations = results.getFileViolations(filename);
            if (violations.isEmpty()) continue;
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.link("#" + filename.replace('/', '.'));
            this.sink.text(filename);
            this.sink.link_();
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(results.getSeverityCount(violations, SeverityLevel.INFO)));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(results.getSeverityCount(violations, SeverityLevel.WARNING)));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(results.getSeverityCount(violations, SeverityLevel.ERROR)));
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.table_();
        this.sink.section1_();
    }

    private void doDetails(CheckstyleResults results) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.details"));
        this.sink.sectionTitle1_();
        ArrayList<String> fileList = new ArrayList<String>(results.getFiles().keySet());
        Collections.sort(fileList);
        for (String file : fileList) {
            List<AuditEvent> violations = results.getFileViolations(file);
            if (violations.isEmpty()) continue;
            this.sink.section2();
            SinkEventAttributeSet attrs = new SinkEventAttributeSet();
            attrs.addAttribute((Object)"id", (Object)file.replace('/', '.'));
            this.sink.sectionTitle(2, (SinkEventAttributes)attrs);
            this.sink.text(file);
            this.sink.sectionTitle_(2);
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.checkstyle.column.severity"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.checkstyle.rule.category"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.checkstyle.rule"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.checkstyle.column.message"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.checkstyle.column.line"));
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            this.doFileEvents(violations, file);
            this.sink.table_();
            this.sink.section2_();
        }
        this.sink.section1_();
    }

    private void doFileEvents(List<AuditEvent> eventList, String filename) {
        for (AuditEvent event : eventList) {
            SeverityLevel level = event.getSeverityLevel();
            if (this.getSeverityLevel() != null && this.getSeverityLevel() == level) continue;
            this.sink.tableRow();
            this.sink.tableCell();
            this.iconTool.iconSeverity(level.getName(), 1);
            this.sink.tableCell_();
            this.sink.tableCell();
            String category = RuleUtil.getCategory(event);
            if (category != null) {
                this.sink.text(category);
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            String ruleName = RuleUtil.getName(event);
            if (ruleName != null) {
                this.sink.text(ruleName);
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(event.getMessage());
            this.sink.tableCell_();
            this.sink.tableCell();
            int line = event.getLine();
            if (this.getXrefLocation() != null && line != 0) {
                this.sink.link(this.getXrefLocation() + "/" + filename.replaceAll("\\.java$", ".html") + "#L" + line);
                this.sink.text(String.valueOf(line));
                this.sink.link_();
            } else if (line != 0) {
                this.sink.text(String.valueOf(line));
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel;
    }

    public boolean isEnableRulesSummary() {
        return this.enableRulesSummary;
    }

    public void setEnableRulesSummary(boolean enableRulesSummary) {
        this.enableRulesSummary = enableRulesSummary;
    }

    public boolean isEnableSeveritySummary() {
        return this.enableSeveritySummary;
    }

    public void setEnableSeveritySummary(boolean enableSeveritySummary) {
        this.enableSeveritySummary = enableSeveritySummary;
    }

    public boolean isEnableFilesSummary() {
        return this.enableFilesSummary;
    }

    public void setEnableFilesSummary(boolean enableFilesSummary) {
        this.enableFilesSummary = enableFilesSummary;
    }

    public boolean isEnableRSS() {
        return this.enableRSS;
    }

    public void setEnableRSS(boolean enableRSS) {
        this.enableRSS = enableRSS;
    }

    public String getXrefLocation() {
        return this.xrefLocation;
    }

    public void setXrefLocation(String xrefLocation) {
        this.xrefLocation = xrefLocation;
    }

    public Configuration getCheckstyleConfig() {
        return this.checkstyleConfig;
    }

    public void setCheckstyleConfig(Configuration config) {
        this.checkstyleConfig = config;
    }

    public void setTreeWalkerNames(List<String> treeWalkerNames) {
        this.treeWalkerNames = treeWalkerNames;
    }

    public List<String> getTreeWalkerNames() {
        return this.treeWalkerNames;
    }

    private String getCheckstyleVersion() {
        Package checkstyleApiPackage = Configuration.class.getPackage();
        return checkstyleApiPackage == null ? null : checkstyleApiPackage.getImplementationVersion();
    }

    public List<ConfReference> sortConfiguration(CheckstyleResults results) {
        ArrayList<ConfReference> result = new ArrayList<ConfReference>();
        this.sortConfiguration(result, this.checkstyleConfig, null, results);
        Collections.sort(result);
        return result;
    }

    private void sortConfiguration(List<ConfReference> result, Configuration config, ChainedItem<Configuration> parent, CheckstyleResults results) {
        for (Configuration childConfig : config.getChildren()) {
            String ruleName = childConfig.getName();
            if (this.treeWalkerNames.contains(ruleName)) {
                this.sortConfiguration(result, childConfig, new ChainedItem<Configuration>(config, parent), results);
                continue;
            }
            String fixedmessage = this.getConfigAttribute(childConfig, null, "message", null);
            String configSeverity = this.getConfigAttribute(childConfig, null, "severity", null);
            long violations = 0L;
            AuditEvent lastMatchedEvent = null;
            for (List<AuditEvent> errors : results.getFiles().values()) {
                for (AuditEvent event : errors) {
                    if (!this.matchRule(event, ruleName, fixedmessage, configSeverity)) continue;
                    lastMatchedEvent = event;
                    ++violations;
                }
            }
            if (violations <= 0L) continue;
            String category = RuleUtil.getCategory(lastMatchedEvent);
            result.add(new ConfReference(category, childConfig, parent, violations, result.size()));
        }
    }

    private static class ChainedItem<T> {
        private final ChainedItem<T> parent;
        private final T value;

        ChainedItem(T value, ChainedItem<T> parent) {
            this.parent = parent;
            this.value = value;
        }
    }

    private static class ConfReference
    implements Comparable<ConfReference> {
        private final String category;
        private final Configuration configuration;
        private final ChainedItem<Configuration> parentConfiguration;
        private final long violations;
        private final int count;

        ConfReference(String category, Configuration configuration, ChainedItem<Configuration> parentConfiguration, long violations, int count) {
            this.category = category;
            this.configuration = configuration;
            this.parentConfiguration = parentConfiguration;
            this.violations = violations;
            this.count = count;
        }

        @Override
        public int compareTo(ConfReference o) {
            int compare = this.category.compareTo(o.category);
            if (compare == 0) {
                compare = this.configuration.getName().compareTo(o.configuration.getName());
            }
            return compare == 0 ? o.count - this.count : compare;
        }
    }
}

