/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.clean;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.clean.Selector;
import org.apache.maven.shared.utils.Os;
import org.eclipse.aether.SessionData;

class Cleaner {
    private static final boolean ON_WINDOWS = Os.isFamily((String)"windows");
    private static final String LAST_DIRECTORY_TO_DELETE = Cleaner.class.getName() + ".lastDirectoryToDelete";
    private final MavenSession session;
    private final Logger logDebug;
    private final Logger logInfo;
    private final Logger logVerbose;
    private final Logger logWarn;
    private final File fastDir;
    private final String fastMode;

    Cleaner(MavenSession session, Log log, boolean verbose, File fastDir, String fastMode) {
        this.logDebug = log == null || !log.isDebugEnabled() ? null : arg_0 -> ((Log)log).debug(arg_0);
        this.logInfo = log == null || !log.isInfoEnabled() ? null : arg_0 -> ((Log)log).info(arg_0);
        this.logWarn = log == null || !log.isWarnEnabled() ? null : arg_0 -> ((Log)log).warn(arg_0);
        this.logVerbose = verbose ? this.logInfo : this.logDebug;
        this.session = session;
        this.fastDir = fastDir;
        this.fastMode = fastMode;
    }

    public void delete(File basedir, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        File file;
        if (!basedir.isDirectory()) {
            if (!basedir.exists()) {
                if (this.logDebug != null) {
                    this.logDebug.log("Skipping non-existing directory " + basedir);
                }
                return;
            }
            throw new IOException("Invalid base directory " + basedir);
        }
        if (this.logInfo != null) {
            this.logInfo.log("Deleting " + basedir + (selector != null ? " (" + selector + ")" : ""));
        }
        File file2 = file = followSymlinks ? basedir : basedir.getCanonicalFile();
        if (selector == null && !followSymlinks && this.fastDir != null && this.session != null && this.fastDelete(file)) {
            return;
        }
        this.delete(file, "", selector, followSymlinks, failOnError, retryOnError);
    }

    private boolean fastDelete(File baseDirFile) {
        Path baseDir = baseDirFile.toPath();
        Path fastDir = this.fastDir.toPath();
        if (fastDir.toAbsolutePath().startsWith(baseDir.toAbsolutePath())) {
            try {
                String prefix = baseDir.getFileName().toString() + ".";
                Path tmpDir = Files.createTempDirectory(baseDir.getParent(), prefix, new FileAttribute[0]);
                try {
                    Files.move(baseDir, tmpDir, StandardCopyOption.REPLACE_EXISTING);
                    if (this.session != null) {
                        this.session.getRepositorySession().getData().set((Object)LAST_DIRECTORY_TO_DELETE, (Object)baseDir.toFile());
                    }
                    baseDir = tmpDir;
                }
                catch (IOException e) {
                    Files.delete(tmpDir);
                    throw e;
                }
            }
            catch (IOException e) {
                if (this.logDebug != null) {
                    this.logDebug.log("Unable to fast delete directory: " + e);
                }
                return false;
            }
        }
        try {
            if (!Files.isDirectory(fastDir, new LinkOption[0])) {
                Files.createDirectories(fastDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            if (this.logDebug != null) {
                this.logDebug.log("Unable to fast delete directory as the path " + fastDir + " does not point to a directory or cannot be created: " + e);
            }
            return false;
        }
        try {
            Path tmpDir = Files.createTempDirectory(fastDir, "", new FileAttribute[0]);
            Path dstDir = tmpDir.resolve(baseDir.getFileName());
            Files.move(baseDir, dstDir, StandardCopyOption.ATOMIC_MOVE);
            BackgroundCleaner.delete(this, tmpDir.toFile(), this.fastMode);
            return true;
        }
        catch (IOException e) {
            if (this.logDebug != null) {
                this.logDebug.log("Unable to fast delete directory: " + e);
            }
            return false;
        }
    }

    private Result delete(File file, String pathname, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        Result result = new Result();
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            if (selector == null || selector.couldHoldSelected(pathname)) {
                File canonical;
                boolean isSymlink = Files.isSymbolicLink(file.toPath());
                File file2 = canonical = followSymlinks ? file : file.getCanonicalFile();
                if (followSymlinks || !isSymlink) {
                    String[] filenames = canonical.list();
                    if (filenames != null) {
                        String prefix = pathname.length() > 0 ? pathname + File.separatorChar : "";
                        for (int i = filenames.length - 1; i >= 0; --i) {
                            String filename = filenames[i];
                            File child = new File(canonical, filename);
                            result.update(this.delete(child, prefix + filename, selector, followSymlinks, failOnError, retryOnError));
                        }
                    }
                } else if (this.logDebug != null) {
                    this.logDebug.log("Not recursing into symlink " + file);
                }
            } else if (this.logDebug != null) {
                this.logDebug.log("Not recursing into directory without included files " + file);
            }
        }
        if (!result.excluded && (selector == null || selector.isSelected(pathname))) {
            if (this.logVerbose != null) {
                if (isDirectory) {
                    this.logVerbose.log("Deleting directory " + file);
                } else if (file.exists()) {
                    this.logVerbose.log("Deleting file " + file);
                } else {
                    this.logVerbose.log("Deleting dangling symlink " + file);
                }
            }
            result.failures += this.delete(file, failOnError, retryOnError);
        } else {
            result.excluded = true;
        }
        return result;
    }

    private int delete(File file, boolean failOnError, boolean retryOnError) throws IOException {
        if (!file.delete()) {
            boolean deleted = false;
            if (retryOnError) {
                if (ON_WINDOWS) {
                    System.gc();
                }
                int[] delays = new int[]{50, 250, 750};
                for (int i = 0; !deleted && i < delays.length; ++i) {
                    try {
                        Thread.sleep(delays[i]);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    deleted = file.delete() || !file.exists();
                }
            } else {
                boolean bl = deleted = !file.exists();
            }
            if (!deleted) {
                if (failOnError) {
                    throw new IOException("Failed to delete " + file);
                }
                if (this.logWarn != null) {
                    this.logWarn.log("Failed to delete " + file);
                }
                return 1;
            }
        }
        return 0;
    }

    static class SpyInvocationHandler
    implements InvocationHandler {
        private final ExecutionListener delegate;

        SpyInvocationHandler(ExecutionListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("sessionEnded".equals(method.getName())) {
                BackgroundCleaner.sessionEnd();
            }
            if (this.delegate != null) {
                return method.invoke((Object)this.delegate, args);
            }
            return null;
        }
    }

    private static class BackgroundCleaner
    extends Thread {
        private static BackgroundCleaner instance;
        private final Deque<File> filesToDelete = new ArrayDeque<File>();
        private final Cleaner cleaner;
        private final String fastMode;
        private static final int NEW = 0;
        private static final int RUNNING = 1;
        private static final int STOPPED = 2;
        private int status = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void delete(Cleaner cleaner, File dir, String fastMode) {
            Class<BackgroundCleaner> clazz = BackgroundCleaner.class;
            synchronized (BackgroundCleaner.class) {
                if (instance == null || !instance.doDelete(dir)) {
                    instance = new BackgroundCleaner(cleaner, dir, fastMode);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void sessionEnd() {
            Class<BackgroundCleaner> clazz = BackgroundCleaner.class;
            synchronized (BackgroundCleaner.class) {
                if (instance != null) {
                    instance.doSessionEnd();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private BackgroundCleaner(Cleaner cleaner, File dir, String fastMode) {
            super("mvn-background-cleaner");
            this.cleaner = cleaner;
            this.fastMode = fastMode;
            this.init(cleaner.fastDir, dir);
        }

        @Override
        public void run() {
            File basedir;
            while ((basedir = this.pollNext()) != null) {
                try {
                    this.cleaner.delete(basedir, "", null, false, false, true);
                }
                catch (IOException iOException) {}
            }
        }

        synchronized void init(File fastDir, File dir) {
            File[] children;
            if (fastDir.isDirectory() && (children = fastDir.listFiles()) != null && children.length > 0) {
                for (File child : children) {
                    this.doDelete(child);
                }
            }
            this.doDelete(dir);
        }

        synchronized File pollNext() {
            File basedir = this.filesToDelete.poll();
            if (basedir == null) {
                SessionData data;
                File lastDir;
                if (this.cleaner.session != null && (lastDir = (File)(data = this.cleaner.session.getRepositorySession().getData()).get((Object)LAST_DIRECTORY_TO_DELETE)) != null) {
                    data.set((Object)LAST_DIRECTORY_TO_DELETE, null);
                    return lastDir;
                }
                this.status = 2;
                this.notifyAll();
            }
            return basedir;
        }

        synchronized boolean doDelete(File dir) {
            if (this.status == 2) {
                return false;
            }
            this.filesToDelete.add(dir);
            if (this.status == 0 && "background".equals(this.fastMode)) {
                this.status = 1;
                this.notifyAll();
                this.start();
            }
            this.wrapExecutionListener();
            return true;
        }

        private void wrapExecutionListener() {
            ExecutionListener executionListener = this.cleaner.session.getRequest().getExecutionListener();
            if (executionListener == null || !Proxy.isProxyClass(executionListener.getClass()) || !(Proxy.getInvocationHandler(executionListener) instanceof SpyInvocationHandler)) {
                ExecutionListener listener = (ExecutionListener)Proxy.newProxyInstance(ExecutionListener.class.getClassLoader(), new Class[]{ExecutionListener.class}, (InvocationHandler)new SpyInvocationHandler(executionListener));
                this.cleaner.session.getRequest().setExecutionListener(listener);
            }
        }

        synchronized void doSessionEnd() {
            if (this.status != 2) {
                if (this.status == 0) {
                    this.start();
                }
                if (!"defer".equals(this.fastMode)) {
                    try {
                        this.cleaner.logInfo.log("Waiting for background file deletion");
                        while (this.status != 2) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static interface Logger {
        public void log(CharSequence var1);
    }

    private static class Result {
        private int failures;
        private boolean excluded;

        private Result() {
        }

        public void update(Result result) {
            this.failures += result.failures;
            this.excluded |= result.excluded;
        }
    }
}

