/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.plugin.MojoException;

public class IncrementalBuildHelper {
    private static final String MAVEN_STATUS_ROOT = "maven-status";
    public static final String CREATED_FILES_LST_FILENAME = "createdFiles.lst";
    private static final String INPUT_FILES_LST_FILENAME = "inputFiles.lst";
    private final String mojoStatusPath;
    private final Set<Path> sources;
    private final Path directory;
    private final Path outputDirectory;
    private List<Path> filesBeforeAction = Collections.emptyList();

    public IncrementalBuildHelper(String mojoStatusPath, Set<Path> sources, Path directory, Path outputDirectory) {
        if (mojoStatusPath == null) {
            throw new IllegalArgumentException("MojoExecution must not be null!");
        }
        this.mojoStatusPath = mojoStatusPath;
        this.sources = sources;
        this.directory = directory;
        this.outputDirectory = outputDirectory;
    }

    public Path getMojoStatusDirectory() throws MojoException {
        Path mojoStatusDir = this.directory.resolve(this.mojoStatusPath);
        try {
            Files.createDirectories(mojoStatusDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoException("Unable to create directory: " + String.valueOf(mojoStatusDir), (Throwable)e);
        }
        return mojoStatusDir;
    }

    public boolean inputFileTreeChanged(List<String> added, List<String> removed) {
        Path mojoConfigBase = this.getMojoStatusDirectory();
        Path mojoConfigFile = mojoConfigBase.resolve(INPUT_FILES_LST_FILENAME);
        List<Object> oldInputFiles = Collections.emptyList();
        if (Files.exists(mojoConfigFile, new LinkOption[0])) {
            try {
                oldInputFiles = Files.readAllLines(mojoConfigFile);
            }
            catch (IOException e) {
                throw new MojoException("Error reading old mojo status " + String.valueOf(mojoConfigFile), (Throwable)e);
            }
        }
        List newFiles = this.sources.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList());
        List<Object> previousFiles = oldInputFiles;
        newFiles.stream().filter(s -> !previousFiles.contains(s)).forEach(added::add);
        previousFiles.stream().filter(s -> !newFiles.contains(s)).forEach(removed::add);
        try {
            Files.write(mojoConfigFile, added, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoException("Error while storing the mojo status", (Throwable)e);
        }
        return added.size() + removed.size() > 0;
    }

    public void beforeRebuildExecution() {
        block10: {
            Path mojoConfigBase = this.getMojoStatusDirectory();
            Path mojoConfigFile = mojoConfigBase.resolve(CREATED_FILES_LST_FILENAME);
            try {
                if (Files.exists(mojoConfigFile, new LinkOption[0])) {
                    for (String oldFileName : Files.readAllLines(mojoConfigFile)) {
                        Path oldFile = this.outputDirectory.resolve(oldFileName);
                        Files.deleteIfExists(oldFile);
                    }
                }
                if (!Files.exists(this.outputDirectory, new LinkOption[0])) break block10;
                try (Stream<Path> walk = Files.walk(this.outputDirectory, new FileVisitOption[0]);){
                    this.filesBeforeAction = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                }
            }
            catch (IOException e) {
                throw new MojoException("Error reading old mojo status", (Throwable)e);
            }
        }
    }

    public void afterRebuildExecution() {
        Path mojoConfigBase = this.getMojoStatusDirectory();
        Path mojoConfigFile = mojoConfigBase.resolve(CREATED_FILES_LST_FILENAME);
        try (Stream<Path> walk = Files.walk(this.outputDirectory, new FileVisitOption[0]);){
            List added = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> !this.filesBeforeAction.contains(p)).map(Path::toString).collect(Collectors.toList());
            Files.write(mojoConfigFile, added, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoException("Error while storing the mojo status", (Throwable)e);
        }
        mojoConfigFile = mojoConfigBase.resolve(INPUT_FILES_LST_FILENAME);
        if (!Files.exists(mojoConfigFile, new LinkOption[0])) {
            try {
                Files.write(mojoConfigFile, (Iterable<? extends CharSequence>)this.sources.stream().map(Path::toString).collect(Collectors.toList()), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoException("Error while storing the mojo status", (Throwable)e);
            }
        }
    }
}

