/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.lang.model.SourceVersion;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.Tool;
import javax.tools.ToolProvider;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.Toolchain;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.api.services.ToolchainManager;
import org.apache.maven.plugin.compiler.ByteCodeTransformer;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.CompilationTaskSources;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.plugin.compiler.DiagnosticLogger;
import org.apache.maven.plugin.compiler.ForkedCompiler;
import org.apache.maven.plugin.compiler.IncrementalBuild;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.PathFilter;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourceFile;
import org.apache.maven.plugin.compiler.SourcesForRelease;

public abstract class AbstractCompilerMojo
implements Mojo {
    static final boolean SUPPORT_LEGACY = true;
    private static final String DEFAULT_EXECUTABLE = "javac";
    private static final Locale LOCALE = null;
    @Parameter(property="maven.compiler.moduleVersion", defaultValue="${project.version}")
    protected String moduleVersion;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="maven.compiler.source")
    protected String source;
    @Parameter(property="maven.compiler.target")
    protected String target;
    @Parameter(property="maven.compiler.release")
    protected String release;
    @Parameter(property="maven.compiler.enablePreview", defaultValue="false")
    protected boolean enablePreview;
    @Parameter
    protected List<String> compilerArgs;
    @Parameter
    @Deprecated(since="4.0.0")
    protected String compilerArgument;
    @Parameter(property="maven.compiler.proc")
    protected String proc;
    @Parameter
    protected String[] annotationProcessors;
    @Parameter
    @Deprecated(since="4.0.0")
    protected List<DependencyCoordinate> annotationProcessorPaths;
    @Parameter(defaultValue="false")
    protected boolean annotationProcessorPathsUseDepMgmt;
    @Parameter(property="maven.compiler.createMissingPackageInfoClass", defaultValue="false")
    protected boolean createMissingPackageInfoClass;
    @Parameter(property="maven.compiler.implicit")
    protected String implicit;
    @Parameter(property="maven.compiler.parameters", defaultValue="false")
    protected boolean parameters;
    @Parameter(property="maven.compiler.debug", defaultValue="true")
    protected boolean debug = true;
    @Parameter(property="maven.compiler.debuglevel")
    protected String debuglevel;
    @Deprecated(forRemoval=true)
    @Parameter(property="maven.compiler.optimize")
    protected Boolean optimize;
    @Parameter(property="maven.compiler.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="maven.compiler.showCompilationChanges", defaultValue="false")
    protected boolean showCompilationChanges;
    @Parameter(property="maven.compiler.showDeprecation", defaultValue="false")
    protected boolean showDeprecation;
    @Parameter(property="maven.compiler.showWarnings", defaultValue="true")
    protected boolean showWarnings = true;
    @Parameter(property="maven.compiler.failOnWarning", defaultValue="false")
    protected boolean failOnWarning;
    @Parameter(property="maven.compiler.failOnError", defaultValue="true")
    protected boolean failOnError = true;
    @Parameter
    @Deprecated(since="4.0.0", forRemoval=true)
    protected String outputFileName;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;
    @Parameter(defaultValue="options,dependencies,sources")
    protected String incrementalCompilation;
    @Deprecated(since="4.0.0")
    @Parameter(property="maven.compiler.useIncrementalCompilation")
    protected Boolean useIncrementalCompilation;
    @Parameter
    protected List<String> fileExtensions;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    protected int staleMillis;
    @Parameter(property="maven.compiler.fork", defaultValue="false")
    protected boolean fork;
    @Parameter
    protected Map<String, String> jdkToolchain;
    @Parameter(property="maven.compiler.compilerId")
    protected String compilerId;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.compilerVersion")
    protected String compilerVersion;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.forceLegacyJavacApi")
    protected Boolean forceLegacyJavacApi;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.forceJavacCompilerUse")
    protected Boolean forceJavacCompilerUse;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.compilerReuseStrategy")
    protected String compilerReuseStrategy;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.skipMultiThreadWarning")
    protected Boolean skipMultiThreadWarning;
    @Parameter(property="maven.compiler.executable")
    protected String executable;
    @Parameter(property="maven.compiler.meminitial")
    protected String meminitial;
    @Parameter(property="maven.compiler.maxmem")
    protected String maxmem;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    protected Path basedir;
    @Parameter(defaultValue="${project.build.directory}/maven-status/${mojo.plugin.descriptor.artifactId}/${mojo.executionId}.cache", required=true, readonly=true)
    protected Path mojoStatusPath;
    @Inject
    protected Session session;
    @Inject
    protected Project project;
    @Inject
    protected ProjectManager projectManager;
    @Inject
    protected ArtifactManager artifactManager;
    @Inject
    protected ToolchainManager toolchainManager;
    @Inject
    protected MessageBuilderFactory messageBuilderFactory;
    @Inject
    protected Log logger;
    private String mavenCompilerPluginVersion;
    private String tipForCommandLineCompilation;
    final boolean isTestCompile;

    private Charset charset() {
        if (this.encoding != null) {
            try {
                return Charset.forName(this.encoding);
            }
            catch (UnsupportedCharsetException e) {
                throw new CompilationFailureException("Invalid 'encoding' option: " + this.encoding, e);
            }
        }
        return null;
    }

    protected AbstractCompilerMojo(boolean isTestCompile) {
        this.isTestCompile = isTestCompile;
    }

    @Nonnull
    protected abstract List<Path> getCompileSourceRoots();

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();

    protected abstract Set<String> getIncrementalExcludes();

    @Nonnull
    protected abstract Path getOutputDirectory();

    @Nullable
    protected String getSource() {
        return this.source;
    }

    @Nullable
    protected String getTarget() {
        return this.target;
    }

    @Nullable
    protected String getRelease() {
        return this.release;
    }

    @Nullable
    protected abstract Path getGeneratedSourcesDirectory();

    boolean hasModuleDeclaration(List<SourceDirectory> roots) throws IOException {
        for (SourceDirectory root : roots) {
            if (!root.getModuleInfo().isPresent()) continue;
            return true;
        }
        return false;
    }

    protected void addImplicitDependencies(Map<PathType, List<Path>> addTo, boolean hasModuleDeclaration) throws IOException {
    }

    void addSourceDirectories(Map<PathType, List<Path>> addTo, List<SourceDirectory> compileSourceRoots) throws IOException {
    }

    protected void addModuleOptions(DependencyResolverResult dependencies, Options addTo) throws IOException {
    }

    @Nullable
    protected abstract String getDebugFileName();

    final Path getDebugFilePath() {
        String filename = this.getDebugFileName();
        if (filename == null || filename.isBlank()) {
            return null;
        }
        return Path.of(this.project.getBuild().getOutputDirectory(), new String[0]).resolveSibling(filename);
    }

    public void execute() throws MojoException {
        JavaCompiler compiler = this.compiler();
        Options compilerConfiguration = this.acceptParameters(compiler);
        try {
            this.compile(compiler, compilerConfiguration);
        }
        catch (RuntimeException e) {
            int s;
            String message = e.getLocalizedMessage();
            if (message == null) {
                message = e.getClass().getSimpleName();
            } else if (e instanceof MojoException && (s = message.indexOf(System.lineSeparator())) >= 0) {
                message = message.substring(0, s);
            }
            MessageBuilder mb = this.messageBuilderFactory.builder().strong((Object)"COMPILATION ERROR: ").a((CharSequence)message);
            this.logger.error((CharSequence)mb.toString(), (Throwable)(e instanceof CompilationFailureException ? null : e));
            if (this.tipForCommandLineCompilation != null) {
                this.logger.info((CharSequence)this.tipForCommandLineCompilation);
                this.tipForCommandLineCompilation = null;
            }
            if (this.failOnError) {
                throw e;
            }
        }
        catch (IOException e) {
            this.logger.error((CharSequence)"I/O error while compiling the project.", (Throwable)e);
            throw new CompilationFailureException("I/O error while compiling the project.", e);
        }
    }

    private JavaCompiler compiler() throws MojoException {
        this.getToolchain().ifPresent(tc -> {
            this.logger.info((CharSequence)("Toolchain in maven-compiler-plugin is \"" + String.valueOf(tc) + "\"."));
            if (this.executable != null) {
                this.logger.warn((CharSequence)("Toolchains are ignored because the 'executable' parameter is set to \"" + this.executable + "\"."));
            } else {
                this.fork = true;
                if (this.compilerId == null) {
                    this.compilerId = DEFAULT_EXECUTABLE;
                }
                this.executable = tc.findTool(this.compilerId);
            }
        });
        if (this.fork) {
            if (this.executable == null) {
                this.executable = DEFAULT_EXECUTABLE;
            }
            return new ForkedCompiler(this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Using " + (String)(this.compilerId != null ? "compiler \"" + this.compilerId + "\"" : "system compiler") + "."));
        }
        if (this.compilerId == null) {
            this.compilerId = DEFAULT_EXECUTABLE;
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler != null) {
                return compiler;
            }
        } else {
            for (JavaCompiler t : ServiceLoader.load(JavaCompiler.class)) {
                if (!this.compilerId.equals(t.name())) continue;
                return t;
            }
        }
        throw new CompilationFailureException("No such \"" + this.compilerId + "\" compiler.");
    }

    protected Options acceptParameters(OptionChecker compiler) {
        Options compilerConfiguration = new Options(compiler, this.logger);
        compilerConfiguration.addIfNonBlank("--source", this.getSource());
        boolean targetOrReleaseSet = compilerConfiguration.addIfNonBlank("--target", this.getTarget());
        if (!(targetOrReleaseSet |= compilerConfiguration.addIfNonBlank("--release", this.getRelease())) && !this.isTestCompile) {
            MessageBuilder mb = this.messageBuilderFactory.builder().a((CharSequence)"No explicit value set for --release or --target. To ensure the same result in different environments, please add").newline().newline();
            this.writePlugin(mb, "release", String.valueOf(Runtime.version().feature()));
            this.logger.warn((CharSequence)mb.build());
        }
        compilerConfiguration.addIfTrue("--enable-preview", this.enablePreview);
        compilerConfiguration.addComaSeparated("-proc", this.proc, List.of("none", "only", "full"), null);
        if (this.annotationProcessors != null) {
            StringJoiner list = new StringJoiner(",");
            for (String p : this.annotationProcessors) {
                list.add(p);
            }
            compilerConfiguration.addIfNonBlank("-processor", list.toString());
        }
        compilerConfiguration.addComaSeparated("-implicit", this.implicit, List.of("none", "class"), null);
        compilerConfiguration.addIfTrue("-parameters", this.parameters);
        compilerConfiguration.addIfTrue("-Xpkginfo:always", this.createMissingPackageInfoClass);
        if (this.debug) {
            compilerConfiguration.addComaSeparated("-g", this.debuglevel, List.of("lines", "vars", "source", "all", "none"), options -> Arrays.asList(options).contains("all") ? new String[]{} : options);
        } else {
            compilerConfiguration.addIfTrue("-g:none", true);
        }
        compilerConfiguration.addIfNonBlank("--module-version", this.moduleVersion);
        compilerConfiguration.addIfTrue("-deprecation", this.showDeprecation);
        compilerConfiguration.addIfTrue("-nowarn", !this.showWarnings);
        compilerConfiguration.addIfTrue("-Werror", this.failOnWarning);
        compilerConfiguration.addIfTrue("-verbose", this.verbose);
        if (this.fork) {
            compilerConfiguration.addMemoryValue("-J-Xms", "meminitial", this.meminitial, true);
            compilerConfiguration.addMemoryValue("-J-Xmx", "maxmem", this.maxmem, true);
        }
        return compilerConfiguration;
    }

    CompilationTaskSources[] toCompilationTasks(SourcesForRelease unit) {
        return new CompilationTaskSources[]{new CompilationTaskSources(unit.files)};
    }

    private void compile(JavaCompiler compiler, Options compilerConfiguration) throws IOException {
        Path moduleDescriptor;
        boolean hasModuleDeclaration;
        EnumSet<IncrementalBuild.Aspect> incAspects = this.useIncrementalCompilation != null ? (this.useIncrementalCompilation != false ? EnumSet.of(IncrementalBuild.Aspect.SOURCES, IncrementalBuild.Aspect.ADDITIONS, IncrementalBuild.Aspect.DEPENDENCIES) : EnumSet.of(IncrementalBuild.Aspect.CLASSES)) : IncrementalBuild.Aspect.parse(this.incrementalCompilation);
        List<Object> sourceFiles = List.of();
        Path outputDirectory = Files.createDirectories(this.getOutputDirectory(), new FileAttribute[0]);
        List<SourceDirectory> compileSourceRoots = SourceDirectory.fromPaths(this.getCompileSourceRoots(), outputDirectory);
        if (incAspects.contains((Object)IncrementalBuild.Aspect.MODULES)) {
            for (SourceDirectory root : compileSourceRoots) {
                if (root.moduleName != null) continue;
                throw new CompilationFailureException("The <incrementalCompilation> value can be \"modules\" only if all source directories are Java modules.");
            }
            if (!(this.getIncludes().isEmpty() && this.getExcludes().isEmpty() && this.getIncrementalExcludes().isEmpty())) {
                throw new CompilationFailureException("Include and exclude filters cannot be specified when <incrementalCompilation> is set to \"modules\".");
            }
            hasModuleDeclaration = true;
        } else {
            PathFilter filter = new PathFilter(this.getIncludes(), this.getExcludes(), this.getIncrementalExcludes());
            sourceFiles = filter.walkSourceFiles(compileSourceRoots);
            if (sourceFiles.isEmpty()) {
                Object message = "No sources to compile.";
                try {
                    Files.delete(outputDirectory);
                }
                catch (DirectoryNotEmptyException e) {
                    message = (String)message + " However, the output directory is not empty.";
                }
                this.logger.info((CharSequence)message);
                return;
            }
            switch (this.project.getPackaging().type().id()) {
                case "classpath-jar": {
                    hasModuleDeclaration = false;
                    break;
                }
                case "modular-jar": {
                    hasModuleDeclaration = true;
                    break;
                }
                default: {
                    hasModuleDeclaration = this.hasModuleDeclaration(compileSourceRoots);
                }
            }
        }
        Set<Path> generatedSourceDirectories = this.addGeneratedSourceDirectory(this.getGeneratedSourcesDirectory());
        Map<PathType, List<Path>> dependencies = this.resolveDependencies(compilerConfiguration, hasModuleDeclaration);
        this.resolveProcessorPathEntries(dependencies);
        this.addImplicitDependencies(dependencies, hasModuleDeclaration);
        boolean checkSources = incAspects.contains((Object)IncrementalBuild.Aspect.SOURCES);
        boolean checkClasses = incAspects.contains((Object)IncrementalBuild.Aspect.CLASSES);
        boolean checkDepends = incAspects.contains((Object)IncrementalBuild.Aspect.DEPENDENCIES);
        boolean bl = incAspects.contains((Object)IncrementalBuild.Aspect.OPTIONS);
        boolean rebuildOnAdd = incAspects.contains((Object)IncrementalBuild.Aspect.ADDITIONS);
        if (checkSources | checkClasses | checkDepends | bl) {
            IncrementalBuild incrementalBuild = new IncrementalBuild(this, sourceFiles);
            String causeOfRebuild = null;
            if (checkSources) {
                causeOfRebuild = incrementalBuild.inputFileTreeChanges(this.staleMillis, rebuildOnAdd);
            }
            if (checkClasses && causeOfRebuild == null) {
                causeOfRebuild = incrementalBuild.markNewOrModifiedSources(this.staleMillis, rebuildOnAdd);
            }
            if (checkDepends && causeOfRebuild == null) {
                if (this.fileExtensions == null || this.fileExtensions.isEmpty()) {
                    this.fileExtensions = List.of("class", "jar");
                }
                causeOfRebuild = incrementalBuild.dependencyChanges(dependencies.values(), this.fileExtensions);
            }
            int optionsHash = 0;
            if (bl) {
                optionsHash = compilerConfiguration.options.hashCode();
                if (causeOfRebuild == null) {
                    causeOfRebuild = incrementalBuild.optionChanges(optionsHash);
                }
            }
            if (causeOfRebuild != null) {
                this.logger.info((CharSequence)causeOfRebuild);
            } else {
                sourceFiles = incrementalBuild.getModifiedSources();
                if (IncrementalBuild.isEmptyOrIgnorable(sourceFiles)) {
                    this.logger.info((CharSequence)"Nothing to compile - all classes are up to date.");
                    return;
                }
            }
            if (checkSources | checkDepends | bl) {
                incrementalBuild.writeCache(optionsHash, checkSources);
            }
        }
        if (this.logger.isDebugEnabled()) {
            int n = sourceFiles.size();
            StringBuilder sb = new StringBuilder(n * 40).append("Compiling ").append(n).append(" source files:");
            for (SourceFile sourceFile : sourceFiles) {
                sb.append(System.lineSeparator()).append("    ").append(sourceFile);
            }
            this.logger.debug((CharSequence)sb);
        }
        if (hasModuleDeclaration) {
            this.addSourceDirectories(dependencies, compileSourceRoots);
        }
        boolean success = true;
        Exception failureCause = null;
        ArrayList<Path> unresolvedPaths = new ArrayList<Path>();
        StringWriter stringWriter = new StringWriter();
        DiagnosticLogger listener = new DiagnosticLogger(this.logger, this.messageBuilderFactory, LOCALE);
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(listener, LOCALE, this.charset());){
            List<String> patchedOptions = compilerConfiguration.options;
            for (Map.Entry<PathType, List<Path>> entry : dependencies.entrySet()) {
                JavaPathType.Modular type;
                Optional location;
                List<Path> list = entry.getValue();
                PathType pathType = entry.getKey();
                if (pathType instanceof JavaPathType) {
                    JavaPathType type2 = (JavaPathType)pathType;
                    location = type2.location();
                    if (location.isPresent()) {
                        fileManager.setLocationFromPaths((JavaFileManager.Location)location.get(), list);
                        continue;
                    }
                } else if (pathType instanceof JavaPathType.Modular && (location = (type = (JavaPathType.Modular)pathType).rawType().location()).isPresent()) {
                    try {
                        fileManager.setLocationForModule((JavaFileManager.Location)location.get(), type.moduleName(), list);
                    }
                    catch (UnsupportedOperationException e) {
                        if (patchedOptions == compilerConfiguration.options) {
                            patchedOptions = new ArrayList<String>(patchedOptions);
                        }
                        patchedOptions.addAll(Arrays.asList(type.option(list)));
                    }
                    continue;
                }
                unresolvedPaths.addAll(list);
            }
            if (!unresolvedPaths.isEmpty()) {
                StringBuilder sb = new StringBuilder("Cannot determine where to place the following artifacts:");
                for (Path path : unresolvedPaths) {
                    sb.append(System.lineSeparator()).append(" - ").append(path);
                }
                this.logger.warn((CharSequence)sb);
            }
            if (!generatedSourceDirectories.isEmpty()) {
                fileManager.setLocationFromPaths(StandardLocation.SOURCE_OUTPUT, generatedSourceDirectories);
            }
            block28: for (SourcesForRelease sourcesForRelease : SourcesForRelease.groupByReleaseAndModule(sourceFiles)) {
                for (Map.Entry<String, Set<Path>> entry : sourcesForRelease.roots.entrySet()) {
                    String moduleName = entry.getKey();
                    if (moduleName.isBlank()) {
                        fileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, (Collection<? extends Path>)entry.getValue());
                        continue;
                    }
                    fileManager.setLocationForModule(StandardLocation.MODULE_SOURCE_PATH, moduleName, (Collection<? extends Path>)entry.getValue());
                }
                fileManager.setLocationFromPaths(StandardLocation.CLASS_OUTPUT, Set.of(outputDirectory));
                for (CompilationTaskSources c2 : this.toCompilationTasks(sourcesForRelease)) {
                    Iterable<? extends JavaFileObject> sources = fileManager.getJavaFileObjectsFromPaths((Collection<? extends Path>)c2.files);
                    JavaCompiler.CompilationTask compilationTask = compiler.getTask(stringWriter, fileManager, listener, patchedOptions, null, sources);
                    patchedOptions = compilerConfiguration.options;
                    success = c2.compile(compilationTask);
                    if (!success) break block28;
                }
            }
            listener.logSummary();
        }
        catch (UncheckedIOException e) {
            success = false;
            failureCause = e.getCause();
        }
        catch (Exception e) {
            success = false;
            failureCause = e;
        }
        String additionalMessage = stringWriter.toString();
        if (!additionalMessage.isBlank()) {
            if (success || failureCause != null) {
                this.logger.warn((CharSequence)additionalMessage);
            } else {
                this.logger.error((CharSequence)additionalMessage);
            }
        }
        if (failureCause != null) {
            String message = failureCause.getMessage();
            if (message != null) {
                this.logger.error((CharSequence)message);
            } else {
                this.logger.error((Throwable)failureCause);
            }
        }
        if (!success || this.logger.isDebugEnabled()) {
            IOException suppressed = null;
            try {
                this.writeDebugFile(compilerConfiguration.options, dependencies, sourceFiles);
                if (success && this.tipForCommandLineCompilation != null) {
                    this.logger.debug((CharSequence)this.tipForCommandLineCompilation);
                    this.tipForCommandLineCompilation = null;
                }
            }
            catch (IOException e) {
                suppressed = e;
            }
            if (!success) {
                StringBuilder message = new StringBuilder(100).append("Cannot compile ").append(this.project.getId()).append(' ').append(this.isTestCompile ? "test" : "main").append(" classes.");
                listener.firstError(failureCause).ifPresent(c -> message.append(System.lineSeparator()).append("The first error is: ").append((String)c));
                CompilationFailureException compilationFailureException = new CompilationFailureException(message.toString(), failureCause);
                if (suppressed != null) {
                    compilationFailureException.addSuppressed(suppressed);
                }
                throw compilationFailureException;
            }
            if (suppressed != null) {
                throw suppressed;
            }
        }
        if (!AbstractCompilerMojo.isVersionEqualOrNewer(compiler, "RELEASE_22") && Files.isRegularFile(moduleDescriptor = this.getOutputDirectory().resolve("module-info.class"), new LinkOption[0])) {
            try {
                byte[] oridinal = Files.readAllBytes(moduleDescriptor);
                byte[] byArray = ByteCodeTransformer.patchJdkModuleVersion(oridinal, this.getRelease(), this.logger);
                if (byArray != null) {
                    Files.write(moduleDescriptor, byArray, new OpenOption[0]);
                }
            }
            catch (IOException ex) {
                throw new MojoException("Error reading or writing module-info.class", (Throwable)ex);
            }
        }
    }

    private static boolean isVersionEqualOrNewer(Tool tool, String sourceVersion) {
        SourceVersion requested;
        try {
            requested = SourceVersion.valueOf(sourceVersion);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return tool.getSourceVersions().stream().anyMatch(v -> v.compareTo(requested) >= 0);
    }

    private Optional<Toolchain> getToolchain() {
        List tcs;
        if (this.jdkToolchain != null && (tcs = this.toolchainManager.getToolchains(this.session, "jdk", this.jdkToolchain)) != null && !tcs.isEmpty()) {
            return Optional.of((Toolchain)tcs.get(0));
        }
        return this.toolchainManager.getToolchainFromBuildContext(this.session, "jdk");
    }

    final String parseModuleInfoName(Path source) throws IOException {
        if (source != null && Files.exists(source, new LinkOption[0])) {
            Charset charset = this.charset();
            try (BufferedReader in = charset != null ? Files.newBufferedReader(source, charset) : Files.newBufferedReader(source);){
                int t;
                StreamTokenizer tokenizer = new StreamTokenizer(in);
                tokenizer.slashSlashComments(true);
                tokenizer.slashStarComments(true);
                while ((t = tokenizer.nextToken()) != -1) {
                    if (t != -3 || !"module".equals(tokenizer.sval)) continue;
                    while ((t = tokenizer.nextToken()) == 10) {
                    }
                    if (t != -3) break;
                    String string = tokenizer.sval;
                    return string;
                }
            }
        }
        return null;
    }

    private Map<PathType, List<Path>> resolveDependencies(Options compilerConfiguration, boolean hasModuleDeclaration) throws IOException {
        String warning;
        DependencyResolver resolver = (DependencyResolver)this.session.getService(DependencyResolver.class);
        if (resolver == null) {
            return new LinkedHashMap<PathType, List<Path>>();
        }
        EnumSet<JavaPathType> allowedTypes = EnumSet.of(JavaPathType.CLASSES, JavaPathType.PROCESSOR_CLASSES);
        if (hasModuleDeclaration) {
            allowedTypes.add(JavaPathType.MODULES);
            allowedTypes.add(JavaPathType.PROCESSOR_MODULES);
        }
        DependencyResolverResult dependencies = resolver.resolve(DependencyResolverRequest.builder().session(this.session).project(this.project).requestType(DependencyResolverRequest.RequestType.RESOLVE).pathScope(this.isTestCompile ? PathScope.TEST_COMPILE : PathScope.MAIN_COMPILE).pathTypeFilter(allowedTypes).build());
        Object exception = null;
        for (Exception cause : dependencies.getExceptions()) {
            if (exception != null) {
                exception.addSuppressed(cause);
                continue;
            }
            if (cause instanceof UncheckedIOException) {
                UncheckedIOException e = (UncheckedIOException)cause;
                exception = e.getCause();
                continue;
            }
            if (cause instanceof RuntimeException || cause instanceof IOException) {
                exception = cause;
                continue;
            }
            exception = new CompilationFailureException("Cannot collect the compile-time dependencies.", cause);
        }
        if (exception != null) {
            if (exception instanceof IOException) {
                IOException e = (IOException)exception;
                throw e;
            }
            throw (RuntimeException)exception;
        }
        if (!this.isTestCompile && (warning = (String)dependencies.warningForFilenameBasedAutomodules().orElse(null)) != null) {
            this.logger.warn((CharSequence)warning);
        }
        if (hasModuleDeclaration) {
            this.addModuleOptions(dependencies, compilerConfiguration);
        }
        return dependencies.getDispatchedPaths();
    }

    @Deprecated(since="4.0.0")
    private void resolveProcessorPathEntries(Map<PathType, List<Path>> addTo) throws MojoException {
        List<DependencyCoordinate> dependencies = this.annotationProcessorPaths;
        if (dependencies != null && !dependencies.isEmpty()) {
            try {
                List<DependencyCoordinates> coords = dependencies.stream().map(coord -> coord.toCoordinate(this.project, this.session)).toList();
                Session sessionWithRepo = this.session.withRemoteRepositories(this.projectManager.getRemoteProjectRepositories(this.project));
                addTo.merge((PathType)JavaPathType.PROCESSOR_CLASSES, ((DependencyResolver)sessionWithRepo.getService(DependencyResolver.class)).resolve(DependencyResolverRequest.builder().session(sessionWithRepo).dependencies(coords).managedDependencies(this.project.getManagedDependencies()).requestType(DependencyResolverRequest.RequestType.RESOLVE).pathScope(PathScope.MAIN_RUNTIME).build()).getPaths(), (oldPaths, newPaths) -> {
                    oldPaths.addAll(newPaths);
                    return oldPaths;
                });
            }
            catch (MojoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationFailureException("Resolution of annotationProcessorPath dependencies failed: " + e.getMessage(), e);
            }
        }
    }

    private Set<Path> addGeneratedSourceDirectory(Path generatedSourcesDirectory) throws IOException {
        if (generatedSourcesDirectory == null) {
            return Set.of();
        }
        if ("none".equalsIgnoreCase(this.proc) && Files.notExists(generatedSourcesDirectory, new LinkOption[0])) {
            return Set.of();
        }
        generatedSourcesDirectory = Files.createDirectories(generatedSourcesDirectory, new FileAttribute[0]);
        ProjectScope scope = this.isTestCompile ? ProjectScope.TEST : ProjectScope.MAIN;
        this.projectManager.addCompileSourceRoot(this.project, scope, generatedSourcesDirectory.toAbsolutePath());
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Adding \"").append(generatedSourcesDirectory).append("\" to ").append(scope.id()).append("-compile source roots. New roots are:");
            for (Path p : this.projectManager.getCompileSourceRoots(this.project, scope)) {
                sb.append(System.lineSeparator()).append("    ").append(p);
            }
            this.logger.debug((CharSequence)sb.toString());
        }
        return Set.of(generatedSourcesDirectory);
    }

    private void writePlugin(MessageBuilder mb, String option, String value) {
        if (this.mavenCompilerPluginVersion == null) {
            try (InputStream is = AbstractCompilerMojo.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
                if (is != null) {
                    this.mavenCompilerPluginVersion = new Manifest(is).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.mavenCompilerPluginVersion == null) {
                this.mavenCompilerPluginVersion = "";
            }
        }
        mb.a((CharSequence)"    <plugin>").newline();
        mb.a((CharSequence)"      <groupId>org.apache.maven.plugins</groupId>").newline();
        mb.a((CharSequence)"      <artifactId>maven-compiler-plugin</artifactId>").newline();
        if (this.mavenCompilerPluginVersion != null && !this.mavenCompilerPluginVersion.isBlank()) {
            mb.a((CharSequence)"      <version>").a((CharSequence)this.mavenCompilerPluginVersion).a((CharSequence)"</version>").newline();
        }
        mb.a((CharSequence)"      <configuration>").newline();
        mb.a((CharSequence)"        <").a((CharSequence)option).a((Object)Character.valueOf('>')).a((CharSequence)value).a((CharSequence)"</").a((CharSequence)option).a((Object)Character.valueOf('>')).newline();
        mb.a((CharSequence)"      </configuration>").newline();
        mb.a((CharSequence)"    </plugin>").newline();
    }

    private void writeDebugFile(List<String> options, Map<PathType, List<Path>> dependencies, List<SourceFile> sourceFiles) throws IOException {
        Path path = this.getDebugFilePath();
        if (path == null) {
            this.logger.warn((CharSequence)"The <debugFileName> parameter should not be empty.");
            return;
        }
        StringBuilder commandLine = new StringBuilder("For trying to compile from the command-line, use:").append(System.lineSeparator()).append("    ").append(this.executable != null ? this.executable : this.compilerId);
        boolean hasOptions = false;
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (String string : options) {
                boolean needsQuote;
                if (string.isBlank()) continue;
                if (string.startsWith("-J")) {
                    commandLine.append(' ').append(string);
                    continue;
                }
                if (hasOptions) {
                    if (string.charAt(0) == '-') {
                        out.newLine();
                    } else {
                        out.write(32);
                    }
                }
                boolean bl = needsQuote = string.indexOf(32) >= 0;
                if (needsQuote) {
                    out.write(34);
                }
                out.write(string);
                if (needsQuote) {
                    out.write(34);
                }
                hasOptions = true;
            }
            if (hasOptions) {
                out.newLine();
            }
            for (Map.Entry entry : dependencies.entrySet()) {
                String separator = "";
                for (String element : ((PathType)entry.getKey()).option((Iterable)entry.getValue())) {
                    out.write(separator);
                    out.write(element);
                    separator = " ";
                }
                out.newLine();
            }
            out.write("-d \"");
            out.write(this.getOutputDirectory().toString());
            out.write(34);
            out.newLine();
            for (SourceFile sourceFile : sourceFiles) {
                out.write(34);
                out.write(sourceFile.file.toString());
                out.write(34);
                out.newLine();
            }
        }
        this.tipForCommandLineCompilation = commandLine.append(" @").append(path).toString();
    }
}

