/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.services.DependencyCoordinatesFactory;
import org.apache.maven.api.services.DependencyCoordinatesFactoryRequest;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.DependencyExclusion;

@Deprecated(since="4.0.0")
public final class DependencyCoordinate {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type = "jar";
    private Set<DependencyExclusion> exclusions;

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.type, this.exclusions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DependencyCoordinate)) return false;
        DependencyCoordinate other = (DependencyCoordinate)obj;
        if (!Objects.equals(this.groupId, other.groupId)) return false;
        if (!Objects.equals(this.artifactId, other.artifactId)) return false;
        if (!Objects.equals(this.version, other.version)) return false;
        if (!Objects.equals(this.classifier, other.classifier)) return false;
        if (!Objects.equals(this.type, other.type)) return false;
        if (!Objects.equals(this.exclusions, other.exclusions)) return false;
        return true;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + (String)(this.version != null ? ":" + this.version : "") + (String)(this.classifier != null ? ":" + this.classifier : "") + (String)(this.type != null ? "." + this.type : "");
    }

    DependencyCoordinates toCoordinate(Project project, Session session) {
        return ((DependencyCoordinatesFactory)session.getService(DependencyCoordinatesFactory.class)).create(DependencyCoordinatesFactoryRequest.builder().session(session).groupId(this.groupId).artifactId(this.artifactId).classifier(this.classifier).type(this.type).version(this.version).version(this.getAnnotationProcessorPathVersion(project)).exclusions(DependencyCoordinate.toExclusions(this.exclusions)).build());
    }

    private String getAnnotationProcessorPathVersion(Project project) throws MojoException {
        if (this.version != null) {
            return this.version;
        }
        if (this.classifier == null) {
            this.classifier = "";
        }
        List managedDependencies = project.getManagedDependencies();
        return this.findManagedVersion(managedDependencies).orElseThrow(() -> new CompilationFailureException(String.format("Cannot find version for annotation processor path '%s'.%nThe version needs to be either provided directly in the plugin configuration or via dependency management.", this)));
    }

    private Optional<String> findManagedVersion(List<DependencyCoordinates> managedDependencies) {
        return managedDependencies.stream().filter(dep -> Objects.equals(dep.getGroupId(), this.groupId) && Objects.equals(dep.getArtifactId(), this.artifactId) && Objects.equals(dep.getClassifier(), this.classifier) && Objects.equals(dep.getType().id(), this.type)).findAny().map(d -> d.getVersionConstraint().asString());
    }

    private static Collection<Exclusion> toExclusions(Set<DependencyExclusion> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            return List.of();
        }
        return exclusions.stream().map(e -> new Exclusion((DependencyExclusion)e){
            final /* synthetic */ DependencyExclusion val$e;
            {
                this.val$e = dependencyExclusion;
            }

            public String getGroupId() {
                return this.val$e.groupId;
            }

            public String getArtifactId() {
                return this.val$e.artifactId;
            }
        }).toList();
    }
}

