/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractDependencyMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.resolvers.DefaultArtifactsResolver;
import org.apache.maven.plugin.dependency.utils.translators.ClassifierTypeTranslator;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyFilterMojo
extends AbstractDependencyMojo {
    protected boolean excludeTransitive;
    protected String includeTypes;
    protected String excludeTypes;
    protected String includeScope;
    protected String excludeScope;
    protected String includeClassifiers;
    protected String excludeClassifiers;
    protected String classifier;
    protected String type;
    protected String excludeArtifactIds;
    protected String includeArtifactIds;
    protected String excludeGroupIds;
    protected String includeGroupIds;
    protected File markersDirectory;
    protected boolean overWriteReleases;
    protected boolean overWriteSnapshots;
    protected boolean overWriteIfNewer;
    protected boolean prependGroupId = false;

    protected abstract ArtifactsFilter getMarkedArtifactFilter();

    protected Set<Artifact> getResolvedDependencies(boolean stopOnFailure) throws MojoExecutionException {
        DependencyStatusSets status = this.getDependencySets(stopOnFailure);
        return status.getResolvedDependencies();
    }

    protected DependencyStatusSets getDependencySets(boolean stopOnFailure) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.project.getDependencyArtifacts(), this.excludeTransitive));
        filter.addFilter((ArtifactsFilter)new ScopeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeScope), DependencyUtil.cleanToBeTokenizedString(this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeTypes), DependencyUtil.cleanToBeTokenizedString(this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(DependencyUtil.cleanToBeTokenizedString(this.includeClassifiers), DependencyUtil.cleanToBeTokenizedString(this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeGroupIds), DependencyUtil.cleanToBeTokenizedString(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeArtifactIds), DependencyUtil.cleanToBeTokenizedString(this.excludeArtifactIds)));
        Set artifacts = this.project.getArtifacts();
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        DependencyStatusSets status = null;
        status = StringUtils.isNotEmpty((String)this.classifier) ? this.getClassifierTranslatedDependencies(artifacts, stopOnFailure) : this.filterMarkedDependencies(artifacts);
        return status;
    }

    protected DependencyStatusSets getClassifierTranslatedDependencies(Set<Artifact> artifacts, boolean stopOnFailure) throws MojoExecutionException {
        HashSet<Artifact> unResolvedArtifacts = new HashSet<Artifact>();
        Set<Artifact> resolvedArtifacts = artifacts;
        DependencyStatusSets status = new DependencyStatusSets();
        if (StringUtils.isNotEmpty((String)this.classifier)) {
            ClassifierTypeTranslator translator = new ClassifierTypeTranslator(this.classifier, this.type, this.factory);
            artifacts = translator.translate(artifacts, this.getLog());
            status = this.filterMarkedDependencies(artifacts);
            artifacts = status.getResolvedDependencies();
            DefaultArtifactsResolver artifactsResolver = new DefaultArtifactsResolver(this.resolver, this.getLocal(), this.remoteRepos, stopOnFailure);
            resolvedArtifacts = artifactsResolver.resolve(artifacts, this.getLog());
            unResolvedArtifacts.addAll(artifacts);
            unResolvedArtifacts.removeAll(resolvedArtifacts);
        }
        status.setResolvedDependencies(resolvedArtifacts);
        status.setUnResolvedDependencies(unResolvedArtifacts);
        return status;
    }

    protected DependencyStatusSets filterMarkedDependencies(Set<Artifact> artifacts) throws MojoExecutionException {
        Set unMarkedArtifacts;
        FilterArtifacts filter = new FilterArtifacts();
        filter.clearFilters();
        filter.addFilter(this.getMarkedArtifactFilter());
        try {
            unMarkedArtifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        HashSet<Artifact> skippedArtifacts = new HashSet<Artifact>();
        skippedArtifacts.addAll(artifacts);
        skippedArtifacts.removeAll(unMarkedArtifacts);
        return new DependencyStatusSets(unMarkedArtifacts, null, skippedArtifacts);
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }

    public boolean isPrependGroupId() {
        return this.prependGroupId;
    }

    public void setPrependGroupId(boolean prependGroupId) {
        this.prependGroupId = prependGroupId;
    }
}

