/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class DependencyStatusSets {
    Set<Artifact> resolvedDependencies = null;
    Set<Artifact> unResolvedDependencies = null;
    Set<Artifact> skippedDependencies = null;

    public DependencyStatusSets() {
    }

    public DependencyStatusSets(Set<Artifact> resolved, Set<Artifact> unResolved, Set<Artifact> skipped) {
        if (resolved != null) {
            this.resolvedDependencies = new LinkedHashSet<Artifact>(resolved);
        }
        if (unResolved != null) {
            this.unResolvedDependencies = new LinkedHashSet<Artifact>(unResolved);
        }
        if (skipped != null) {
            this.skippedDependencies = new LinkedHashSet<Artifact>(skipped);
        }
    }

    public Set<Artifact> getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    public void setResolvedDependencies(Set<Artifact> resolvedDependencies) {
        this.resolvedDependencies = resolvedDependencies != null ? new LinkedHashSet<Artifact>(resolvedDependencies) : null;
    }

    public Set<Artifact> getSkippedDependencies() {
        return this.skippedDependencies;
    }

    public void setSkippedDependencies(Set<Artifact> skippedDependencies) {
        this.skippedDependencies = skippedDependencies != null ? new LinkedHashSet<Artifact>(skippedDependencies) : null;
    }

    public Set<Artifact> getUnResolvedDependencies() {
        return this.unResolvedDependencies;
    }

    public void setUnResolvedDependencies(Set<Artifact> unResolvedDependencies) {
        this.unResolvedDependencies = unResolvedDependencies != null ? new LinkedHashSet<Artifact>(unResolvedDependencies) : null;
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename) {
        return this.getOutput(outputAbsoluteArtifactFilename, true);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope) {
        return this.getOutput(outputAbsoluteArtifactFilename, outputScope, false);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope, boolean sort) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("The following files have been resolved:\n");
        if (this.resolvedDependencies == null || this.resolvedDependencies.isEmpty()) {
            sb.append("   none\n");
        } else {
            sb.append((CharSequence)this.buildArtifactListOutput(this.resolvedDependencies, outputAbsoluteArtifactFilename, outputScope, sort));
        }
        if (this.skippedDependencies != null && !this.skippedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files were skipped:\n");
            LinkedHashSet<Artifact> skippedDependencies = new LinkedHashSet<Artifact>();
            skippedDependencies.addAll(this.skippedDependencies);
            sb.append((CharSequence)this.buildArtifactListOutput(skippedDependencies, outputAbsoluteArtifactFilename, outputScope, sort));
        }
        if (this.unResolvedDependencies != null && !this.unResolvedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files have NOT been resolved:\n");
            LinkedHashSet<Artifact> unResolvedDependencies = new LinkedHashSet<Artifact>();
            unResolvedDependencies.addAll(this.unResolvedDependencies);
            sb.append((CharSequence)this.buildArtifactListOutput(unResolvedDependencies, outputAbsoluteArtifactFilename, outputScope, sort));
        }
        sb.append("\n");
        return sb.toString();
    }

    private StringBuilder buildArtifactListOutput(Set<Artifact> artifacts, boolean outputAbsoluteArtifactFilename, boolean outputScope, boolean sort) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> artifactStringList = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            ModuleDescriptor moduleDescriptor;
            String artifactFilename = null;
            if (outputAbsoluteArtifactFilename) {
                try {
                    artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                }
                catch (NullPointerException e) {
                    artifactFilename = null;
                }
            }
            String id = outputScope ? artifact.toString() : artifact.getId();
            String optionalMarker = "";
            if (outputScope && artifact.isOptional()) {
                optionalMarker = " (optional) ";
            }
            String moduleNameMarker = "";
            if (artifact.getFile() != null && (moduleDescriptor = this.getModuleDescriptor(artifact.getFile())) != null) {
                moduleNameMarker = " -- module " + moduleDescriptor.name;
                if (moduleDescriptor.automatic) {
                    moduleNameMarker = moduleNameMarker + " (auto)";
                }
            }
            artifactStringList.add("   " + id + (outputAbsoluteArtifactFilename ? ":" + artifactFilename : "") + optionalMarker + moduleNameMarker + "\n");
        }
        if (sort) {
            Collections.sort(artifactStringList);
        }
        for (String artifactString : artifactStringList) {
            sb.append(artifactString);
        }
        return sb;
    }

    private ModuleDescriptor getModuleDescriptor(File artifactFile) {
        ModuleDescriptor moduleDescriptor = null;
        try {
            Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
            Path path = artifactFile.toPath();
            Method ofMethod = moduleFinderClass.getDeclaredMethod("of", Path[].class);
            Object moduleFinderInstance = ofMethod.invoke(null, new Object[]{new Path[]{path}});
            Method findAllMethod = moduleFinderClass.getDeclaredMethod("findAll", new Class[0]);
            Set moduleReferences = (Set)findAllMethod.invoke(moduleFinderInstance, new Object[0]);
            Object moduleReference = moduleReferences.iterator().next();
            Method descriptorMethod = moduleReference.getClass().getDeclaredMethod("descriptor", new Class[0]);
            Object moduleDescriptorInstance = descriptorMethod.invoke(moduleReference, new Object[0]);
            Method nameMethod = moduleDescriptorInstance.getClass().getDeclaredMethod("name", new Class[0]);
            String name = (String)nameMethod.invoke(moduleDescriptorInstance, new Object[0]);
            moduleDescriptor = new ModuleDescriptor();
            moduleDescriptor.name = name;
            Method isAutomaticMethod = moduleDescriptorInstance.getClass().getDeclaredMethod("isAutomatic", new Class[0]);
            moduleDescriptor.automatic = (Boolean)isAutomaticMethod.invoke(moduleDescriptorInstance, new Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return moduleDescriptor;
    }

    private class ModuleDescriptor {
        String name;
        boolean automatic = true;

        private ModuleDescriptor() {
        }
    }
}

