/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.maven.plugins.dependency.tree.AbstractVerboseGraphSerializer;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

class VerboseGraphDotSerializer
extends AbstractVerboseGraphSerializer {
    VerboseGraphDotSerializer() {
    }

    @Override
    public String serialize(DependencyNode root) {
        HashSet<String> coordinateStrings = new HashSet<String>();
        HashMap<String, String> coordinateVersionMap = new HashMap<String, String>();
        Map<DependencyNode, String> nodeErrors = this.getNodeConflictMessagesBfs(root, coordinateStrings, coordinateVersionMap);
        HashSet<DependencyNode> visitedNodes = new HashSet<DependencyNode>();
        LinkedList<DependencyNode> queue = new LinkedList<DependencyNode>();
        queue.add(root);
        Artifact rootArtifact = root.getArtifact();
        StringBuilder result = new StringBuilder("digraph");
        result.append(" \"").append(rootArtifact.getGroupId()).append(":").append(rootArtifact.getArtifactId()).append(":").append(rootArtifact.getExtension()).append(":").append(rootArtifact.getVersion());
        if (root.getData().containsKey("ContainsModule")) {
            result.append(" WARNING: this tree contains a submodule. Once it reaches the submodule will print in nonVerbose fashion, to see the actual submodule verbose output refer to the rest of the output");
        }
        result.append("\" {").append("\n");
        while (!queue.isEmpty()) {
            DependencyNode node = (DependencyNode)queue.poll();
            for (DependencyNode child : node.getChildren()) {
                result.append(" \"");
                String coordString = "";
                boolean messageAdded = false;
                if (child.getArtifact().getProperties().containsKey("preManagedVersion")) {
                    coordString = coordString + " - version managed from " + (String)child.getArtifact().getProperties().get("preManagedVersion");
                    messageAdded = true;
                }
                if (child.getArtifact().getProperties().containsKey("preManagedScope")) {
                    if (messageAdded) {
                        coordString = coordString + "; ";
                    } else {
                        coordString = coordString + " - ";
                        messageAdded = true;
                    }
                    coordString = coordString + "scope managed from " + (String)child.getArtifact().getProperties().get("preManagedScope");
                }
                coordString = VerboseGraphDotSerializer.getDependencyCoordinate(child) + coordString;
                result.append(VerboseGraphDotSerializer.getDependencyCoordinate(node)).append("\"").append(" -> \"").append(coordString);
                if (child.getArtifact().getProperties().containsKey("Cycle")) {
                    if (!messageAdded) {
                        result.append(" -");
                    }
                    result.append(" omitted due to cycle");
                } else if (nodeErrors.get(child) != null) {
                    if (!messageAdded) {
                        result.append(" - ");
                    }
                    result.append(nodeErrors.get(child));
                } else if (!visitedNodes.contains(child)) {
                    visitedNodes.add(child);
                    queue.add(child);
                }
                result.append("\" ;").append("\n");
            }
        }
        result.append("}");
        return result.toString();
    }
}

