/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.analyze;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.analyze.AnalyzeReportView;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

@Mojo(name="analyze-report", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class AnalyzeReportMojo
extends AbstractMavenReport {
    @Component
    private ProjectDependencyAnalyzer analyzer;
    @Parameter(property="ignoreNonCompile", defaultValue="false")
    private boolean ignoreNonCompile;
    @Parameter
    private String[] usedDependencies;
    @Parameter(property="mdep.analyze.skip", defaultValue="false")
    private boolean skip;

    public void executeReport(Locale locale) throws MavenReportException {
        ProjectDependencyAnalysis analysis;
        try {
            analysis = this.analyzer.analyze(this.project);
            if (this.usedDependencies != null) {
                analysis = analysis.forceDeclaredDependenciesUsage(this.usedDependencies);
            }
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MavenReportException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        if (this.ignoreNonCompile) {
            analysis = analysis.ignoreNonCompile();
        }
        Sink sink = this.getSink();
        ResourceBundle bundle = this.getBundle(locale);
        AnalyzeReportView analyzethis = new AnalyzeReportView();
        analyzethis.generateReport(analysis, sink, bundle);
    }

    public boolean canGenerateReport() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return false;
        }
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return false;
        }
        return true;
    }

    public String getOutputName() {
        return "dependency-analysis";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("analyze.report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("analyze.report.description");
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("analyze-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

