/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.resolvers.AbstractResolveMojo;
import org.apache.maven.plugins.dependency.resolvers.ExcludeReactorProjectsArtifactFilter;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;

@Mojo(name="resolve-plugins", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolvePluginsMojo
extends AbstractResolveMojo {
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="outputAbsoluteArtifactFilename", defaultValue="false")
    private boolean outputAbsoluteArtifactFilename;

    @Override
    protected void doExecute() throws MojoExecutionException {
        block13: {
            try {
                Set<org.apache.maven.artifact.Artifact> plugins = this.resolvePluginArtifacts();
                StringBuilder sb = new StringBuilder();
                sb.append(System.lineSeparator());
                sb.append("The following plugins have been resolved:");
                sb.append(System.lineSeparator());
                if (plugins == null || plugins.isEmpty()) {
                    sb.append("   none");
                    sb.append(System.lineSeparator());
                    break block13;
                }
                for (org.apache.maven.artifact.Artifact plugin : plugins) {
                    String artifactFilename = null;
                    if (this.outputAbsoluteArtifactFilename) {
                        try {
                            artifactFilename = plugin.getFile().getAbsoluteFile().getPath();
                        }
                        catch (NullPointerException e) {
                            artifactFilename = null;
                        }
                    }
                    String id = plugin.toString();
                    sb.append("   ").append(id).append(this.outputAbsoluteArtifactFilename ? ":" + artifactFilename : "").append(System.lineSeparator());
                    if (this.excludeTransitive) continue;
                    DefaultDependableCoordinate pluginCoordinate = new DefaultDependableCoordinate();
                    pluginCoordinate.setGroupId(plugin.getGroupId());
                    pluginCoordinate.setArtifactId(plugin.getArtifactId());
                    pluginCoordinate.setVersion(plugin.getVersion());
                    for (org.apache.maven.artifact.Artifact artifact : this.resolveArtifactDependencies((DependableCoordinate)pluginCoordinate)) {
                        artifactFilename = null;
                        if (this.outputAbsoluteArtifactFilename) {
                            try {
                                artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                            }
                            catch (NullPointerException e) {
                                artifactFilename = null;
                            }
                        }
                        id = artifact.toString();
                        sb.append("      ").append(id).append(this.outputAbsoluteArtifactFilename ? ":" + artifactFilename : "").append(System.lineSeparator());
                    }
                }
                sb.append(System.lineSeparator());
                String output = sb.toString();
                if (this.outputFile == null) {
                    DependencyUtil.log(output, this.getLog());
                } else {
                    String encoding = Objects.toString(this.outputEncoding, "UTF-8");
                    DependencyUtil.write(output, this.outputFile, this.appendOutput, encoding);
                }
            }
            catch (IOException | ArtifactFilterException | ArtifactResolverException | DependencyResolverException | ArtifactResolutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private Set<org.apache.maven.artifact.Artifact> resolveArtifactDependencies(DependableCoordinate artifact) throws DependencyResolverException {
        ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
        Iterable artifactResults = this.getDependencyResolver().resolveDependencies(buildingRequest, artifact, null);
        LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        for (ArtifactResult artifactResult : artifactResults) {
            artifacts.add(artifactResult.getArtifact());
        }
        return artifacts;
    }

    private FilterArtifacts getArtifactsFilter() {
        FilterArtifacts filter = new FilterArtifacts();
        if (this.excludeReactor) {
            filter.addFilter((ArtifactsFilter)new ExcludeReactorProjectsArtifactFilter(this.reactorProjects, this.getLog()));
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeScope), DependencyUtil.cleanToBeTokenizedString(this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeTypes), DependencyUtil.cleanToBeTokenizedString(this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(DependencyUtil.cleanToBeTokenizedString(this.includeClassifiers), DependencyUtil.cleanToBeTokenizedString(this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeGroupIds), DependencyUtil.cleanToBeTokenizedString(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeArtifactIds), DependencyUtil.cleanToBeTokenizedString(this.excludeArtifactIds)));
        return filter;
    }

    private Set<org.apache.maven.artifact.Artifact> resolvePluginArtifacts() throws ArtifactFilterException, ArtifactResolverException, ArtifactResolutionException {
        Set plugins = this.getProject().getPluginArtifacts();
        Set reports = this.getProject().getReportArtifacts();
        Set artifacts = new HashSet();
        artifacts.addAll(reports);
        artifacts.addAll(plugins);
        FilterArtifacts filter = this.getArtifactsFilter();
        artifacts = filter.filter(artifacts);
        HashSet<org.apache.maven.artifact.Artifact> result = new HashSet<org.apache.maven.artifact.Artifact>();
        for (org.apache.maven.artifact.Artifact artifact : new LinkedHashSet(artifacts)) {
            Artifact resolveArtifact = this.getResolverUtil().resolveArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact), this.getProject().getRemotePluginRepositories());
            result.add(RepositoryUtils.toArtifact((Artifact)resolveArtifact));
        }
        return result;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

