/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugins.ear.util.InvalidJavaEEVersion;

public class JavaEEVersion
implements Comparable<JavaEEVersion> {
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_5 = "5";
    private static final String VERSION_6 = "6";
    private static final String VERSION_7 = "7";
    private static final String VERSION_8 = "8";
    private static final Map<String, JavaEEVersion> VERSION_MAP = new HashMap<String, JavaEEVersion>();
    public static final JavaEEVersion ONE_DOT_THREE = new JavaEEVersion(0, "1.3");
    public static final JavaEEVersion ONE_DOT_FOUR = new JavaEEVersion(1, "1.4");
    public static final JavaEEVersion FIVE = new JavaEEVersion(2, "5");
    public static final JavaEEVersion SIX = new JavaEEVersion(3, "6");
    public static final JavaEEVersion SEVEN = new JavaEEVersion(4, "7");
    public static final JavaEEVersion EIGHT = new JavaEEVersion(5, "8");
    private final Integer index;
    private final String version;

    private JavaEEVersion(Integer index, String version) {
        this.index = index;
        this.version = version;
        VERSION_MAP.put(version, this);
    }

    public static JavaEEVersion getJavaEEVersion(String paramVersion) throws InvalidJavaEEVersion {
        if (!JavaEEVersion.isValid(paramVersion)) {
            throw new InvalidJavaEEVersion("Invalid version [" + paramVersion + "]", paramVersion);
        }
        return VERSION_MAP.get(paramVersion);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean ge(JavaEEVersion parmVersion) {
        return this.compareTo(parmVersion) >= 0;
    }

    public boolean gt(JavaEEVersion paramVersion) {
        return this.compareTo(paramVersion) > 0;
    }

    public boolean eq(JavaEEVersion paramVersion) {
        return this.compareTo(paramVersion) == 0;
    }

    public boolean le(JavaEEVersion paramVersion) {
        return this.compareTo(paramVersion) <= 0;
    }

    public boolean lt(JavaEEVersion paramVersion) {
        return this.compareTo(paramVersion) < 0;
    }

    private static boolean isValid(String paramVersion) {
        if (paramVersion == null) {
            throw new IllegalArgumentException("version could not be null.");
        }
        return VERSION_1_3.equals(paramVersion) || VERSION_1_4.equals(paramVersion) || VERSION_5.equals(paramVersion) || VERSION_6.equals(paramVersion) || VERSION_7.equals(paramVersion) || VERSION_8.equals(paramVersion);
    }

    @Override
    public int compareTo(JavaEEVersion otherVersion) {
        if (otherVersion == null) {
            throw new IllegalArgumentException("other object to compare to could not be null.");
        }
        return this.index.compareTo(otherVersion.index);
    }
}

