/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.wtp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.writers.wtp.AbstractWtpResourceWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class EclipseWtpApplicationXMLWriter
extends AbstractWtpResourceWriter {
    private static final String APPLICATION_XML_APPLICATION = "application";
    private static final String APPLICATION_XML_CONTEXT_ROOT = "context-root";
    private static final String APPLICATION_XML_DESCRIPTION = "description";
    private static final String APPLICATION_XML_DISPLAY_NAME = "display-name";
    private static final String APPLICATION_XML_FILENAME = "application.xml";
    private static final String APPLICATION_XML_MODULE = "module";
    private static final String APPLICATION_XML_WEB = "web";
    private static final String APPLICATION_XML_WEB_URI = "web-uri";
    private static final String HREF = "href";
    private static final String ID = "id";
    private static final String MODULEMAP_EARPROJECT_MAP = "modulemap:EARProjectMap";
    private static final String MODULEMAPS_APPLICATION_EJB_MODULE = "application:EjbModule";
    private static final String MODULEMAPS_APPLICATION_WEB_MODULE = "application:WebModule";
    private static final String MODULEMAPS_FILENAME = ".modulemaps";
    private static final String MODULEMAPS_MAPPINGS = "mappings";
    private static final String MODULEMAPS_PROJECT_NAME = "projectName";
    private static final String MODULEMAPS_UTILITY_JARMAPPINGS = "utilityJARMappings";
    private static final String URI = "uri";
    private static final String VERSION = "version";
    private static final String XMI_ID = "xmi:id";
    private static final String XMI_TYPE = "xmi:type";
    private static final String XMI_VERSION = "xmi:version";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_APPLICATION = "xmlns:application";
    private static final String XMLNS_MODULEMAP = "xmlns:modulemap";
    private static final String XMLNS_SCHEMA_LOCATION = "xmlns:schemaLocation";
    private static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String XMLNS_XMI = "xmlns:xmi";
    private static final String XMLNS_XSI = "xmlns:xsi";
    private Xpp3Dom[] applicationXmlDomChildren;
    private Xpp3Dom[] modulemapsXmlDomChildren;
    private Xpp3Dom[] webModulesFromPoms;

    public void write() throws MojoExecutionException {
        String packaging = this.config.getProject().getPackaging();
        if ("ear".equalsIgnoreCase(packaging)) {
            File applicationXmlFile = new File(this.config.getEclipseProjectDirectory(), "target" + File.separator + "eclipseEar" + File.separator + "META-INF" + File.separator + APPLICATION_XML_FILENAME);
            applicationXmlFile.getParentFile().mkdirs();
            this.copyApplicationFiles();
            applicationXmlFile.delete();
            Xpp3Dom applicationXmlDom = this.readXMLFile(applicationXmlFile);
            if (applicationXmlDom == null) {
                applicationXmlDom = this.createNewApplicationXml();
            }
            this.applicationXmlDomChildren = applicationXmlDom.getChildren(APPLICATION_XML_MODULE);
            File modulemapsXmlFile = new File(this.config.getEclipseProjectDirectory(), "target" + File.separator + "eclipseEar" + File.separator + "META-INF" + File.separator + MODULEMAPS_FILENAME);
            Xpp3Dom modulemapsXmlDom = this.readXMLFile(modulemapsXmlFile);
            if (modulemapsXmlDom == null) {
                modulemapsXmlDom = this.createNewModulemaps();
            }
            this.modulemapsXmlDomChildren = modulemapsXmlDom.getChildren();
            this.webModulesFromPoms = IdeUtils.getPluginConfigurationDom(this.config.getProject(), "org.apache.maven.plugins:maven-ear-plugin", new String[]{"modules", "webModule"});
            IdeDependency[] deps = this.config.getDepsOrdered();
            for (int index = 0; index < deps.length; ++index) {
                this.updateApplicationXml(applicationXmlDom, modulemapsXmlDom, deps[index]);
            }
            this.removeUnusedEntries(applicationXmlDom, modulemapsXmlDom);
            this.writePrettyXmlFile(applicationXmlFile, applicationXmlDom);
            this.writePrettyXmlFile(modulemapsXmlFile, modulemapsXmlDom);
        }
    }

    private void copyApplicationFiles() throws MojoExecutionException {
        try {
            File applicationDirectory = new File(this.config.getEclipseProjectDirectory(), "src" + File.separator + "main" + File.separator + APPLICATION_XML_APPLICATION);
            File eclipseApplicationDirectory = new File(this.config.getEclipseProjectDirectory(), "target" + File.separator + "eclipseEar");
            EclipseWtpApplicationXMLWriter.copyDirectoryStructure(applicationDirectory, eclipseApplicationDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not copy files the the eclipseEar directory", (Exception)e);
        }
    }

    public static void copyDirectoryStructure(File sourceDirectory, File destinationDirectory) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                destination = destination.getParentFile();
                FileUtils.copyFileToDirectory((File)file, (File)destination);
                continue;
            }
            if (!file.isDirectory() || file.getName().equals(".svn") || file.getName().equals("CVS")) continue;
            if (!destination.exists() && !destination.mkdirs()) {
                throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
            }
            EclipseWtpApplicationXMLWriter.copyDirectoryStructure(file, destination);
        }
    }

    private Xpp3Dom createNewApplicationXml() {
        Xpp3Dom result = new Xpp3Dom(APPLICATION_XML_APPLICATION);
        result.setAttribute(ID, "Application_ID");
        result.setAttribute(VERSION, "1.4");
        result.setAttribute(XMLNS, "http://java.sun.com/xml/ns/j2ee");
        result.setAttribute(XMLNS_XSI, "http://www.w3.org/2001/XMLSchema-instance");
        String locationAttribute = this.config.getWorkspaceConfiguration().getWebsphereVersion() != null ? XSI_SCHEMA_LOCATION : XMLNS_SCHEMA_LOCATION;
        result.setAttribute(locationAttribute, "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd");
        result.addChild(new Xpp3Dom(APPLICATION_XML_DESCRIPTION));
        Xpp3Dom name = new Xpp3Dom(APPLICATION_XML_DISPLAY_NAME);
        name.setValue(this.config.getEclipseProjectName());
        result.addChild(name);
        return result;
    }

    private Xpp3Dom createNewModulemaps() {
        Xpp3Dom result = new Xpp3Dom(MODULEMAP_EARPROJECT_MAP);
        result.setAttribute(XMI_VERSION, "2.0");
        result.setAttribute(XMLNS_XMI, "http://www.omg.org/XMI");
        result.setAttribute(XMLNS_APPLICATION, "application.xmi");
        result.setAttribute(XMLNS_MODULEMAP, "modulemap.xmi");
        result.setAttribute(XMI_ID, "EARProjectMap_" + System.identityHashCode(this));
        return result;
    }

    private Xpp3Dom findModuleInApplicationXml(Xpp3Dom applicationXmlDom, Xpp3Dom mapping) {
        String id = this.getIdFromMapping(mapping);
        Xpp3Dom[] children = applicationXmlDom.getChildren();
        for (int index = 0; index < children.length; ++index) {
            String childId = children[index].getAttribute(ID);
            if (childId == null || !childId.equals(id)) continue;
            return children[index];
        }
        return null;
    }

    private Xpp3Dom findOrCreateArtifact(IdeDependency dependency, Xpp3Dom modulemapXmlDom) {
        Xpp3Dom[] children = modulemapXmlDom.getChildren();
        for (int index = 0; index < children.length; ++index) {
            if (!children[index].getAttribute(MODULEMAPS_PROJECT_NAME).equals(dependency.getEclipseProjectName())) continue;
            if ((dependency.getType().equals("ejb") || dependency.getType().equals("ejb3")) && children[index].getName().equals(MODULEMAPS_MAPPINGS) && children[index].getChild(APPLICATION_XML_MODULE).getAttribute(XMI_TYPE).equals(MODULEMAPS_APPLICATION_EJB_MODULE)) {
                return children[index];
            }
            if (dependency.getType().equals("war") && children[index].getName().equals(MODULEMAPS_MAPPINGS) && children[index].getChild(APPLICATION_XML_MODULE).getAttribute(XMI_TYPE).equals(MODULEMAPS_APPLICATION_WEB_MODULE)) {
                return children[index];
            }
            if (dependency.getType().equals("jar") && children[index].getName().equals(MODULEMAPS_UTILITY_JARMAPPINGS)) {
                return children[index];
            }
            modulemapXmlDom.removeChild(index);
            break;
        }
        long id = System.identityHashCode(dependency);
        if (dependency.getType().equals("ejb") || dependency.getType().equals("ejb3")) {
            Xpp3Dom mapping = new Xpp3Dom(MODULEMAPS_MAPPINGS);
            mapping.setAttribute(XMI_ID, "ModuleMapping_" + id);
            mapping.setAttribute(MODULEMAPS_PROJECT_NAME, dependency.getEclipseProjectName());
            Xpp3Dom module = new Xpp3Dom(APPLICATION_XML_MODULE);
            module.setAttribute(XMI_TYPE, MODULEMAPS_APPLICATION_EJB_MODULE);
            module.setAttribute(HREF, "META-INF/application.xml#EjbModule_" + id);
            mapping.addChild(module);
            modulemapXmlDom.addChild(mapping);
            return mapping;
        }
        if (dependency.getType().equals("war")) {
            Xpp3Dom mapping = new Xpp3Dom(MODULEMAPS_MAPPINGS);
            mapping.setAttribute(XMI_ID, "ModuleMapping_" + id);
            mapping.setAttribute(MODULEMAPS_PROJECT_NAME, dependency.getEclipseProjectName());
            Xpp3Dom module = new Xpp3Dom(APPLICATION_XML_MODULE);
            module.setAttribute(XMI_TYPE, MODULEMAPS_APPLICATION_WEB_MODULE);
            module.setAttribute(HREF, "META-INF/application.xml#WebModule_" + id);
            mapping.addChild(module);
            modulemapXmlDom.addChild(mapping);
            return mapping;
        }
        Xpp3Dom utilityJARMapping = new Xpp3Dom(MODULEMAPS_UTILITY_JARMAPPINGS);
        utilityJARMapping.setAttribute(XMI_ID, "UtilityJARMapping_" + id);
        utilityJARMapping.setAttribute(MODULEMAPS_PROJECT_NAME, dependency.getEclipseProjectName());
        utilityJARMapping.setAttribute(URI, dependency.getEclipseProjectName() + ".jar");
        modulemapXmlDom.addChild(utilityJARMapping);
        return utilityJARMapping;
    }

    private String getIdFromMapping(Xpp3Dom mapping) {
        if (mapping.getChildCount() < 1) {
            return "";
        }
        String href = mapping.getChild(0).getAttribute(HREF);
        String id = href.substring(href.indexOf(35) + 1);
        return id;
    }

    private Xpp3Dom readXMLFile(File xmlFile) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-8");
            Xpp3Dom applicationXmlDom = Xpp3DomBuilder.build((Reader)reader);
            return applicationXmlDom;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            this.log.error((CharSequence)("cantreadfile" + xmlFile.getAbsolutePath()));
            return null;
        }
    }

    private void handled(Xpp3Dom xpp3Dom) {
        int index;
        for (index = 0; index < this.applicationXmlDomChildren.length; ++index) {
            if (this.applicationXmlDomChildren[index] != xpp3Dom) continue;
            this.applicationXmlDomChildren[index] = null;
        }
        for (index = 0; index < this.modulemapsXmlDomChildren.length; ++index) {
            if (this.modulemapsXmlDomChildren[index] != xpp3Dom) continue;
            this.modulemapsXmlDomChildren[index] = null;
        }
    }

    private void removeUnusedEntries(Xpp3Dom applicationXmlDom, Xpp3Dom modulemapsXmlDom) {
        int newIndex;
        int index;
        block0: for (index = 0; index < this.modulemapsXmlDomChildren.length; ++index) {
            if (this.modulemapsXmlDomChildren[index] == null) continue;
            Xpp3Dom[] newModulemapsXmlDomChildren = modulemapsXmlDom.getChildren();
            for (newIndex = 0; newIndex < newModulemapsXmlDomChildren.length; ++newIndex) {
                if (newModulemapsXmlDomChildren[newIndex] != this.modulemapsXmlDomChildren[index]) continue;
                modulemapsXmlDom.removeChild(newIndex);
                continue block0;
            }
        }
        block2: for (index = 0; index < this.applicationXmlDomChildren.length; ++index) {
            if (this.applicationXmlDomChildren[index] == null) continue;
            Xpp3Dom[] newApplicationXmlDomChildren = applicationXmlDom.getChildren();
            for (newIndex = 0; newIndex < newApplicationXmlDomChildren.length; ++newIndex) {
                if (newApplicationXmlDomChildren[newIndex] != this.applicationXmlDomChildren[index]) continue;
                applicationXmlDom.removeChild(newIndex);
                continue block2;
            }
        }
    }

    private void updateApplicationXml(Xpp3Dom applicationXmlDom, Xpp3Dom modulemapXmlDom, IdeDependency dependency) {
        if (dependency.isTestDependency() || dependency.isProvided() || dependency.isSystemScopedOutsideProject(this.config.getProject())) {
            return;
        }
        Xpp3Dom mapping = this.findOrCreateArtifact(dependency, modulemapXmlDom);
        this.handled(mapping);
        if (dependency.getType().equals("ejb") || dependency.getType().equals("ejb3")) {
            Xpp3Dom module = this.findModuleInApplicationXml(applicationXmlDom, mapping);
            if (module == null) {
                module = new Xpp3Dom(APPLICATION_XML_MODULE);
                module.setAttribute(ID, this.getIdFromMapping(mapping));
                Xpp3Dom ejb = new Xpp3Dom("ejb");
                ejb.setValue(dependency.getEclipseProjectName() + ".jar");
                module.addChild(ejb);
                applicationXmlDom.addChild(module);
            } else {
                this.handled(module);
                module.getChild("ejb").setValue(dependency.getEclipseProjectName() + ".jar");
            }
        } else if (dependency.getType().equals("war")) {
            String contextRootInPom = this.getContextRootFor(dependency);
            Xpp3Dom module = this.findModuleInApplicationXml(applicationXmlDom, mapping);
            if (module == null) {
                module = new Xpp3Dom(APPLICATION_XML_MODULE);
                module.setAttribute(ID, this.getIdFromMapping(mapping));
                Xpp3Dom web = new Xpp3Dom(APPLICATION_XML_WEB);
                Xpp3Dom webUri = new Xpp3Dom(APPLICATION_XML_WEB_URI);
                webUri.setValue(dependency.getEclipseProjectName() + ".war");
                Xpp3Dom contextRoot = new Xpp3Dom(APPLICATION_XML_CONTEXT_ROOT);
                contextRoot.setValue(contextRootInPom);
                web.addChild(webUri);
                web.addChild(contextRoot);
                module.addChild(web);
                applicationXmlDom.addChild(module);
            } else {
                this.handled(module);
                module.getChild(APPLICATION_XML_WEB).getChild(APPLICATION_XML_WEB_URI).setValue(dependency.getEclipseProjectName() + ".war");
                module.getChild(APPLICATION_XML_WEB).getChild(APPLICATION_XML_CONTEXT_ROOT).setValue(contextRootInPom);
            }
        }
    }

    private String getContextRootFor(IdeDependency dependency) {
        String artifactId = dependency.getArtifactId();
        String groupId = dependency.getGroupId();
        for (int index = 0; index < this.webModulesFromPoms.length; ++index) {
            Xpp3Dom webGroupId = this.webModulesFromPoms[index].getChild("groupId");
            Xpp3Dom webArtifactId = this.webModulesFromPoms[index].getChild("artifactId");
            Xpp3Dom webContextRoot = this.webModulesFromPoms[index].getChild("contextRoot");
            if (webContextRoot == null || webArtifactId == null || !webArtifactId.getValue().equals(artifactId) || webGroupId == null || !webGroupId.getValue().equals(groupId)) continue;
            return webContextRoot.getValue();
        }
        return dependency.getArtifactId();
    }

    private void writePrettyXmlFile(File xmlFile, Xpp3Dom xmlDomTree) throws MojoExecutionException {
        Xpp3Dom original = this.readXMLFile(xmlFile);
        if (original != null && original.equals((Object)xmlDomTree)) {
            this.log.info((CharSequence)("Rad6CleanMojo.unchanged" + xmlFile.getAbsolutePath()));
            return;
        }
        OutputStreamWriter w = null;
        xmlFile.getParentFile().mkdirs();
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Rad6Plugin.erroropeningfile", (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
        Xpp3DomWriter.write((XMLWriter)writer, (Xpp3Dom)xmlDomTree);
        IOUtil.close((Writer)w);
    }
}

