/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.IOUtil;
import org.apache.maven.surefire.suite.RunResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="integration-test", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.INTEGRATION_TEST, threadSafe=true)
public class IntegrationTestMojo
extends AbstractSurefireMojo {
    private static final String FAILSAFE_IN_PROGRESS_CONTEXT_KEY = "failsafe-in-progress";
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports")
    private File reportsDirectory;
    @Parameter(property="it.test")
    private String test;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter(property="failsafe.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="failsafe.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="failsafe.useFile", defaultValue="true")
    private boolean useFile;
    @Parameter(property="it.failIfNoSpecifiedTests")
    private Boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.failsafe.debug")
    private String debugForkedProcess;
    @Parameter(property="failsafe.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="failsafe.parallel.timeout")
    private double parallelTestsTimeoutInSeconds;
    @Parameter(property="failsafe.parallel.forcedTimeout")
    private double parallelTestsTimeoutForcedInSeconds;
    @Parameter
    private List<String> includes;
    @Parameter(property="failsafe.useSystemClassLoader", defaultValue="true")
    private boolean useSystemClassLoader;
    @Parameter(property="failsafe.useManifestOnlyJar", defaultValue="true")
    private boolean useManifestOnlyJar;
    @Parameter(property="encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;
    @Parameter(property="failsafe.rerunFailingTestsCount", defaultValue="0")
    protected int rerunFailingTestsCount;

    protected int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    protected void handleSummary(RunResult summary, Exception firstForkException) throws MojoExecutionException, MojoFailureException {
        this.writeSummary(summary, firstForkException);
    }

    private void writeSummary(RunResult summary, Exception firstForkException) throws MojoExecutionException {
        File summaryFile = this.getSummaryFile();
        if (!summaryFile.getParentFile().isDirectory()) {
            summaryFile.getParentFile().mkdirs();
        }
        OutputStream fout = null;
        InputStream fin = null;
        try {
            Object token = this.getPluginContext().get(FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
            summary.writeSummary(summaryFile, token != null, this.getEncodingOrDefault());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close(fin);
            IOUtil.close(fout);
        }
        this.getPluginContext().put(FAILSAFE_IN_PROGRESS_CONTEXT_KEY, FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
    }

    private String getEncodingOrDefault() {
        if (StringUtils.isEmpty(this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            return ReaderFactory.FILE_ENCODING;
        }
        return this.encoding;
    }

    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipITs() || this.isSkipExec();
    }

    protected String getPluginName() {
        return "failsafe";
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/IT*.java", "**/*IT.java", "**/*ITCase.java"};
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipITs() {
        return this.skipITs;
    }

    public void setSkipITs(boolean skipITs) {
        this.skipITs = skipITs;
    }

    @Deprecated
    public boolean isSkipExec() {
        return this.skipExec;
    }

    @Deprecated
    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getTest() {
        if (StringUtils.isBlank(this.test)) {
            return null;
        }
        int index = this.test.indexOf(35);
        if (index >= 0) {
            return this.test.substring(0, index);
        }
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public String getTestMethod() {
        if (StringUtils.isBlank(this.test)) {
            return null;
        }
        int index = this.test.indexOf(35);
        if (index >= 0) {
            return this.test.substring(index + 1, this.test.length());
        }
        return null;
    }

    public File getSummaryFile() {
        return this.summaryFile;
    }

    public void setSummaryFile(File summaryFile) {
        this.summaryFile = summaryFile;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    public void setParallelTestsTimeoutInSeconds(double parallelTestsTimeoutInSeconds) {
        this.parallelTestsTimeoutInSeconds = parallelTestsTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    public void setParallelTestsTimeoutForcedInSeconds(double parallelTestsTimeoutForcedInSeconds) {
        this.parallelTestsTimeoutForcedInSeconds = parallelTestsTimeoutForcedInSeconds;
    }

    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    public boolean isTestFailureIgnore() {
        return true;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
        checksum.add(this.skipITs);
        checksum.add(this.summaryFile);
    }

    public Boolean getFailIfNoSpecifiedTests() {
        return this.failIfNoSpecifiedTests;
    }

    public void setFailIfNoSpecifiedTests(Boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }
}

