/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe.xmlsummary;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.maven.plugin.failsafe.xmlsummary.ErrorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"completed", "errors", "failures", "skipped", "failureMessage"})
@XmlRootElement(name="failsafe-summary")
public class FailsafeSummary {
    private static final String ERROR_MSG_PREFIX = "org.apache.maven.surefire.booter.SurefireBooterForkException: ";
    private static final Pattern STACK_TRACE_ELEMENT1 = Pattern.compile("^\\tat.*\\(.*\\.java\\:[\\d]+\\)$");
    private static final Pattern STACK_TRACE_ELEMENT2 = Pattern.compile("^\\tat.*\\(Native Method\\)$");
    private static final Pattern STACK_TRACE_ELEMENT3 = Pattern.compile("^Caused by\\: .*");
    private int completed;
    private int errors;
    private int failures;
    private int skipped;
    @XmlElement(required=true, nillable=true)
    private String failureMessage;
    @XmlAttribute(name="result")
    private ErrorType result;
    @XmlAttribute(name="timeout", required=true)
    private boolean timeout;

    public int getCompleted() {
        return this.completed;
    }

    public void setCompleted(int value) {
        this.completed = value;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int value) {
        this.errors = value;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int value) {
        this.failures = value;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public void setSkipped(int value) {
        this.skipped = value;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String value) {
        this.failureMessage = value;
    }

    public ErrorType getResult() {
        return this.result;
    }

    public void setResult(ErrorType value) {
        this.result = value;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean value) {
        this.timeout = value;
    }

    public boolean hasNoTests() {
        return this.getResult() == ErrorType.NO_TESTS;
    }

    public boolean isFailure() {
        return this.getResult() == ErrorType.FAILURE;
    }

    public List<String> extractExceptionMessageLines() throws IOException {
        String line;
        if (this.getFailureMessage() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> msg = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader(new StringReader(this.getFailureMessage()));
        while (!((line = reader.readLine()) == null || STACK_TRACE_ELEMENT1.matcher(line).matches() || STACK_TRACE_ELEMENT2.matcher(line).matches() || STACK_TRACE_ELEMENT3.matcher(line).matches())) {
            msg.add((line = line.trim()).startsWith(ERROR_MSG_PREFIX) ? line.substring(ERROR_MSG_PREFIX.length()) : line);
        }
        return msg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailsafeSummary summary = (FailsafeSummary)o;
        return this.getCompleted() == summary.getCompleted() && this.getErrors() == summary.getErrors() && this.getFailures() == summary.getFailures() && this.getSkipped() == summary.getSkipped() && this.isTimeout() == summary.isTimeout() && this.equal(this.getFailureMessage(), summary.getFailureMessage()) && this.getResult() == summary.getResult();
    }

    public int hashCode() {
        int result1 = this.getCompleted();
        result1 = 31 * result1 + this.getErrors();
        result1 = 31 * result1 + this.getFailures();
        result1 = 31 * result1 + this.getSkipped();
        result1 = 31 * result1 + (this.getFailureMessage() != null ? this.getFailureMessage().hashCode() : 0);
        result1 = 31 * result1 + (this.getResult() != null ? this.getResult().hashCode() : 0);
        result1 = 31 * result1 + (this.isTimeout() ? 1 : 0);
        return result1;
    }

    private boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }
}

