/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.invoker.InvokerToolchain;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.codehaus.plexus.util.StringUtils;

class InvokerProperties {
    private static final String SELECTOR_PREFIX = "selector.";
    private static final Pattern ENVIRONMENT_VARIABLES_PATTERN = Pattern.compile("invoker\\.environmentVariables\\.([A-Za-z][^.]+)(\\.([0-9]+))?");
    private Boolean defaultDebug;
    private Boolean defaultQuiet;
    private List<String> defaultGoals;
    private List<String> defaultProfiles;
    private String defaultMavenOpts;
    private Integer defaultTimeoutInSeconds;
    private Map<String, String> defaultEnvironmentVariables;
    private File defaultMavenExecutable;
    private Boolean defaultUpdateSnapshots;
    private final Properties properties;

    InvokerProperties(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    public void setDefaultDebug(boolean defaultDebug) {
        this.defaultDebug = defaultDebug;
    }

    public void setDefaultQuiet(boolean defaultQuiet) {
        this.defaultQuiet = defaultQuiet;
    }

    public void setDefaultGoals(List<String> defaultGoals) {
        this.defaultGoals = defaultGoals;
    }

    public void setDefaultProfiles(List<String> defaultProfiles) {
        this.defaultProfiles = defaultProfiles;
    }

    public void setDefaultMavenExecutable(String defaultMavenExecutable) {
        if (StringUtils.isNotBlank((String)defaultMavenExecutable)) {
            this.defaultMavenExecutable = new File(defaultMavenExecutable);
        }
    }

    public void setDefaultMavenOpts(String defaultMavenOpts) {
        this.defaultMavenOpts = defaultMavenOpts;
    }

    public void setDefaultTimeoutInSeconds(int defaultTimeoutInSeconds) {
        this.defaultTimeoutInSeconds = defaultTimeoutInSeconds;
    }

    public void setDefaultEnvironmentVariables(Map<String, String> defaultEnvironmentVariables) {
        this.defaultEnvironmentVariables = defaultEnvironmentVariables;
    }

    public void setDefaultUpdateSnapshots(boolean defaultUpdateSnapshots) {
        this.defaultUpdateSnapshots = defaultUpdateSnapshots;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getJobName() {
        return this.properties.getProperty("invoker.name", "");
    }

    public String getJobDescription() {
        return this.properties.getProperty("invoker.description", "");
    }

    public int getOrdinal() {
        return Integer.parseInt(this.properties.getProperty("invoker.ordinal", "0"));
    }

    public String getJreVersion() {
        return this.properties.getProperty("invoker.java.version", "");
    }

    public String getJreVersion(int index) {
        return this.properties.getProperty(SELECTOR_PREFIX + index + (Object)((Object)SelectorProperty.JAVA_VERSION), this.getJreVersion());
    }

    public String getMavenVersion() {
        return this.properties.getProperty("invoker.maven.version", "");
    }

    public String getMavenVersion(int index) {
        return this.properties.getProperty(SELECTOR_PREFIX + index + (Object)((Object)SelectorProperty.MAVEN_VERSION), this.getMavenVersion());
    }

    public String getOsFamily() {
        return this.properties.getProperty("invoker.os.family", "");
    }

    public String getOsFamily(int index) {
        return this.properties.getProperty(SELECTOR_PREFIX + index + (Object)((Object)SelectorProperty.OS_FAMLY), this.getOsFamily());
    }

    public Collection<InvokerToolchain> getToolchains() {
        return this.getToolchains(Pattern.compile("invoker\\.toolchain\\.([^.]+)\\.(.+)"));
    }

    public Collection<InvokerToolchain> getToolchains(int index) {
        return this.getToolchains(Pattern.compile("selector\\." + index + "\\.invoker\\.toolchain\\.([^.]+)\\.(.+)"));
    }

    private Collection<InvokerToolchain> getToolchains(Pattern p) {
        HashMap<String, InvokerToolchain> toolchains = new HashMap<String, InvokerToolchain>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            Matcher m = p.matcher(entry.getKey().toString());
            if (!m.matches()) continue;
            String type = m.group(1);
            String providesKey = m.group(2);
            String providesValue = entry.getValue().toString();
            InvokerToolchain tc = (InvokerToolchain)toolchains.get(type);
            if (tc == null) {
                tc = new InvokerToolchain(type);
                toolchains.put(type, tc);
            }
            tc.addProvides(providesKey, providesValue);
        }
        return toolchains.values();
    }

    private Map<String, String> getEnvironmentVariables(int index) {
        HashMap<String, String> envItems = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            Matcher matcher = ENVIRONMENT_VARIABLES_PATTERN.matcher(entry.getKey().toString());
            if (!matcher.matches()) continue;
            if (String.valueOf(index).equals(matcher.group(3))) {
                envItems.put(matcher.group(1), entry.getValue().toString());
                continue;
            }
            if (matcher.group(3) != null || envItems.containsKey(matcher.group(1))) continue;
            envItems.put(matcher.group(1), entry.getValue().toString());
        }
        return envItems;
    }

    public boolean isInvocationDefined(int index) {
        return Arrays.stream(InvocationProperty.values()).map(InvocationProperty::toString).map(v -> this.properties.getProperty(v + '.' + index)).anyMatch(Objects::nonNull);
    }

    public boolean isSelectorDefined(int index) {
        return Arrays.stream(SelectorProperty.values()).map(v -> ((SelectorProperty)v).suffix).map(v -> this.properties.getProperty(SELECTOR_PREFIX + index + v)).anyMatch(Objects::nonNull);
    }

    private <T> void setIfNotNull(Consumer<T> consumer, T value) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public void configureInvocation(InvocationRequest request, int index) {
        this.get(InvocationProperty.PROJECT, index).ifPresent(project -> {
            File file = new File(request.getBaseDirectory(), (String)project);
            if (file.isFile()) {
                request.setBaseDirectory(file.getParentFile());
                request.setPomFile(file);
            } else {
                request.setBaseDirectory(file);
                request.setPomFile(null);
            }
        });
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setGoals(arg_0), this.get(InvocationProperty.GOALS, index).map(s -> StringUtils.split((String)s, (String)", \t\n\r\f")).map(Arrays::asList).filter(l -> !l.isEmpty()).orElse(this.defaultGoals));
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setProfiles(arg_0), this.get(InvocationProperty.PROFILES, index).map(s -> StringUtils.split((String)s, (String)", \t\n\r\f")).map(Arrays::asList).filter(l -> !l.isEmpty()).orElse(this.defaultProfiles));
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setMavenExecutable(arg_0), this.get(InvocationProperty.MAVEN_EXECUTABLE, index).map(File::new).orElse(this.defaultMavenExecutable));
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setMavenOpts(arg_0), this.get(InvocationProperty.MAVEN_OPTS, index).orElse(this.defaultMavenOpts));
        this.get(InvocationProperty.FAILURE_BEHAVIOR, index).map(InvocationRequest.ReactorFailureBehavior::valueOfByLongOption).ifPresent(arg_0 -> ((InvocationRequest)request).setReactorFailureBehavior(arg_0));
        this.get(InvocationProperty.NON_RECURSIVE, index).map(Boolean::parseBoolean).map(b -> b == false).ifPresent(arg_0 -> ((InvocationRequest)request).setRecursive(arg_0));
        this.get(InvocationProperty.OFFLINE, index).map(Boolean::parseBoolean).ifPresent(arg_0 -> ((InvocationRequest)request).setOffline(arg_0));
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setDebug(arg_0), this.get(InvocationProperty.DEBUG, index).map(Boolean::parseBoolean).orElse(this.defaultDebug));
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setQuiet(arg_0), this.get(InvocationProperty.QUIET, index).map(Boolean::parseBoolean).orElse(this.defaultQuiet));
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setTimeoutInSeconds(arg_0), this.get(InvocationProperty.TIMEOUT_IN_SECONDS, index).map(Integer::parseInt).orElse(this.defaultTimeoutInSeconds));
        this.setIfNotNull(arg_0 -> ((InvocationRequest)request).setUpdateSnapshots(arg_0), this.get(InvocationProperty.UPDATE_SNAPSHOTS, index).map(Boolean::parseBoolean).orElse(this.defaultUpdateSnapshots));
        Optional.ofNullable(this.defaultEnvironmentVariables).ifPresent(evn -> evn.forEach((arg_0, arg_1) -> ((InvocationRequest)request).addShellEnvironment(arg_0, arg_1)));
        this.getEnvironmentVariables(index).forEach((arg_0, arg_1) -> ((InvocationRequest)request).addShellEnvironment(arg_0, arg_1));
    }

    public boolean isExpectedResult(int exitCode, int index) {
        boolean nonZeroExit = "failure".equalsIgnoreCase(this.get(InvocationProperty.BUILD_RESULT, index).orElse(null));
        return exitCode != 0 == nonZeroExit;
    }

    public String getSystemPropertiesFile(int index) {
        return this.get(InvocationProperty.SYSTEM_PROPERTIES_FILE, index).orElse(null);
    }

    public String getSettingsFile(int index) {
        return this.get(InvocationProperty.SETTINGS_FILE, index).orElse(null);
    }

    Optional<String> get(String key, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("invalid invocation index: " + index);
        }
        String value = Optional.ofNullable(this.properties.getProperty(key + '.' + index)).orElseGet(() -> this.properties.getProperty(key));
        return Optional.ofNullable(value).map(String::trim).filter(s -> !s.isEmpty());
    }

    private Optional<String> get(InvocationProperty prop, int index) {
        return this.get(prop.toString(), index);
    }

    private static enum SelectorProperty {
        JAVA_VERSION(".java.version"),
        MAVEN_VERSION(".maven.version"),
        OS_FAMLY(".os.family");

        private final String suffix;

        private SelectorProperty(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }

    private static enum InvocationProperty {
        PROJECT("invoker.project"),
        BUILD_RESULT("invoker.buildResult"),
        GOALS("invoker.goals"),
        PROFILES("invoker.profiles"),
        MAVEN_EXECUTABLE("invoker.mavenExecutable"),
        MAVEN_OPTS("invoker.mavenOpts"),
        FAILURE_BEHAVIOR("invoker.failureBehavior"),
        NON_RECURSIVE("invoker.nonRecursive"),
        OFFLINE("invoker.offline"),
        SYSTEM_PROPERTIES_FILE("invoker.systemPropertiesFile"),
        DEBUG("invoker.debug"),
        QUIET("invoker.quiet"),
        SETTINGS_FILE("invoker.settingsFile"),
        TIMEOUT_IN_SECONDS("invoker.timeoutInSeconds"),
        UPDATE_SNAPSHOTS("invoker.updateSnapshots");

        private final String key;

        private InvocationProperty(String s) {
            this.key = s;
        }

        public String toString() {
            return this.key;
        }
    }
}

