/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.javadoc.OfflineLink;
import org.apache.maven.plugin.javadoc.options.DocletArtifact;
import org.apache.maven.plugin.javadoc.options.Group;
import org.apache.maven.plugin.javadoc.options.JavadocPathArtifact;
import org.apache.maven.plugin.javadoc.options.Tag;
import org.apache.maven.plugin.javadoc.options.Taglet;
import org.apache.maven.plugin.javadoc.options.TagletArtifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.PathUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJavadocMojo
extends AbstractMojo {
    private static final String RESOURCE_DIR = ClassUtils.getPackageName((Class)(class$org$apache$maven$plugin$javadoc$JavadocReport == null ? (class$org$apache$maven$plugin$javadoc$JavadocReport = AbstractJavadocMojo.class$("org.apache.maven.plugin.javadoc.JavadocReport")) : class$org$apache$maven$plugin$javadoc$JavadocReport)).replace('.', '/');
    private static final String DEFAULT_CSS_NAME = "stylesheet.css";
    private static final String RESOURCE_CSS_DIR = RESOURCE_DIR + "/css";
    private static final float SINCE_JAVADOC_1_4 = 1.4f;
    private static final float SINCE_JAVADOC_1_4_2 = 1.42f;
    private static final float SINCE_JAVADOC_1_5 = 1.5f;
    private Settings settings;
    protected MavenProject project;
    private boolean isOffline;
    private File javadocDirectory;
    private String additionalparam;
    private String additionalJOption;
    private ArtifactResolver resolver;
    private ArtifactFactory factory;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private List reactorProjects;
    protected boolean aggregate;
    private ArtifactMetadataSource artifactMetadataSource;
    private boolean debug;
    private String javadocExecutable;
    private String javadocVersion;
    private float fJavadocVersion = 0.0f;
    private boolean breakiterator = false;
    private String doclet;
    private String docletPath;
    private DocletArtifact docletArtifact;
    private DocletArtifact[] docletArtifacts;
    private String encoding;
    private String excludePackageNames;
    private String extdirs;
    private String locale;
    private String maxmemory;
    private String minmemory;
    private String proxyHost;
    private int proxyPort;
    private boolean old = false;
    private File overview;
    private String show = "protected";
    private boolean quiet = false;
    private String source;
    private String sourcepath;
    private String subpackages;
    private boolean verbose = false;
    private boolean author = true;
    private String bottom;
    private String charset = "ISO-8859-1";
    protected File outputDirectory;
    private boolean docfilessubdirs = false;
    private String docencoding;
    private String doctitle;
    private String excludedocfilessubdir;
    private String footer;
    private Group[] groups;
    private String header;
    private String helpfile;
    private boolean keywords;
    private ArrayList links;
    private ArrayList offlineLinks;
    private boolean linksource = false;
    private boolean nocomment = false;
    private boolean nodeprecated = false;
    private boolean nodeprecatedlist = false;
    private boolean nohelp = false;
    private boolean noindex = false;
    private boolean nonavbar = false;
    private String noqualifier;
    private boolean nosince = false;
    private boolean notimestamp;
    private boolean notree = false;
    private String packagesheader;
    private boolean serialwarn = false;
    private String sourcetab;
    private boolean splitindex = false;
    private String stylesheet;
    private String stylesheetfile;
    private Tag[] tags;
    private String taglet;
    private String tagletpath;
    private TagletArtifact tagletArtifact;
    private Taglet[] taglets;
    private boolean use = true;
    private boolean version = true;
    private String windowtitle;
    static /* synthetic */ Class class$org$apache$maven$plugin$javadoc$JavadocReport;

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected List getProjectBuildOutputDirs(MavenProject p) {
        return Collections.singletonList(p.getBuild().getOutputDirectory());
    }

    protected List getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getCompileSourceRoots();
    }

    protected List getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getExecutionProject().getCompileSourceRoots();
    }

    protected List getProjectArtifacts(MavenProject p) {
        return p.getCompileArtifacts();
    }

    protected File getJavadocDirectory() {
        return this.javadocDirectory;
    }

    protected String getDoctitle() {
        return this.doctitle;
    }

    protected File getOverview() {
        return this.overview;
    }

    protected String getWindowtitle() {
        return this.windowtitle;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        String classpath;
        float jVersion;
        String jExecutable;
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return;
        }
        List sourcePaths = this.getSourcePaths();
        List files = this.getFiles(sourcePaths);
        List packageNames = this.getPackageNames(sourcePaths, files);
        List filesWithUnnamedPackages = this.getFilesWithUnnamedPackages(sourcePaths, files);
        if (!this.canGenerateReport(files)) {
            return;
        }
        try {
            jExecutable = this.getJavadocExecutable();
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to find javadoc command: " + e.getMessage(), (Exception)e);
        }
        try {
            jVersion = AbstractJavadocMojo.getJavadocVersion(new File(jExecutable));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to find javadoc version: " + e.getMessage(), (Exception)e);
        }
        catch (CommandLineException e) {
            throw new MavenReportException("Unable to find javadoc version: " + e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)this.javadocVersion)) {
            try {
                this.fJavadocVersion = Float.parseFloat(this.javadocVersion);
            }
            catch (NumberFormatException e) {
                throw new MavenReportException("Unable to parse javadoc version: " + e.getMessage(), (Exception)e);
            }
            if (this.fJavadocVersion != jVersion) {
                this.getLog().warn((CharSequence)("Are you sure about the <javadocVersion/> parameter? It seems to be " + jVersion));
            }
        } else {
            this.fJavadocVersion = jVersion;
        }
        File javadocOutputDirectory = new File(this.getOutputDirectory());
        javadocOutputDirectory.mkdirs();
        try {
            this.copyDefaultStylesheet(javadocOutputDirectory);
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy default stylesheet: " + e.getMessage(), (Exception)e);
        }
        try {
            this.copyJavadocResources(javadocOutputDirectory);
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy javadoc resources: " + e.getMessage(), (Exception)e);
        }
        StringBuffer options = new StringBuffer();
        if (StringUtils.isNotEmpty((String)this.locale)) {
            options.append("-locale ");
            options.append(AbstractJavadocMojo.quotedArgument(this.locale));
            options.append(SystemUtils.LINE_SEPARATOR);
        }
        if ((classpath = this.getClasspath()).length() > 0) {
            options.append("-classpath ");
            options.append(AbstractJavadocMojo.quotedPathArgument(classpath));
            options.append(SystemUtils.LINE_SEPARATOR);
        }
        Commandline cmd = new Commandline();
        if (StringUtils.isNotEmpty((String)this.proxyHost) && this.proxyPort > 0) {
            cmd.createArgument().setValue("-J-DproxyHost=" + this.proxyHost);
            cmd.createArgument().setValue("-J-DproxyPort=" + this.proxyPort);
        }
        this.addMemoryArg(cmd, "-Xmx", this.maxmemory);
        this.addMemoryArg(cmd, "-Xms", this.minmemory);
        if (StringUtils.isNotEmpty((String)this.additionalJOption)) {
            cmd.createArgument().setValue(this.additionalJOption);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        cmd.setWorkingDirectory(javadocOutputDirectory.getAbsolutePath());
        cmd.setExecutable(jExecutable);
        this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.4f);
        if (StringUtils.isNotEmpty((String)this.doclet)) {
            this.addArgIfNotEmpty(arguments, "-doclet", AbstractJavadocMojo.quotedArgument(this.doclet));
            this.addArgIfNotEmpty(arguments, "-docletpath", AbstractJavadocMojo.quotedPathArgument(this.getDocletPath()));
        }
        this.addArgIfNotEmpty(arguments, "-encoding", AbstractJavadocMojo.quotedArgument(this.encoding));
        this.addArgIfNotEmpty(arguments, "-extdirs", AbstractJavadocMojo.quotedPathArgument(this.extdirs));
        if (this.old && this.isJavaDocVersionAtLeast(1.4f)) {
            this.getLog().warn((CharSequence)"Javadoc 1.4 doesn't support the -1.1 switch anymore. Ignore this option.");
        } else {
            this.addArgIf(arguments, this.old, "-1.1");
        }
        if (this.getOverview() != null && this.getOverview().exists()) {
            this.addArgIfNotEmpty(arguments, "-overview", AbstractJavadocMojo.quotedPathArgument(this.getOverview().getAbsolutePath()));
        }
        arguments.add(this.getAccessLevel());
        this.addArgIf(arguments, this.quiet, "-quiet", 1.4f);
        this.addArgIfNotEmpty(arguments, "-source", AbstractJavadocMojo.quotedArgument(this.source), 1.4f);
        this.addArgIf(arguments, this.verbose, "-verbose");
        this.addArgIfNotEmpty(arguments, null, this.additionalparam);
        if (StringUtils.isEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
            this.sourcepath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
        }
        this.addArgIfNotEmpty(arguments, "-sourcepath", AbstractJavadocMojo.quotedPathArgument(this.getSourcePath(sourcePaths)));
        if (StringUtils.isNotEmpty((String)this.sourcepath)) {
            this.addArgIfNotEmpty(arguments, "-subpackages", this.subpackages, 1.4f);
        }
        this.addArgIfNotEmpty(arguments, "-exclude", this.getExcludedPackages(sourcePaths), 1.4f);
        if (StringUtils.isEmpty((String)this.doclet)) {
            int i;
            this.addArgIf(arguments, this.author, "-author");
            this.addArgIfNotEmpty(arguments, "-bottom", AbstractJavadocMojo.quotedArgument(this.getBottomText(this.project.getInceptionYear())), false, false);
            this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.4f);
            this.addArgIfNotEmpty(arguments, "-charset", AbstractJavadocMojo.quotedArgument(this.charset));
            this.addArgIfNotEmpty(arguments, "-d", AbstractJavadocMojo.quotedPathArgument(javadocOutputDirectory.toString()));
            this.addArgIf(arguments, this.docfilessubdirs, "-docfilessubdirs", 1.4f);
            this.addArgIfNotEmpty(arguments, "-docencoding", AbstractJavadocMojo.quotedArgument(this.docencoding));
            this.addArgIfNotEmpty(arguments, "-doctitle", AbstractJavadocMojo.quotedArgument(this.getDoctitle()), false, false);
            this.addArgIfNotEmpty(arguments, "-excludedocfilessubdir", AbstractJavadocMojo.quotedPathArgument(this.excludedocfilessubdir), 1.4f);
            this.addArgIfNotEmpty(arguments, "-footer", AbstractJavadocMojo.quotedArgument(StringUtils.replace((String)this.footer, (String)"\n", (String)"")), false, false);
            if (this.groups != null) {
                for (i = 0; i < this.groups.length; ++i) {
                    if (this.groups[i] == null || StringUtils.isEmpty((String)this.groups[i].getTitle()) || StringUtils.isEmpty((String)this.groups[i].getPackages())) {
                        this.getLog().info((CharSequence)"A group option is empty. Ignore this option.");
                        continue;
                    }
                    String groupTitle = StringUtils.replace((String)this.groups[i].getTitle(), (String)",", (String)"&#44;");
                    this.addArgIfNotEmpty(arguments, "-group", AbstractJavadocMojo.quotedArgument(groupTitle) + " " + AbstractJavadocMojo.quotedArgument(this.groups[i].getPackages()), true);
                }
            }
            this.addArgIfNotEmpty(arguments, "-header", AbstractJavadocMojo.quotedArgument(StringUtils.replace((String)this.header, (String)"\n", (String)"")), false, false);
            this.addArgIfNotEmpty(arguments, "-helpfile", AbstractJavadocMojo.quotedPathArgument(this.helpfile));
            this.addArgIf(arguments, this.keywords, "-keywords", 1.42f);
            if (!this.isOffline) {
                this.addLinkArguments(arguments);
            }
            this.addLinkofflineArguments(arguments);
            this.addArgIf(arguments, this.nodeprecated, "-nodeprecated");
            this.addArgIf(arguments, this.nodeprecatedlist, "-nodeprecatedlist");
            this.addArgIf(arguments, this.nocomment, "-nocomment", 1.4f);
            this.addArgIf(arguments, this.nohelp, "-nohelp");
            this.addArgIf(arguments, this.noindex, "-noindex");
            this.addArgIf(arguments, this.nonavbar, "-nonavbar");
            this.addArgIfNotEmpty(arguments, "-noqualifier", AbstractJavadocMojo.quotedArgument(this.noqualifier), 1.4f);
            this.addArgIf(arguments, this.nosince, "-nosince");
            this.addArgIf(arguments, this.notimestamp, "-notimestamp", 1.5f);
            this.addArgIf(arguments, this.notree, "-notree");
            this.addArgIfNotEmpty(arguments, "-packagesheader", this.packagesheader, 1.42f);
            this.addArgIf(arguments, this.serialwarn, "-serialwarn");
            this.addArgIf(arguments, this.linksource, "-linksource", 1.4f);
            if (this.fJavadocVersion == 1.42f) {
                this.addArgIfNotEmpty(arguments, "-linksourcetab", this.sourcetab);
            } else {
                this.addArgIfNotEmpty(arguments, "-sourcetab", this.sourcetab, 1.5f);
            }
            this.addArgIf(arguments, this.splitindex, "-splitindex");
            this.addArgIfNotEmpty(arguments, "-stylesheetfile", AbstractJavadocMojo.quotedPathArgument(this.getStylesheetFile(javadocOutputDirectory)));
            this.addArgIfNotEmpty(arguments, "-taglet", AbstractJavadocMojo.quotedArgument(this.taglet), 1.4f);
            if (this.taglets != null) {
                for (i = 0; i < this.taglets.length; ++i) {
                    if (this.taglets[i] == null || StringUtils.isEmpty((String)this.taglets[i].getTagletClass())) {
                        this.getLog().info((CharSequence)"A taglet option is empty. Ignore this option.");
                        continue;
                    }
                    this.addArgIfNotEmpty(arguments, "-taglet", AbstractJavadocMojo.quotedArgument(this.taglets[i].getTagletClass()), 1.4f);
                }
            }
            this.addArgIfNotEmpty(arguments, "-tagletpath", AbstractJavadocMojo.quotedPathArgument(this.getTagletPath()), 1.4f);
            if (this.tags != null) {
                for (i = 0; i < this.tags.length; ++i) {
                    if (StringUtils.isEmpty((String)this.tags[i].getName())) {
                        this.getLog().info((CharSequence)"A tag name is empty. Ignore this option.");
                        continue;
                    }
                    String value = "\"" + this.tags[i].getName();
                    if (StringUtils.isNotEmpty((String)this.tags[i].getPlacement())) {
                        value = value + ":" + this.tags[i].getPlacement();
                        if (StringUtils.isNotEmpty((String)this.tags[i].getHead())) {
                            value = value + ":" + this.tags[i].getHead();
                        }
                    }
                    value = value + "\"";
                    this.addArgIfNotEmpty(arguments, "-tag", value, 1.4f);
                }
            }
            this.addArgIf(arguments, this.use, "-use");
            this.addArgIf(arguments, this.version, "-version");
            this.addArgIfNotEmpty(arguments, "-windowtitle", AbstractJavadocMojo.quotedArgument(this.getWindowtitle()), false, false);
        }
        if (options.length() > 0) {
            this.addCommandLineOptions(cmd, options, arguments, javadocOutputDirectory);
        }
        if (!packageNames.isEmpty()) {
            this.addCommandLinePackages(cmd, javadocOutputDirectory, packageNames);
            if (!filesWithUnnamedPackages.isEmpty()) {
                this.addCommandLineArgFile(cmd, javadocOutputDirectory, filesWithUnnamedPackages);
            }
        } else if (!files.isEmpty()) {
            this.addCommandLineArgFile(cmd, javadocOutputDirectory, files);
        }
        this.getLog().debug((CharSequence)Commandline.toString((String[])cmd.getCommandline()));
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)err);
            if (exitCode != 0) {
                StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                msg.append('\n');
                msg.append("Command line was:" + Commandline.toString((String[])cmd.getCommandline()));
                throw new MavenReportException(msg.toString());
            }
        }
        catch (CommandLineException e) {
            throw new MavenReportException("Unable to execute javadoc command: " + e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)err.getOutput())) {
            this.getLog().info((CharSequence)"Javadoc Warnings");
            StringTokenizer token = new StringTokenizer(err.getOutput(), "\n");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                this.getLog().warn((CharSequence)current);
            }
        }
    }

    protected List getFiles(List sourcePaths) {
        ArrayList files = new ArrayList();
        if (StringUtils.isEmpty((String)this.subpackages)) {
            String[] excludedPackages = this.getExcludedPackages();
            Iterator i = sourcePaths.iterator();
            while (i.hasNext()) {
                File sourceDirectory = new File((String)i.next());
                AbstractJavadocMojo.addFilesFromSource(files, sourceDirectory, excludedPackages);
            }
        }
        return files;
    }

    protected List getSourcePaths() {
        List<Object> sourcePaths;
        if (StringUtils.isEmpty((String)this.sourcepath)) {
            File javadocDir;
            sourcePaths = new ArrayList(this.getProjectSourceRoots(this.project));
            if (this.project.getExecutionProject() != null) {
                sourcePaths.addAll(this.getExecutionProjectSourceRoots(this.project));
            }
            if (this.getJavadocDirectory() != null && (javadocDir = this.getJavadocDirectory()).exists() && javadocDir.isDirectory()) {
                sourcePaths.add(this.getJavadocDirectory().getAbsolutePath());
            }
            if (this.aggregate && this.project.isExecutionRoot()) {
                Iterator i = this.reactorProjects.iterator();
                while (i.hasNext()) {
                    ArtifactHandler artifactHandler;
                    MavenProject subProject = (MavenProject)i.next();
                    if (subProject == this.project) continue;
                    List sourceRoots = this.getProjectSourceRoots(subProject);
                    if (subProject.getExecutionProject() != null) {
                        sourceRoots.addAll(this.getExecutionProjectSourceRoots(subProject));
                    }
                    if ("java".equals((artifactHandler = subProject.getArtifact().getArtifactHandler()).getLanguage())) {
                        sourcePaths.addAll(sourceRoots);
                    }
                    String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                    File javadocDir2 = new File(subProject.getExecutionProject().getBasedir(), javadocDirRelative);
                    if (!javadocDir2.exists() || !javadocDir2.isDirectory()) continue;
                    sourcePaths.add(javadocDir2.getAbsolutePath());
                }
            }
            sourcePaths = AbstractJavadocMojo.pruneSourceDirs(sourcePaths);
        } else {
            sourcePaths = new ArrayList<String>(Arrays.asList(this.sourcepath.split("[;]")));
            if (this.getJavadocDirectory() != null) {
                sourcePaths.add(this.getJavadocDirectory().getAbsolutePath());
            }
            sourcePaths = AbstractJavadocMojo.pruneSourceDirs(sourcePaths);
        }
        return sourcePaths;
    }

    protected boolean canGenerateReport(List files) {
        boolean canGenerate = true;
        if (files.isEmpty() && StringUtils.isEmpty((String)this.subpackages)) {
            canGenerate = false;
        }
        return canGenerate;
    }

    private String getExcludedPackages(List sourcePaths) {
        List excludedNames = null;
        if (StringUtils.isNotEmpty((String)this.sourcepath) && StringUtils.isNotEmpty((String)this.subpackages)) {
            String[] excludedPackages = this.getExcludedPackages();
            String[] subpackagesList = this.subpackages.split("[:]");
            excludedNames = AbstractJavadocMojo.getExcludedNames(sourcePaths, subpackagesList, excludedPackages);
        }
        String excludeArg = "";
        if (StringUtils.isNotEmpty((String)this.subpackages) && excludedNames != null) {
            Iterator it = excludedNames.iterator();
            while (it.hasNext()) {
                String str = (String)it.next();
                excludeArg = excludeArg + str;
                if (!it.hasNext()) continue;
                excludeArg = excludeArg + ":";
            }
        }
        return excludeArg;
    }

    private String getSourcePath(List sourcePaths) {
        String sourcePath = null;
        if (StringUtils.isEmpty((String)this.subpackages) || StringUtils.isNotEmpty((String)this.sourcepath)) {
            sourcePath = StringUtils.join(sourcePaths.iterator(), (String)File.pathSeparator);
        }
        return sourcePath;
    }

    private String[] getExcludedPackages() {
        String[] excludePackages = new String[]{};
        if (this.excludePackageNames != null) {
            excludePackages = this.excludePackageNames.split("[ ,:;]");
        }
        for (int i = 0; i < excludePackages.length; ++i) {
            excludePackages[i] = excludePackages[i].replace('.', File.separatorChar);
        }
        return excludePackages;
    }

    private String getClasspath() throws MavenReportException {
        ArrayList classpathElements = new ArrayList();
        HashMap compileArtifactMap = new HashMap();
        classpathElements.addAll(this.getProjectBuildOutputDirs(this.project));
        this.populateCompileArtifactMap(compileArtifactMap, this.getProjectArtifacts(this.project));
        if (this.aggregate && this.project.isExecutionRoot()) {
            try {
                Iterator i = this.reactorProjects.iterator();
                while (i.hasNext()) {
                    MavenProject subProject = (MavenProject)i.next();
                    if (subProject == this.project) continue;
                    classpathElements.addAll(this.getProjectBuildOutputDirs(subProject));
                    Set dependencyArtifacts = subProject.createArtifacts(this.factory, null, null);
                    if (dependencyArtifacts.isEmpty()) continue;
                    ArtifactResolutionResult result = this.resolver.resolveTransitively(dependencyArtifacts, subProject.getArtifact(), subProject.getRemoteArtifactRepositories(), this.localRepository, this.artifactMetadataSource);
                    this.populateCompileArtifactMap(compileArtifactMap, AbstractJavadocMojo.getCompileArtifacts(result.getArtifacts()));
                }
            }
            catch (AbstractArtifactResolutionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
            catch (InvalidDependencyVersionException e) {
                throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
            }
        }
        classpathElements.addAll(compileArtifactMap.values());
        return StringUtils.join(classpathElements.iterator(), (String)File.pathSeparator);
    }

    private void populateCompileArtifactMap(Map compileArtifactMap, List artifactList) throws MavenReportException {
        if (artifactList != null) {
            Iterator i = artifactList.iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                File file = a.getFile();
                if (file == null) {
                    throw new MavenReportException("Error in plugin descriptor - dependency was not resolved for artifact: " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
                }
                compileArtifactMap.put(a.getDependencyConflictId(), file.getAbsolutePath());
            }
        }
    }

    private String getBottomText(String inceptionYear) {
        int actualYear = Calendar.getInstance().get(1);
        String year = String.valueOf(actualYear);
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }

    private String getStylesheetFile(File javadocOutputDirectory) {
        String stylesheetfile = this.stylesheetfile;
        if (StringUtils.isEmpty((String)stylesheetfile) && "maven".equals(this.stylesheet)) {
            stylesheetfile = javadocOutputDirectory + File.separator + DEFAULT_CSS_NAME;
        }
        return stylesheetfile;
    }

    private String getAccessLevel() {
        String accessLevel;
        if ("public".equalsIgnoreCase(this.show) || "protected".equalsIgnoreCase(this.show) || "package".equalsIgnoreCase(this.show) || "private".equalsIgnoreCase(this.show)) {
            accessLevel = "-" + this.show;
        } else {
            this.getLog().error((CharSequence)("Unrecognized access level to show '" + this.show + "'. Defaulting to protected."));
            accessLevel = "-protected";
        }
        return accessLevel;
    }

    private String getDocletPath() throws MavenReportException {
        StringBuffer path = new StringBuffer();
        if (!this.isDocletArtifactEmpty(this.docletArtifact)) {
            path.append(this.getArtifactAbsolutePath(this.docletArtifact));
        } else if (this.docletArtifacts != null) {
            for (int i = 0; i < this.docletArtifacts.length; ++i) {
                if (this.isDocletArtifactEmpty(this.docletArtifacts[i])) continue;
                path.append(this.getArtifactAbsolutePath(this.docletArtifacts[i]));
                if (i >= this.docletArtifacts.length - 1) continue;
                path.append(File.pathSeparator);
            }
        }
        if (!StringUtils.isEmpty((String)this.docletPath)) {
            path.append(this.docletPath);
        }
        if (StringUtils.isEmpty((String)path.toString())) {
            this.getLog().warn((CharSequence)"No docletpath option was found. Please review <docletpath/> or <docletArtifact/> or <doclets/>.");
        }
        return path.toString();
    }

    private boolean isDocletArtifactEmpty(DocletArtifact docletArtifact) {
        if (docletArtifact == null) {
            return true;
        }
        return StringUtils.isEmpty((String)docletArtifact.getGroupId()) && StringUtils.isEmpty((String)docletArtifact.getArtifactId()) && StringUtils.isEmpty((String)docletArtifact.getVersion());
    }

    private String getTagletPath() throws MavenReportException {
        StringBuffer path = new StringBuffer();
        if (this.tagletArtifact != null && StringUtils.isNotEmpty((String)this.tagletArtifact.getGroupId()) && StringUtils.isNotEmpty((String)this.tagletArtifact.getArtifactId()) && StringUtils.isNotEmpty((String)this.tagletArtifact.getVersion())) {
            path.append(this.getArtifactAbsolutePath(this.tagletArtifact));
        } else if (this.taglets != null) {
            for (int i = 0; i < this.taglets.length; ++i) {
                Taglet current = this.taglets[i];
                if (current == null) continue;
                boolean separated = false;
                if (current.getTagletArtifact() != null) {
                    path.append(this.getArtifactAbsolutePath(current.getTagletArtifact()));
                    separated = true;
                } else if (current.getTagletArtifact() != null && StringUtils.isNotEmpty((String)current.getTagletArtifact().getGroupId()) && StringUtils.isNotEmpty((String)current.getTagletArtifact().getArtifactId()) && StringUtils.isNotEmpty((String)current.getTagletArtifact().getVersion())) {
                    path.append(this.getArtifactAbsolutePath(current.getTagletArtifact()));
                    separated = true;
                } else if (StringUtils.isNotEmpty((String)current.getTagletpath())) {
                    path.append(current.getTagletpath());
                    separated = true;
                }
                if (!separated || i >= this.taglets.length - 1) continue;
                path.append(File.pathSeparator);
            }
        } else {
            path.append(this.tagletpath);
        }
        return path.toString();
    }

    private String getArtifactAbsolutePath(JavadocPathArtifact javadocArtifact) throws MavenReportException {
        if (StringUtils.isEmpty((String)javadocArtifact.getGroupId()) && StringUtils.isEmpty((String)javadocArtifact.getArtifactId()) && StringUtils.isEmpty((String)javadocArtifact.getVersion())) {
            return "";
        }
        Artifact artifact = this.factory.createArtifact(javadocArtifact.getGroupId(), javadocArtifact.getArtifactId(), javadocArtifact.getVersion(), "compile", "jar");
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            return artifact.getFile().getAbsolutePath();
        }
        catch (ArtifactResolutionException e) {
            throw new MavenReportException("Unable to resolve artifact:" + javadocArtifact, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenReportException("Unable to find artifact:" + javadocArtifact, (Exception)((Object)e));
        }
    }

    private void addMemoryArg(Commandline cmd, String arg, String memory) {
        if (StringUtils.isNotEmpty((String)memory)) {
            if (NumberUtils.isDigits((String)memory)) {
                cmd.createArgument().setValue("-J" + arg + memory + "m");
            } else if (NumberUtils.isDigits((String)memory.substring(0, memory.length() - 1)) && memory.toLowerCase().endsWith("m")) {
                cmd.createArgument().setValue("-J" + arg + memory);
            } else {
                this.getLog().error((CharSequence)(arg + " '" + memory + "' is not a valid number. Ignore this option."));
            }
        }
    }

    private String getJavadocExecutable() throws IOException {
        String javadocCommand = "javadoc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)this.javadocExecutable)) {
            File javadocExe = new File(this.javadocExecutable);
            if (!javadocExe.exists() || !javadocExe.isFile()) {
                throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. " + "Verify the <javadocExecutable/> parameter.");
            }
            return javadocExe.getAbsolutePath();
        }
        File javadocExe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "sh", javadocCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getJavaHome() + File.separator + "bin", javadocCommand) : new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "bin", javadocCommand));
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).exists() || !new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is " + "not a valid directory.");
            }
            javadocExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javadocCommand);
        }
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. " + "Verify the JAVA_HOME environment variable.");
        }
        return javadocExe.getAbsolutePath();
    }

    private boolean isJavaDocVersionAtLeast(float requiredVersion) {
        return this.fJavadocVersion >= requiredVersion;
    }

    private void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIf(List arguments, boolean b, String value, float requiredJavaVersion) {
        if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
            this.addArgIf(arguments, b, value);
        } else {
            this.getLog().warn((CharSequence)(value + " option is not supported on Java version < " + requiredJavaVersion));
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value) {
        this.addArgIfNotEmpty(arguments, key, value, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey, boolean splitValue) {
        if (StringUtils.isNotEmpty((String)value)) {
            if (StringUtils.isNotEmpty((String)key)) {
                arguments.add(key);
            }
            if (splitValue) {
                StringTokenizer token = new StringTokenizer(value, ",");
                while (token.hasMoreTokens()) {
                    String current = token.nextToken().trim();
                    if (!StringUtils.isNotEmpty((String)current)) continue;
                    arguments.add(current);
                    if (!token.hasMoreTokens() || !repeatKey) continue;
                    arguments.add(key);
                }
            } else {
                arguments.add(value);
            }
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey) {
        this.addArgIfNotEmpty(arguments, key, value, repeatKey, true);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion) {
        this.addArgIfNotEmpty(arguments, key, value, requiredJavaVersion, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion, boolean repeatKey) {
        if (this.isJavaDocVersionAtLeast(requiredJavaVersion)) {
            this.addArgIfNotEmpty(arguments, key, value, repeatKey);
        } else {
            this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion));
        }
    }

    private void addLinkofflineArguments(List arguments) {
        if (this.offlineLinks != null) {
            for (int i = 0; i < this.offlineLinks.size(); ++i) {
                OfflineLink offlineLink = (OfflineLink)this.offlineLinks.get(i);
                this.addArgIfNotEmpty(arguments, "-linkoffline", AbstractJavadocMojo.quotedPathArgument(offlineLink.getUrl()) + " " + AbstractJavadocMojo.quotedPathArgument(offlineLink.getLocation()), true);
            }
        }
    }

    private void addLinkArguments(List arguments) {
        if (this.links != null) {
            for (int i = 0; i < this.links.size(); ++i) {
                String link = (String)this.links.get(i);
                if (StringUtils.isEmpty((String)link)) continue;
                if (link.endsWith("/")) {
                    link = link.substring(0, link.length() - 1);
                }
                try {
                    URL linkUrl = new URL(link + "/package-list");
                    AbstractJavadocMojo.fetchURL(this.settings, linkUrl);
                    this.addArgIfNotEmpty(arguments, "-link", AbstractJavadocMojo.quotedPathArgument(link), true);
                    continue;
                }
                catch (MalformedURLException e) {
                    this.getLog().error((CharSequence)("Malformed link: " + link + "/package-list. IGNORED IT."));
                    continue;
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error fetching link: " + link + "/package-list. IGNORED IT."));
                }
            }
        }
    }

    private InputStream getStream(String resource) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
    }

    private void copyDefaultStylesheet(File outputDirectory) throws IOException {
        if (outputDirectory == null || !outputDirectory.exists()) {
            throw new IOException("The outputDirectory " + outputDirectory + " doesn't exists.");
        }
        InputStream is = this.getStream(RESOURCE_CSS_DIR + "/" + DEFAULT_CSS_NAME);
        if (is == null) {
            throw new IOException("The resource stylesheet.css doesn't exists.");
        }
        File outputFile = new File(outputDirectory, DEFAULT_CSS_NAME);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileOutputStream w = new FileOutputStream(outputFile);
        IOUtil.copy((InputStream)is, (OutputStream)w);
        IOUtil.close((InputStream)is);
        IOUtil.close((OutputStream)w);
    }

    private void copyJavadocResources(File outputDirectory) throws IOException {
        if (outputDirectory == null || !outputDirectory.exists()) {
            throw new IOException("The outputDirectory " + outputDirectory + " doesn't exists.");
        }
        if (this.getJavadocDirectory() != null) {
            AbstractJavadocMojo.copyJavadocResources(outputDirectory, this.getJavadocDirectory());
        }
        if (this.aggregate && this.project.isExecutionRoot()) {
            Iterator i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject subProject = (MavenProject)i.next();
                if (subProject == this.project) continue;
                String javadocDirRelative = PathUtils.toRelative((File)this.project.getBasedir(), (String)this.getJavadocDirectory().getAbsolutePath());
                File javadocDir = new File(subProject.getBasedir(), javadocDirRelative);
                AbstractJavadocMojo.copyJavadocResources(outputDirectory, javadocDir);
            }
        }
    }

    private List getPackageNames(List sourcePaths, List files) {
        return this.getPackageNamesOrFilesWithUnnamedPackages(sourcePaths, files, true);
    }

    private List getFilesWithUnnamedPackages(List sourcePaths, List files) {
        return this.getPackageNamesOrFilesWithUnnamedPackages(sourcePaths, files, false);
    }

    private List getPackageNamesOrFilesWithUnnamedPackages(List sourcePaths, List files, boolean onlyPackageName) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.sourcepath)) {
            return returnList;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String currentFile = (String)it.next();
            currentFile = currentFile.replace('\\', '/');
            Iterator it2 = sourcePaths.iterator();
            while (it2.hasNext()) {
                String currentSourcePath = (String)it2.next();
                if (!(currentSourcePath = currentSourcePath.replace('\\', '/')).endsWith("/")) {
                    currentSourcePath = currentSourcePath + "/";
                }
                if (currentFile.indexOf(currentSourcePath) == -1) continue;
                String packagename = currentFile.substring(currentSourcePath.length() + 1);
                if (onlyPackageName && packagename.lastIndexOf("/") != -1) {
                    packagename = packagename.substring(0, packagename.lastIndexOf("/"));
                    if (!returnList.contains(packagename = packagename.replace('/', '.'))) {
                        returnList.add(packagename);
                    }
                }
                if (onlyPackageName || packagename.lastIndexOf("/") != -1) continue;
                returnList.add(currentFile);
            }
        }
        return returnList;
    }

    private void addCommandLineOptions(Commandline cmd, StringBuffer options, List arguments, File javadocOutputDirectory) throws MavenReportException {
        File optionsFile = new File(javadocOutputDirectory, "options");
        options.append(" ");
        options.append(StringUtils.join((Object[])arguments.toArray(new String[0]), (String)SystemUtils.LINE_SEPARATOR));
        try {
            FileUtils.fileWrite((String)optionsFile.getAbsolutePath(), (String)options.toString());
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + optionsFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArgument().setValue("@options");
        if (!this.debug) {
            optionsFile.deleteOnExit();
        }
    }

    private void addCommandLineArgFile(Commandline cmd, File javadocOutputDirectory, List files) throws MavenReportException {
        File argfileFile = this.isJavaDocVersionAtLeast(1.4f) ? new File(javadocOutputDirectory, "argfile") : new File(javadocOutputDirectory, "files");
        try {
            FileUtils.fileWrite((String)argfileFile.getAbsolutePath(), (String)StringUtils.join(files.iterator(), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + argfileFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        if (this.isJavaDocVersionAtLeast(1.4f)) {
            cmd.createArgument().setValue("@argfile");
        } else {
            cmd.createArgument().setValue("@files");
        }
        if (!this.debug) {
            argfileFile.deleteOnExit();
        }
    }

    private void addCommandLinePackages(Commandline cmd, File javadocOutputDirectory, List packageNames) throws MavenReportException {
        File packagesFile = new File(javadocOutputDirectory, "packages");
        try {
            FileUtils.fileWrite((String)packagesFile.getAbsolutePath(), (String)StringUtils.join((Object[])packageNames.toArray(new String[0]), (String)SystemUtils.LINE_SEPARATOR));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write '" + packagesFile.getName() + "' temporary file for command execution", (Exception)e);
        }
        cmd.createArgument().setValue("@packages");
        if (!this.debug) {
            packagesFile.deleteOnExit();
        }
    }

    private static List pruneSourceDirs(List sourceDirs) {
        ArrayList<String> pruned = new ArrayList<String>(sourceDirs.size());
        Iterator i = sourceDirs.iterator();
        while (i.hasNext()) {
            String dir = (String)i.next();
            File directory = new File(dir);
            if (!directory.exists() || !directory.isDirectory() || pruned.contains(dir)) continue;
            pruned.add(dir);
        }
        return pruned;
    }

    private static List getExcludedNames(List sourcePaths, String[] subpackagesList, String[] excludedPackages) {
        ArrayList excludedNames = new ArrayList();
        Iterator i = sourcePaths.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            for (int j = 0; j < subpackagesList.length; ++j) {
                List excludes = AbstractJavadocMojo.getExcludedPackages(path, excludedPackages);
                excludedNames.addAll(excludes);
            }
        }
        return excludedNames;
    }

    private static List getCompileArtifacts(Set artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    private static String quotedArgument(String value) {
        String arg = value;
        if (StringUtils.isNotEmpty((String)arg)) {
            if (arg.indexOf("'") != -1) {
                arg = StringUtils.replace((String)arg, (String)"'", (String)"\\'");
            }
            arg = "'" + arg + "'";
        }
        return arg;
    }

    private static String quotedPathArgument(String value) {
        String path = value;
        if (StringUtils.isNotEmpty((String)path)) {
            if ((path = path.replace('\\', '/')).indexOf("'") != -1) {
                String[] split = path.split("'");
                path = "";
                for (int i = 0; i < split.length; ++i) {
                    path = i != split.length - 1 ? path + split[i] + "\\'" : path + split[i];
                }
            }
            path = "'" + path + "'";
        }
        return path;
    }

    private static void copyJavadocResources(File outputDirectory, File javadocDir) throws IOException {
        if (javadocDir.exists() && javadocDir.isDirectory()) {
            List docFiles = FileUtils.getDirectoryNames((File)javadocDir, (String)"**/doc-files", null, (boolean)false, (boolean)true);
            Iterator it = docFiles.iterator();
            while (it.hasNext()) {
                String docFile = (String)it.next();
                File docFileOutput = new File(outputDirectory, docFile);
                FileUtils.mkdir((String)docFileOutput.getAbsolutePath());
                FileUtils.copyDirectory((File)new File(javadocDir, docFile), (File)docFileOutput);
            }
        }
    }

    private static List getIncludedFiles(File sourceDirectory, String[] fileList, String[] excludePackages) {
        ArrayList<String> files = new ArrayList<String>();
        for (int j = 0; j < fileList.length; ++j) {
            boolean include = true;
            for (int k = 0; k < excludePackages.length && include; ++k) {
                String[] excludeName = excludePackages[k].split("[*]");
                if (excludeName.length > 1) {
                    for (int u = 0; include && u < excludeName.length; ++u) {
                        if ("".equals(excludeName[u].trim()) || fileList[j].indexOf(excludeName[u]) == -1) continue;
                        include = false;
                    }
                    continue;
                }
                if (!fileList[j].startsWith(sourceDirectory.toString() + File.separatorChar + excludeName[0])) continue;
                if (excludeName[0].endsWith(String.valueOf(File.separatorChar))) {
                    File excludedPackage;
                    int i = fileList[j].lastIndexOf(File.separatorChar);
                    String packageName = fileList[j].substring(0, i + 1);
                    File currentPackage = new File(packageName);
                    if (currentPackage.equals(excludedPackage = new File(sourceDirectory, excludeName[0])) && fileList[j].substring(i).indexOf(".java") != -1) {
                        include = true;
                        continue;
                    }
                    include = false;
                    continue;
                }
                include = false;
            }
            if (!include) continue;
            files.add(AbstractJavadocMojo.quotedPathArgument(fileList[j]));
        }
        return files;
    }

    private static List getExcludedPackages(String sourceDirectory, String[] excludePackagenames) {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < excludePackagenames.length; ++i) {
            String[] fileList = FileUtils.getFilesFromExtension((String)sourceDirectory, (String[])new String[]{"java"});
            for (int j = 0; j < fileList.length; ++j) {
                String[] excludeName = excludePackagenames[i].split("[*]");
                for (int u = 0; u < excludeName.length; ++u) {
                    if ("".equals(excludeName[u].trim()) || fileList[j].indexOf(excludeName[u]) == -1 || sourceDirectory.indexOf(excludeName[u]) != -1) continue;
                    files.add(fileList[j]);
                }
            }
        }
        ArrayList<String> excluded = new ArrayList<String>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String file = (String)it.next();
            int idx = file.lastIndexOf(File.separatorChar);
            String tmpStr = file.substring(0, idx);
            String[] srcSplit = (tmpStr = tmpStr.replace('\\', '/')).split(sourceDirectory.replace('\\', '/') + '/');
            String excludedPackage = srcSplit[1].replace('/', '.');
            if (excluded.contains(excludedPackage)) continue;
            excluded.add(excludedPackage);
        }
        return excluded;
    }

    private static void addFilesFromSource(List files, File sourceDirectory, String[] excludePackages) {
        String[] fileList = FileUtils.getFilesFromExtension((String)sourceDirectory.getPath(), (String[])new String[]{"java"});
        if (fileList != null && fileList.length != 0) {
            List tmpFiles = AbstractJavadocMojo.getIncludedFiles(sourceDirectory, fileList, excludePackages);
            files.addAll(tmpFiles);
        }
    }

    private static float getJavadocVersion(File javadocExe) throws IOException, CommandLineException {
        if (!javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. ");
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable(javadocExe.getAbsolutePath());
        cmd.setWorkingDirectory(javadocExe.getParentFile());
        cmd.createArgument().setValue("-J-fullversion");
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        if (exitCode != 0) {
            StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
            msg.append('\n');
            msg.append("Command line was:" + Commandline.toString((String[])cmd.getCommandline()));
            throw new CommandLineException(msg.toString());
        }
        StringTokenizer token = new StringTokenizer(err.getOutput(), "\"");
        token.nextToken();
        String version = token.nextToken();
        String str = version.substring(0, 3);
        if (version.length() >= 5) {
            str = str + version.substring(4, 5);
        }
        return Float.parseFloat(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchURL(Settings settings, URL url) throws IOException {
        Proxy proxy;
        String scheme;
        if (url == null) {
            throw new IOException("The url is null");
        }
        if (settings != null && !"file".equals(scheme = url.getProtocol()) && (proxy = settings.getActiveProxy()) != null) {
            scheme = "http".equals(scheme) || "https".equals(scheme) ? "http." : ("ftp".equals(scheme) ? "ftp." : "");
            String host = proxy.getHost();
            if (!StringUtils.isEmpty((String)host)) {
                String userName;
                Properties p = System.getProperties();
                p.setProperty(scheme + "proxySet", "true");
                p.setProperty(scheme + "proxyHost", host);
                p.setProperty(scheme + "proxyPort", String.valueOf(proxy.getPort()));
                if (!StringUtils.isEmpty((String)proxy.getNonProxyHosts())) {
                    p.setProperty(scheme + "nonProxyHosts", proxy.getNonProxyHosts());
                }
                if (!StringUtils.isEmpty((String)(userName = proxy.getUsername()))) {
                    final String pwd = StringUtils.isEmpty((String)proxy.getPassword()) ? "" : proxy.getPassword();
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(userName, pwd.toCharArray());
                        }
                    });
                }
            }
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

