/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.javadoc.JavadocReport;
import org.apache.maven.plugin.javadoc.JavadocUtil;
import org.apache.maven.plugin.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;

public class TestJavadocReport
extends JavadocReport {
    private String testDoctitle;
    private File testOverview;
    private String testWindowtitle;
    private File reportOutputDirectory;
    private String destDir;
    private File testJavadocDirectory;
    private String testName;
    private String testDescription;

    protected void executeReport(Locale unusedLocale) throws MavenReportException {
        this.addMainJavadocLink();
        super.executeReport(unusedLocale);
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.testName)) {
            return this.getBundle(locale).getString("report.test-javadoc.name");
        }
        return this.testName;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.testDescription)) {
            return this.getBundle(locale).getString("report.test-javadoc.description");
        }
        return this.testDescription;
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory, this.destDir);
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.updateReportOutputDirectory(this.reportOutputDirectory, destDir);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory, String destDir) {
        this.reportOutputDirectory = reportOutputDirectory != null && destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(destDir) ? new File(reportOutputDirectory, destDir) : reportOutputDirectory;
    }

    protected List getProjectBuildOutputDirs(MavenProject p) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)p.getBuild().getOutputDirectory())) {
            dirs.add(p.getBuild().getOutputDirectory());
        }
        if (StringUtils.isNotEmpty((String)p.getBuild().getTestOutputDirectory())) {
            dirs.add(p.getBuild().getTestOutputDirectory());
        }
        return dirs;
    }

    protected List getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getTestCompileSourceRoots() == null ? Collections.EMPTY_LIST : new LinkedList(p.getTestCompileSourceRoots());
    }

    protected List getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getExecutionProject().getTestCompileSourceRoots() == null ? Collections.EMPTY_LIST : new LinkedList(p.getExecutionProject().getTestCompileSourceRoots());
    }

    protected List getProjectArtifacts(MavenProject p) {
        return p.getTestArtifacts() == null ? Collections.EMPTY_LIST : new LinkedList(p.getTestArtifacts());
    }

    protected File getJavadocDirectory() {
        return this.testJavadocDirectory;
    }

    protected String getDoctitle() {
        return this.testDoctitle;
    }

    protected File getOverview() {
        return this.testOverview;
    }

    protected String getWindowtitle() {
        return this.testWindowtitle;
    }

    protected List getCompileArtifacts(ArtifactResolutionResult result) {
        return JavadocUtil.getCompileArtifacts(result.getArtifacts(), true);
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("test-javadoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void addMainJavadocLink() {
        File apidocs;
        if (this.links == null) {
            this.links = new ArrayList();
        }
        if ((apidocs = new File(this.getReportOutputDirectory().getParentFile(), "apidocs")).isDirectory() && !this.links.contains("../apidocs")) {
            this.links.add("../apidocs");
        }
    }

    protected SourceResolverConfig configureDependencySourceResolution(SourceResolverConfig config) {
        return super.configureDependencySourceResolution(config).withoutCompileSources().withTestSources();
    }
}

