/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jdeps;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.jdeps.consumers.JDepsConsumer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.MatchPatterns;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJDepsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File outputDirectory;
    @Parameter(defaultValue="true", property="jdeps.failOnWarning")
    private boolean failOnWarning;
    @Parameter
    private String multiRelease;
    @Parameter
    private List<String> dependenciesToAnalyzeIncludes;
    @Parameter
    private List<String> dependenciesToAnalyzeExcludes;
    @Parameter(property="jdeps.dotOutput")
    private File dotOutput;
    @Parameter(property="jdeps.verbose")
    private String verbose;
    @Parameter
    private List<String> packages;
    @Parameter(property="jdeps.include")
    private String include;
    @Parameter(defaultValue="false", property="jdeps.apionly")
    private boolean apiOnly;
    @Parameter(defaultValue="false", property="jdeps.profile")
    private boolean profile;
    @Parameter(defaultValue="false", property="jdeps.recursive")
    private boolean recursive;
    @Parameter(property="jdeps.module")
    private String module;
    @Component
    private ToolchainManager toolchainManager;

    protected MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String jExecutable;
        if (!new File(this.getClassesDirectory()).exists()) {
            this.getLog().debug((CharSequence)"No classes to analyze");
            return;
        }
        try {
            jExecutable = this.getJDepsExecutable();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find jdeps command: " + e.getMessage(), (Throwable)e);
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable(jExecutable);
        Set<Path> dependenciesToAnalyze = this.getDependenciesToAnalyze();
        this.addJDepsOptions(cmd, dependenciesToAnalyze);
        this.addJDepsClasses(cmd, dependenciesToAnalyze);
        JDepsConsumer consumer = new JDepsConsumer();
        this.executeJDepsCommandLine(cmd, this.outputDirectory, consumer);
        if (consumer.getOffendingPackages().size() > 0) {
            String ls = System.getProperty("line.separator");
            StringBuilder msg = new StringBuilder();
            msg.append("Found offending packages:").append(ls);
            for (Map.Entry<String, String> offendingPackage : consumer.getOffendingPackages().entrySet()) {
                msg.append(' ').append(offendingPackage.getKey()).append(" -> ").append(offendingPackage.getValue()).append(ls);
            }
            if (this.isFailOnWarning()) {
                throw new MojoExecutionException(msg.toString());
            }
        }
    }

    protected void addJDepsOptions(Commandline cmd, Set<Path> dependenciesToAnalyze) throws MojoFailureException {
        if (this.dotOutput != null) {
            cmd.createArg().setValue("-dotoutput");
            cmd.createArg().setFile(this.dotOutput);
        }
        if (this.verbose != null) {
            if ("class".equals(this.verbose)) {
                cmd.createArg().setValue("-verbose:class");
            } else if ("package".equals(this.verbose)) {
                cmd.createArg().setValue("-verbose:package");
            } else {
                cmd.createArg().setValue("-v");
            }
        }
        try {
            ArrayList<Path> cp = new ArrayList<Path>();
            for (Path path : this.getClassPath()) {
                if (dependenciesToAnalyze.contains(path)) continue;
                cp.add(path);
            }
            if (!cp.isEmpty()) {
                cmd.createArg().setValue("-cp");
                cmd.createArg().setValue(StringUtils.join(cp.iterator(), (String)File.pathSeparator));
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        if (this.packages != null) {
            for (String pkgName : this.packages) {
                cmd.createArg().setValue("-p");
                cmd.createArg().setValue(pkgName);
            }
        }
        if (this.include != null) {
            cmd.createArg().setValue("-include");
            cmd.createArg().setValue(this.include);
        }
        if (this.profile) {
            cmd.createArg().setValue("-P");
        }
        if (this.module != null) {
            cmd.createArg().setValue("-m");
            cmd.createArg().setValue(this.module);
        }
        if (this.multiRelease != null) {
            cmd.createArg().setValue("--multi-release");
            cmd.createArg().setValue(this.multiRelease);
        }
        if (this.apiOnly) {
            cmd.createArg().setValue("-apionly");
        }
        if (this.recursive) {
            cmd.createArg().setValue("-R");
        }
    }

    protected Set<Path> getDependenciesToAnalyze() {
        LinkedHashSet<Path> jdepsClasses = new LinkedHashSet<Path>();
        jdepsClasses.add(Paths.get(this.getClassesDirectory(), new String[0]));
        if (this.dependenciesToAnalyzeIncludes != null) {
            MatchPatterns includes = MatchPatterns.from(this.dependenciesToAnalyzeIncludes);
            MatchPatterns excludes = this.dependenciesToAnalyzeExcludes != null ? MatchPatterns.from(this.dependenciesToAnalyzeExcludes) : MatchPatterns.from(Collections.emptyList());
            for (Artifact artifact : this.project.getArtifacts()) {
                String versionlessKey = ArtifactUtils.versionlessKey((Artifact)artifact);
                if (!includes.matchesPatternStart(versionlessKey, true) || excludes.matchesPatternStart(versionlessKey, true)) continue;
                jdepsClasses.add(artifact.getFile().toPath());
            }
        }
        return jdepsClasses;
    }

    protected void addJDepsClasses(Commandline cmd, Set<Path> dependenciesToAnalyze) {
        for (Path dependencyToAnalyze : dependenciesToAnalyze) {
            cmd.createArg().setFile(dependencyToAnalyze.toFile());
        }
    }

    private String getJDepsExecutable() throws IOException {
        Toolchain tc = this.getToolchain();
        String jdepsExecutable = null;
        if (tc != null) {
            jdepsExecutable = tc.findTool("jdeps");
        }
        String jdepsCommand = "jdeps" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)jdepsExecutable)) {
            File jdepsExe = new File(jdepsExecutable);
            if (jdepsExe.isDirectory()) {
                jdepsExe = new File(jdepsExe, jdepsCommand);
            }
            if (SystemUtils.IS_OS_WINDOWS && jdepsExe.getName().indexOf(46) < 0) {
                jdepsExe = new File(jdepsExe.getPath() + ".exe");
            }
            if (!jdepsExe.isFile()) {
                throw new IOException("The jdeps executable '" + jdepsExe + "' doesn't exist or is not a file.");
            }
            return jdepsExe.getAbsolutePath();
        }
        File jdepsExe = new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "sh", jdepsCommand);
        if (!jdepsExe.exists() || !jdepsExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).getCanonicalFile().exists() || new File(javaHome).getCanonicalFile().isFile()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            jdepsExe = new File(javaHome + File.separator + "bin", jdepsCommand);
        }
        if (!jdepsExe.getCanonicalFile().exists() || !jdepsExe.getCanonicalFile().isFile()) {
            throw new IOException("The jdeps executable '" + jdepsExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return jdepsExe.getAbsolutePath();
    }

    private void executeJDepsCommandLine(Commandline cmd, File jOutputDirectory, CommandLineUtils.StringStreamConsumer consumer) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executing: " + CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", "")));
        }
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = consumer != null ? consumer : new CommandLineUtils.StringStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (exitCode != 0) {
                if (StringUtils.isNotEmpty(output)) {
                    this.getLog().info((CharSequence)output);
                }
                StringBuilder msg = new StringBuilder("\nExit code: ");
                msg.append(exitCode);
                if (StringUtils.isNotEmpty((String)err.getOutput())) {
                    msg.append(" - ").append(err.getOutput());
                }
                msg.append('\n');
                msg.append("Command line was: ").append(cmd).append('\n').append('\n');
                throw new MojoExecutionException(msg.toString());
            }
            if (StringUtils.isNotEmpty(output)) {
                this.getLog().info((CharSequence)output);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute jdeps command: " + e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"JDeps Warnings");
            StringTokenizer token = new StringTokenizer(err.getOutput(), "\n");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                this.getLog().warn((CharSequence)current);
            }
        }
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null && (tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)) == null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", Collections.singletonMap("version", "[1.8,)"));
                if (tcs != null && tcs.size() > 0) {
                    tc = (Toolchain)tcs.get(tcs.size() - 1);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return tc;
    }

    protected boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    protected abstract String getClassesDirectory();

    protected abstract Collection<Path> getClassPath() throws DependencyResolutionRequiredException;
}

