/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;

public class RepositoryUtils {
    private final Log log;
    private final ProjectBuilder projectBuilder;
    private final RepositorySystem repositorySystem;
    private final List<ArtifactRepository> remoteRepositories;
    private final List<ArtifactRepository> pluginRepositories;
    private final ArtifactResolver resolver;
    private final ProjectBuildingRequest buildingRequest;

    public RepositoryUtils(Log log, ProjectBuilder projectBuilder, RepositorySystem repositorySystem, ArtifactResolver resolver, List<ArtifactRepository> remoteRepositories, List<ArtifactRepository> pluginRepositories, ProjectBuildingRequest buildingRequest, RepositoryMetadataManager repositoryMetadataManager) {
        this.log = log;
        this.projectBuilder = projectBuilder;
        this.repositorySystem = repositorySystem;
        this.resolver = resolver;
        this.remoteRepositories = remoteRepositories;
        this.pluginRepositories = pluginRepositories;
        this.buildingRequest = buildingRequest;
    }

    public void resolve(Artifact artifact) throws ArtifactResolverException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>(this.pluginRepositories.size() + this.remoteRepositories.size());
        repos.addAll(this.pluginRepositories);
        repos.addAll(this.remoteRepositories);
        DefaultProjectBuildingRequest buildRequest = new DefaultProjectBuildingRequest(this.buildingRequest);
        buildRequest.setRemoteRepositories(repos);
        ArtifactResult result = this.resolver.resolveArtifact((ProjectBuildingRequest)buildRequest, artifact);
        artifact.setFile(result.getArtifact().getFile());
    }

    public MavenProject getMavenProjectFromRepository(Artifact artifact) throws ProjectBuildingException {
        Artifact projectArtifact = artifact;
        boolean allowStubModel = false;
        if (!"pom".equals(artifact.getType())) {
            projectArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            allowStubModel = true;
        }
        return this.projectBuilder.build(projectArtifact, allowStubModel, this.buildingRequest).getProject();
    }

    public String getDependencyUrlFromRepository(Artifact artifact, ArtifactRepository repo) {
        if (repo.isBlacklisted()) {
            return null;
        }
        Artifact copyArtifact = ArtifactUtils.copyArtifact((Artifact)artifact);
        if (artifact.isSnapshot() && repo.getSnapshots().isEnabled() && artifact.getBaseVersion().equals(artifact.getVersion()) && (artifact.getMetadataList() == null || artifact.getMetadataList().isEmpty())) {
            try {
                this.resolve(artifact);
            }
            catch (ArtifactResolverException e) {
                this.log.error((CharSequence)("Artifact: " + artifact.getId() + " could not be resolved."));
            }
        }
        return repo.getUrl() + "/" + repo.pathOf(copyArtifact);
    }
}

