/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.dependencies.Dependencies;
import org.apache.maven.report.projectinfo.dependencies.DependenciesReportConfiguration;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.report.projectinfo.dependencies.renderer.DependenciesRenderer;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="dependencies", requiresDependencyResolution=ResolutionScope.TEST)
public class DependenciesReport
extends AbstractProjectInfoReport {
    private static final String RESOURCES_DIR = "org/apache/maven/report/projectinfo/resources";
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private JarClassesAnalysis classesAnalyzer;
    @Component
    private RepositoryMetadataManager repositoryMetadataManager;
    @Parameter(property="dependency.details.enabled", defaultValue="true")
    private boolean dependencyDetailsEnabled;

    @Override
    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            DependencyNode dependencyNode = this.resolveProject();
            Dependencies dependencies = new Dependencies(this.project, dependencyNode, this.classesAnalyzer);
            result = dependencies.hasDependencies();
        }
        return result;
    }

    public void executeReport(Locale locale) {
        try {
            this.copyResources(new File(this.getOutputDirectory()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot copy ressources", (Throwable)e);
        }
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
        buildingRequest.setLocalRepository(this.localRepository);
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        buildingRequest.setPluginArtifactRepositories(this.pluginRepositories);
        RepositoryUtils repoUtils = new RepositoryUtils(this.getLog(), this.projectBuilder, this.repositorySystem, this.resolver, this.project.getRemoteArtifactRepositories(), this.project.getPluginArtifactRepositories(), (ProjectBuildingRequest)buildingRequest, this.repositoryMetadataManager);
        DependencyNode dependencyNode = this.resolveProject();
        Dependencies dependencies = new Dependencies(this.project, dependencyNode, this.classesAnalyzer);
        DependenciesReportConfiguration config = new DependenciesReportConfiguration(this.dependencyDetailsEnabled);
        DependenciesRenderer r = new DependenciesRenderer(this.getSink(), locale, this.getI18N(locale), this.getLog(), dependencies, dependencyNode, config, repoUtils, this.repositorySystem, this.projectBuilder, (ProjectBuildingRequest)buildingRequest, this.getLicenseMappings());
        r.render();
    }

    public String getOutputName() {
        return "dependencies";
    }

    @Override
    protected String getI18Nsection() {
        return "dependencies";
    }

    private DependencyNode resolveProject() {
        try {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            return this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, (ArtifactFilter)artifactFilter);
        }
        catch (DependencyGraphBuilderException e) {
            this.getLog().error((CharSequence)"Unable to build dependency tree.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(File outputDirectory) throws IOException {
        InputStream resourceList = null;
        InputStream in = null;
        LineNumberReader reader = null;
        FileOutputStream out = null;
        try {
            resourceList = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/maven/report/projectinfo/resources/resources.txt");
            if (resourceList != null) {
                reader = new LineNumberReader(new InputStreamReader(resourceList, "US-ASCII"));
                String line = ((BufferedReader)reader).readLine();
                while (line != null) {
                    in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/maven/report/projectinfo/resources/" + line);
                    if (in == null) {
                        throw new IOException("The resource " + line + " doesn't exist.");
                    }
                    File outputFile = new File(outputDirectory, line);
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    out = new FileOutputStream(outputFile);
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                    out = null;
                    in.close();
                    in = null;
                    line = ((BufferedReader)reader).readLine();
                }
                reader.close();
                reader = null;
            }
        }
        finally {
            IOUtil.close(out);
            IOUtil.close(reader);
            IOUtil.close(in);
            IOUtil.close((InputStream)resourceList);
        }
    }
}

