/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleasePerformRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="perform", aggregator=true, requiresProject=false)
public class PerformReleaseMojo
extends AbstractReleaseMojo {
    @Parameter(property="goals")
    private String goals;
    @Parameter(property="releaseProfiles")
    private String releaseProfiles;
    @Parameter(defaultValue="${project.build.directory}/checkout", property="workingDirectory", required=true)
    private File workingDirectory;
    @Parameter(property="connectionUrl")
    private String connectionUrl;
    @Parameter(defaultValue="true", property="useReleaseProfile")
    private boolean useReleaseProfile;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;

    protected String getAdditionalProfiles() {
        return this.releaseProfiles;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.goals != null) {
            this.goals = StringUtils.join((Object[])StringUtils.split((String)this.goals), (String)" ");
        }
        try {
            ReleaseDescriptor releaseDescriptor = this.createReleaseDescriptor();
            if (this.connectionUrl != null) {
                releaseDescriptor.setScmSourceUrl(this.connectionUrl);
            }
            releaseDescriptor.setCheckoutDirectory(this.workingDirectory.getAbsolutePath());
            releaseDescriptor.setUseReleaseProfile(this.useReleaseProfile);
            if (this.goals == null) {
                this.goals = "deploy";
                if (this.project.getDistributionManagement() != null && this.project.getDistributionManagement().getSite() != null) {
                    this.goals = this.goals + " site-deploy";
                }
            }
            releaseDescriptor.setPerformGoals(this.goals);
            ReleasePerformRequest performRequest = new ReleasePerformRequest();
            performRequest.setReleaseDescriptor(releaseDescriptor);
            performRequest.setReleaseEnvironment(this.getReleaseEnvironment());
            performRequest.setReactorProjects(this.getReactorProjects());
            performRequest.setDryRun(Boolean.valueOf(this.dryRun));
            this.releaseManager.perform(performRequest);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

