/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public class TagMojo
extends AbstractScmMojo {
    private String tag;
    private String message;
    private String timestampFormat;
    private boolean addTimestamp;
    private String timestampPosition;
    private String timestampPrefix;
    private boolean remoteTagging;

    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            SimpleDateFormat dateFormat = null;
            String tagTimestamp = "";
            String finalTag = this.tag;
            if (this.addTimestamp) {
                try {
                    this.getLog().info((CharSequence)("Using timestamp pattern '" + this.timestampFormat + "'"));
                    dateFormat = new SimpleDateFormat(this.timestampFormat);
                    tagTimestamp = dateFormat.format(new Date());
                    this.getLog().info((CharSequence)("Using timestamp '" + tagTimestamp + "'"));
                }
                catch (IllegalArgumentException e) {
                    String msg = "The timestamp format '" + this.timestampFormat + "' is invalid.";
                    this.getLog().error((CharSequence)msg, (Throwable)e);
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                finalTag = "end".equals(this.timestampPosition) ? finalTag + this.timestampPrefix + tagTimestamp : tagTimestamp + this.timestampPrefix + finalTag;
            }
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            finalTag = provider.sanitizeTagName(finalTag);
            this.getLog().info((CharSequence)("Final Tag Name: '" + finalTag + "'"));
            ScmTagParameters scmTagParameters = new ScmTagParameters(this.message);
            scmTagParameters.setRemoteTagging(this.remoteTagging);
            TagScmResult result = provider.tag(repository, this.getFileSet(), finalTag, scmTagParameters);
            this.checkResult((ScmResult)result);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run tag command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run tag command : ", (Exception)((Object)e));
        }
    }
}

