/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

@Component(role=Shader.class, hint="default")
public class DefaultShader
extends AbstractLogEnabled
implements Shader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shade(ShadeRequest shadeRequest) throws IOException, MojoExecutionException {
        HashSet<String> resources = new HashSet<String>();
        ResourceTransformer manifestTransformer = null;
        ArrayList<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>(shadeRequest.getResourceTransformers());
        Iterator it = transformers.iterator();
        while (it.hasNext()) {
            ResourceTransformer transformer = (ResourceTransformer)it.next();
            if (!(transformer instanceof ManifestResourceTransformer)) continue;
            manifestTransformer = transformer;
            it.remove();
        }
        RelocatorRemapper remapper = new RelocatorRemapper(shadeRequest.getRelocators());
        shadeRequest.getUberJar().getParentFile().mkdirs();
        JarOutputStream out = null;
        try {
            out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(shadeRequest.getUberJar())));
            this.goThroughAllJarEntriesForManifestTransformer(shadeRequest, resources, manifestTransformer, out);
            HashMultimap duplicates = HashMultimap.create((int)10000, (int)3);
            this.shadeJars(shadeRequest, resources, transformers, remapper, out, (Multimap<String, File>)duplicates);
            HashMultimap overlapping = HashMultimap.create((int)20, (int)15);
            for (String clazz : duplicates.keySet()) {
                Collection jarz = duplicates.get((Object)clazz);
                if (jarz.size() <= 1) continue;
                overlapping.put((Object)jarz, (Object)clazz);
            }
            this.logSummaryOfDuplicates((Multimap<Collection<File>, String>)overlapping);
            if (overlapping.keySet().size() > 0) {
                this.showOverlappingWarning();
            }
            for (ResourceTransformer transformer : transformers) {
                if (!transformer.hasTransformedResource()) continue;
                transformer.modifyOutputStream(out);
            }
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((OutputStream)out);
        for (Filter filter : shadeRequest.getFilters()) {
            filter.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shadeJars(ShadeRequest shadeRequest, Set<String> resources, List<ResourceTransformer> transformers, RelocatorRemapper remapper, JarOutputStream jos, Multimap<String, File> duplicates) throws IOException, MojoExecutionException {
        for (File jar : shadeRequest.getJars()) {
            this.getLogger().debug("Processing JAR " + jar);
            List<Filter> jarFilters = this.getFilters(jar, shadeRequest.getFilters());
            JarFile jarFile = this.newJarFile(jar);
            try {
                Enumeration<JarEntry> j = jarFile.entries();
                while (j.hasMoreElements()) {
                    JarEntry entry = j.nextElement();
                    String name = entry.getName();
                    if ("META-INF/INDEX.LIST".equals(name) || entry.isDirectory() || this.isFiltered(jarFilters, name)) continue;
                    this.shadeSingleJar(shadeRequest, resources, transformers, remapper, jos, duplicates, jar, jarFile, entry, name);
                }
            }
            finally {
                jarFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shadeSingleJar(ShadeRequest shadeRequest, Set<String> resources, List<ResourceTransformer> transformers, RelocatorRemapper remapper, JarOutputStream jos, Multimap<String, File> duplicates, File jar, JarFile jarFile, JarEntry entry, String name) throws IOException, MojoExecutionException {
        InputStream in = null;
        try {
            String dir;
            in = jarFile.getInputStream(entry);
            String mappedName = remapper.map(name);
            int idx = mappedName.lastIndexOf(47);
            if (idx != -1 && !resources.contains(dir = mappedName.substring(0, idx))) {
                this.addDirectory(resources, jos, dir);
            }
            if (name.endsWith(".class")) {
                duplicates.put((Object)name, (Object)jar);
                this.addRemappedClass(remapper, jos, jar, name, in);
            } else if (shadeRequest.isShadeSourcesContent() && name.endsWith(".java")) {
                if (resources.contains(mappedName)) {
                    return;
                }
                this.addJavaSource(resources, jos, mappedName, in, shadeRequest.getRelocators());
            } else if (!this.resourceTransformed(transformers, mappedName, in, shadeRequest.getRelocators())) {
                if (resources.contains(mappedName)) {
                    return;
                }
                this.addResource(resources, jos, mappedName, entry.getTime(), in);
            }
            in.close();
            in = null;
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goThroughAllJarEntriesForManifestTransformer(ShadeRequest shadeRequest, Set<String> resources, ResourceTransformer manifestTransformer, JarOutputStream jos) throws IOException {
        if (manifestTransformer != null) {
            block6: for (File jar : shadeRequest.getJars()) {
                JarFile jarFile = this.newJarFile(jar);
                try {
                    Enumeration<JarEntry> en = jarFile.entries();
                    while (en.hasMoreElements()) {
                        JarEntry entry = en.nextElement();
                        String resource = entry.getName();
                        if (!manifestTransformer.canTransformResource(resource)) continue;
                        resources.add(resource);
                        InputStream inputStream = jarFile.getInputStream(entry);
                        try {
                            manifestTransformer.processResource(resource, inputStream, shadeRequest.getRelocators());
                            continue block6;
                        }
                        finally {
                            inputStream.close();
                            continue block6;
                        }
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            if (manifestTransformer.hasTransformedResource()) {
                manifestTransformer.modifyOutputStream(jos);
            }
        }
    }

    private void showOverlappingWarning() {
        this.getLogger().warn("maven-shade-plugin has detected that some class files are");
        this.getLogger().warn("present in two or more JARs. When this happens, only one");
        this.getLogger().warn("single version of the class is copied to the uber jar.");
        this.getLogger().warn("Usually this is not harmful and you can skip these warnings,");
        this.getLogger().warn("otherwise try to manually exclude artifacts based on");
        this.getLogger().warn("mvn dependency:tree -Ddetail=true and the above output.");
        this.getLogger().warn("See http://maven.apache.org/plugins/maven-shade-plugin/");
    }

    private void logSummaryOfDuplicates(Multimap<Collection<File>, String> overlapping) {
        for (Collection jarz : overlapping.keySet()) {
            Object jjar2;
            LinkedList<String> jarzS = new LinkedList<String>();
            for (Object jjar2 : jarz) {
                jarzS.add(((File)jjar2).getName());
            }
            LinkedList<String> classes = new LinkedList<String>();
            jjar2 = overlapping.get((Object)jarz).iterator();
            while (jjar2.hasNext()) {
                String clazz = (String)jjar2.next();
                classes.add(clazz.replace(".class", "").replace("/", "."));
            }
            this.getLogger().warn(Joiner.on((String)", ").join(jarzS) + " define " + classes.size() + " overlapping classes: ");
            int max = 10;
            for (int i = 0; i < Math.min(max, classes.size()); ++i) {
                this.getLogger().warn("  - " + (String)classes.get(i));
            }
            if (classes.size() <= max) continue;
            this.getLogger().warn("  - " + (classes.size() - max) + " more...");
        }
    }

    private JarFile newJarFile(File jar) throws IOException {
        try {
            return new JarFile(jar);
        }
        catch (ZipException zex) {
            throw new ZipException("error in opening zip file " + jar);
        }
    }

    private List<Filter> getFilters(File jar, List<Filter> filters) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter filter : filters) {
            if (!filter.canFilter(jar)) continue;
            list.add(filter);
        }
        return list;
    }

    private void addDirectory(Set<String> resources, JarOutputStream jos, String name) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(resources, jos, parent);
        }
        JarEntry entry = new JarEntry(name + "/");
        jos.putNextEntry(entry);
        resources.add(name);
    }

    private void addRemappedClass(RelocatorRemapper remapper, JarOutputStream jos, File jar, String name, InputStream is) throws IOException, MojoExecutionException {
        if (!remapper.hasRelocators()) {
            try {
                jos.putNextEntry(new JarEntry(name));
                IOUtil.copy((InputStream)is, (OutputStream)jos);
            }
            catch (ZipException e) {
                this.getLogger().debug("We have a duplicate " + name + " in " + jar);
            }
            return;
        }
        ClassReader cr = new ClassReader(is);
        ClassWriter cw = new ClassWriter(0);
        final String pkg = name.substring(0, name.lastIndexOf(47) + 1);
        RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, remapper){

            public void visitSource(String source, String debug) {
                if (source == null) {
                    super.visitSource(source, debug);
                } else {
                    String fqSource = pkg + source;
                    String mappedSource = this.remapper.map(fqSource);
                    String filename = mappedSource.substring(mappedSource.lastIndexOf(47) + 1);
                    super.visitSource(filename, debug);
                }
            }
        };
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable ise) {
            throw new MojoExecutionException("Error in ASM processing class " + name, ise);
        }
        byte[] renamedClass = cw.toByteArray();
        String mappedName = remapper.map(name.substring(0, name.indexOf(46)));
        try {
            jos.putNextEntry(new JarEntry(mappedName + ".class"));
            IOUtil.copy((byte[])renamedClass, (OutputStream)jos);
        }
        catch (ZipException e) {
            this.getLogger().debug("We have a duplicate " + mappedName + " in " + jar);
        }
    }

    private boolean isFiltered(List<Filter> filters, String name) {
        for (Filter filter : filters) {
            if (!filter.isFiltered(name)) continue;
            return true;
        }
        return false;
    }

    private boolean resourceTransformed(List<ResourceTransformer> resourceTransformers, String name, InputStream is, List<Relocator> relocators) throws IOException {
        boolean resourceTransformed = false;
        for (ResourceTransformer transformer : resourceTransformers) {
            if (!transformer.canTransformResource(name)) continue;
            this.getLogger().debug("Transforming " + name + " using " + transformer.getClass().getName());
            transformer.processResource(name, is, relocators);
            resourceTransformed = true;
            break;
        }
        return resourceTransformed;
    }

    private void addJavaSource(Set<String> resources, JarOutputStream jos, String name, InputStream is, List<Relocator> relocators) throws IOException {
        jos.putNextEntry(new JarEntry(name));
        String sourceContent = IOUtil.toString((Reader)new InputStreamReader(is, "UTF-8"));
        for (Relocator relocator : relocators) {
            sourceContent = relocator.applyToSourceContent(sourceContent);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, "UTF-8");
        IOUtil.copy((String)sourceContent, (Writer)writer);
        ((Writer)writer).flush();
        resources.add(name);
    }

    private void addResource(Set<String> resources, JarOutputStream jos, String name, long lastModified, InputStream is) throws IOException {
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(lastModified);
        jos.putNextEntry(jarEntry);
        IOUtil.copy((InputStream)is, (OutputStream)jos);
        resources.add(name);
    }

    static class RelocatorRemapper
    extends Remapper {
        private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+);");
        List<Relocator> relocators;

        public RelocatorRemapper(List<Relocator> relocators) {
            this.relocators = relocators;
        }

        public boolean hasRelocators() {
            return !this.relocators.isEmpty();
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                String prefix = "";
                String suffix = "";
                Matcher m = this.classPattern.matcher(name);
                if (m.matches()) {
                    prefix = m.group(1) + "L";
                    suffix = ";";
                    name = m.group(2);
                }
                for (Relocator r : this.relocators) {
                    if (r.canRelocateClass(name)) {
                        value = prefix + r.relocateClass(name) + suffix;
                        break;
                    }
                    if (!r.canRelocatePath(name)) continue;
                    value = prefix + r.relocatePath(name) + suffix;
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        public String map(String name) {
            String value = name;
            String prefix = "";
            String suffix = "";
            Matcher m = this.classPattern.matcher(name);
            if (m.matches()) {
                prefix = m.group(1) + "L";
                suffix = ";";
                name = m.group(2);
            }
            for (Relocator r : this.relocators) {
                if (!r.canRelocatePath(name)) continue;
                value = prefix + r.relocatePath(name) + suffix;
                break;
            }
            return value;
        }
    }
}

