/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.site.ReportComparator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSiteMojo
extends AbstractMojo {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private String locales;
    protected I18N i18n;
    protected File siteDirectory;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected List reactorProjects;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected String inputEncoding;
    protected String outputEncoding;

    protected List getAvailableLocales() {
        List<Object> localesList = new ArrayList();
        if (this.locales != null) {
            String[] localesArray = StringUtils.split((String)this.locales, (String)",");
            for (int i = 0; i < localesArray.length; ++i) {
                Locale locale = this.codeToLocale(localesArray[i]);
                if (locale == null) continue;
                if (!Arrays.asList(Locale.getAvailableLocales()).contains(locale)) {
                    this.getLog().warn((CharSequence)("The locale parsed defined by '" + locale + "' is not available in this Java Virtual Machine (" + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ") - IGNORING"));
                    continue;
                }
                if (!locale.getLanguage().equals(DEFAULT_LOCALE.getLanguage()) && !this.i18n.getBundle("site-plugin", locale).getLocale().getLanguage().equals(locale.getLanguage())) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("The locale '").append(locale).append("' (");
                    sb.append(locale.getDisplayName(Locale.ENGLISH));
                    sb.append(") is not currently support by Maven - IGNORING. ");
                    sb.append("\n");
                    sb.append("Contribution are welcome and greatly appreciated! ");
                    sb.append("\n");
                    sb.append("If you want to contribute a new translation, please visit ");
                    sb.append("http://maven.apache.org/plugins/maven-site-plugin/i18n.html ");
                    sb.append("for detailed instructions.");
                    this.getLog().warn((CharSequence)sb.toString());
                    continue;
                }
                localesList.add(locale);
            }
        }
        if (localesList.isEmpty()) {
            localesList = Collections.singletonList(DEFAULT_LOCALE);
        }
        return localesList;
    }

    private Locale codeToLocale(String localeCode) {
        if (localeCode == null) {
            return null;
        }
        if ("default".equalsIgnoreCase(localeCode)) {
            return Locale.getDefault();
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
        if (tokenizer.countTokens() > 3) {
            this.getLog().warn((CharSequence)("Invalid java.util.Locale format for '" + localeCode + "' entry - IGNORING"));
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken();
                }
            }
        }
        return new Locale(language, country, variant);
    }

    protected File getSiteDescriptorFile(File basedir, Locale locale) {
        File siteDescriptor = new File(basedir, "src/site/site_" + locale.getLanguage() + ".xml");
        if (!siteDescriptor.exists()) {
            siteDescriptor = new File(basedir, "src/site/site.xml");
        }
        return siteDescriptor;
    }

    protected void populateModules(DecorationModel decorationModel, Locale locale, boolean keepInheritedRefs) throws MojoExecutionException {
        Menu menu = decorationModel.getMenuRef("modules");
        if (!(menu == null || keepInheritedRefs && menu.isInheritAsRef())) {
            if (this.project.getModules().size() > 0) {
                List projects = this.reactorProjects;
                menu.setName(this.i18n.getString("site-plugin", locale, "report.menu.projectmodules"));
                if (projects.size() == 1) {
                    this.getLog().debug((CharSequence)"Attempting to source module information from local filesystem");
                    ArrayList<Model> models = new ArrayList<Model>(this.project.getModules().size());
                    Iterator i = this.project.getModules().iterator();
                    while (i.hasNext()) {
                        Model model;
                        String module = (String)i.next();
                        File f = new File(this.project.getBasedir(), module + "/pom.xml");
                        if (f.exists()) {
                            try {
                                model = this.mavenProjectBuilder.build(f, this.localRepository, null).getModel();
                            }
                            catch (ProjectBuildingException e) {
                                throw new MojoExecutionException("Unable to read local module-POM", (Exception)((Object)e));
                            }
                        } else {
                            this.getLog().warn((CharSequence)"No filesystem module-POM available");
                            model = new Model();
                            model.setName(module);
                            model.setUrl(module);
                        }
                        models.add(model);
                    }
                    this.populateModulesMenuItemsFromModels(models, menu);
                } else {
                    this.populateModulesMenuItemsFromReactorProjects(menu);
                }
            } else {
                decorationModel.removeMenuRef("modules");
            }
        }
    }

    private void populateModulesMenuItemsFromReactorProjects(Menu menu) {
        if (this.reactorProjects != null && this.reactorProjects.size() > 1) {
            Iterator reactorItr = this.reactorProjects.iterator();
            while (reactorItr.hasNext()) {
                MavenProject reactorProject = (MavenProject)reactorItr.next();
                if (reactorProject == null || reactorProject.getParent() == null || !this.project.getArtifactId().equals(reactorProject.getParent().getArtifactId())) continue;
                String reactorUrl = reactorProject.getUrl();
                String name = reactorProject.getName();
                this.appendMenuItem(menu, name, reactorUrl, reactorProject.getArtifactId());
            }
        }
    }

    private void populateModulesMenuItemsFromModels(List models, Menu menu) {
        if (models != null && models.size() > 1) {
            Iterator reactorItr = models.iterator();
            while (reactorItr.hasNext()) {
                Model model = (Model)reactorItr.next();
                String reactorUrl = model.getUrl();
                String name = model.getName();
                this.appendMenuItem(menu, name, reactorUrl, model.getArtifactId());
            }
        }
    }

    private void appendMenuItem(Menu menu, String name, String href, String defaultHref) {
        String selectedHref = href;
        if (selectedHref == null) {
            selectedHref = defaultHref;
        }
        MenuItem item = new MenuItem();
        item.setName(name);
        String baseUrl = this.project.getUrl();
        if (baseUrl != null) {
            selectedHref = this.getRelativePath(selectedHref, baseUrl);
        }
        if (selectedHref.endsWith("/")) {
            item.setHref(selectedHref + "index.html");
        } else {
            item.setHref(selectedHref + "/index.html");
        }
        menu.addItem(item);
    }

    protected void populateReportsMenu(DecorationModel decorationModel, Locale locale, Map categories) {
        Menu menu = decorationModel.getMenuRef("reports");
        if (menu != null) {
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-plugin", locale, "report.menu.projectdocumentation"));
            }
            boolean found = false;
            if (menu.getItems().isEmpty()) {
                MenuItem item;
                List categoryReports = (List)categories.get("Project Info");
                if (!AbstractSiteMojo.isEmptyList(categoryReports)) {
                    item = this.createCategoryMenu(this.i18n.getString("site-plugin", locale, "report.menu.projectinformation"), "/project-info.html", categoryReports, locale);
                    menu.getItems().add(item);
                    found = true;
                }
                if (!AbstractSiteMojo.isEmptyList(categoryReports = (List)categories.get("Project Reports"))) {
                    item = this.createCategoryMenu(this.i18n.getString("site-plugin", locale, "report.menu.projectreports"), "/project-reports.html", categoryReports, locale);
                    menu.getItems().add(item);
                    found = true;
                }
            }
            if (!found) {
                decorationModel.removeMenuRef("reports");
            }
        }
    }

    private MenuItem createCategoryMenu(String name, String href, List categoryReports, Locale locale) {
        MenuItem item = new MenuItem();
        item.setName(name);
        item.setCollapse(true);
        item.setHref(href);
        Collections.sort(categoryReports, new ReportComparator(locale));
        Iterator k = categoryReports.iterator();
        while (k.hasNext()) {
            MavenReport report = (MavenReport)k.next();
            MenuItem subitem = new MenuItem();
            subitem.setName(report.getName(locale));
            subitem.setHref(report.getOutputName() + ".html");
            item.getItems().add(subitem);
        }
        return item;
    }

    protected void populateReportItems(DecorationModel decorationModel, Locale locale, Map reportsByOutputName) {
        Iterator i = decorationModel.getMenus().iterator();
        while (i.hasNext()) {
            Menu menu = (Menu)i.next();
            this.populateItemRefs(menu.getItems(), locale, reportsByOutputName);
        }
    }

    private void populateItemRefs(List items, Locale locale, Map reportsByOutputName) {
        Iterator i = items.iterator();
        while (i.hasNext()) {
            MenuItem item = (MenuItem)i.next();
            if (item.getRef() != null) {
                if (reportsByOutputName.containsKey(item.getRef())) {
                    MavenReport report = (MavenReport)reportsByOutputName.get(item.getRef());
                    if (item.getName() == null) {
                        item.setName(report.getName(locale));
                    }
                    if (item.getHref() == null || item.getHref().length() == 0) {
                        item.setHref(report.getOutputName() + ".html");
                    }
                } else {
                    this.getLog().warn((CharSequence)("Unrecognised reference: '" + item.getRef() + "'"));
                    i.remove();
                }
            }
            this.populateItemRefs(item.getItems(), locale, reportsByOutputName);
        }
    }

    private static boolean isEmptyList(List list) {
        return list == null || list.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getRelativePath(String to, String from) {
        URL toUrl = null;
        URL fromUrl = null;
        String toPath = to;
        String fromPath = from;
        try {
            toUrl = new URL(to);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            fromUrl = new URL(from);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (toUrl != null && fromUrl != null) {
            if (!toUrl.getProtocol().equalsIgnoreCase(fromUrl.getProtocol()) || !toUrl.getHost().equalsIgnoreCase(fromUrl.getHost()) || toUrl.getPort() != fromUrl.getPort()) return to;
            toPath = toUrl.getFile();
            fromPath = fromUrl.getFile();
        } else if (toUrl != null && fromUrl == null || toUrl == null && fromUrl != null) {
            return to;
        }
        toPath = new File(toPath).getPath();
        fromPath = new File(fromPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = toPath.substring(0, 1).toLowerCase() + toPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = fromPath.substring(0, 1).toLowerCase() + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return to;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return to;
        }
        StringTokenizer toTokeniser = new StringTokenizer(toPath, File.separator);
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, File.separator);
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(File.separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, File.separator);
        fromTokeniser = new StringTokenizer(fromPath, File.separator);
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        String relativePath = "";
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath = relativePath + "..";
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + File.separatorChar;
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + File.separatorChar;
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + toTokeniser.nextToken();
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + File.separatorChar;
        }
        if (relativePath.equals(to)) return relativePath;
        this.getLog().debug((CharSequence)("Mapped url: " + to + " to relative path: " + relativePath));
        return relativePath;
    }

    protected void populateProjectParentMenu(DecorationModel decorationModel, Locale locale, MavenProject parentProject, boolean keepInheritedRefs) {
        Menu menu = decorationModel.getMenuRef("parent");
        if (!(menu == null || keepInheritedRefs && menu.isInheritAsRef())) {
            String parentUrl = parentProject.getUrl();
            if (parentUrl != null) {
                parentUrl = parentUrl.endsWith("/") ? parentUrl + "index.html" : parentUrl + "/index.html";
                parentUrl = this.getRelativePath(parentUrl, this.project.getUrl());
                menu.setName(this.i18n.getString("site-plugin", locale, "report.menu.parentproject"));
                MenuItem item = new MenuItem();
                item.setName(parentProject.getName());
                item.setHref(parentUrl);
                menu.addItem(item);
            } else {
                decorationModel.removeMenuRef("parent");
            }
        }
    }

    protected MavenProject getParentProject(MavenProject project) {
        MavenProject parentProject = null;
        MavenProject origParent = project.getParent();
        if (origParent != null) {
            Iterator reactorItr = this.reactorProjects.iterator();
            while (reactorItr.hasNext()) {
                MavenProject reactorProject = (MavenProject)reactorItr.next();
                if (!reactorProject.getGroupId().equals(origParent.getGroupId()) || !reactorProject.getArtifactId().equals(origParent.getArtifactId()) || !reactorProject.getVersion().equals(origParent.getVersion())) continue;
                parentProject = reactorProject;
                break;
            }
            if (parentProject == null && project.getBasedir() != null) {
                try {
                    MavenProject mavenProject = this.mavenProjectBuilder.build(new File(project.getBasedir(), project.getModel().getParent().getRelativePath()), this.localRepository, null);
                    if (mavenProject.getGroupId().equals(origParent.getGroupId()) && mavenProject.getArtifactId().equals(origParent.getArtifactId()) && mavenProject.getVersion().equals(origParent.getVersion())) {
                        parentProject = mavenProject;
                    }
                }
                catch (ProjectBuildingException e) {
                    this.getLog().warn((CharSequence)("Unable to load parent project from repository: " + e.getMessage()));
                }
            }
            if (parentProject == null) {
                try {
                    parentProject = this.mavenProjectBuilder.buildFromRepository(project.getParentArtifact(), project.getRemoteArtifactRepositories(), this.localRepository);
                }
                catch (ProjectBuildingException e) {
                    this.getLog().warn((CharSequence)("Unable to load parent project from repository: " + e.getMessage()));
                }
            }
            if (parentProject == null) {
                parentProject = origParent;
            }
        }
        return parentProject;
    }

    protected String getInterpolatedSiteDescriptorContent(Map props, MavenProject project, String siteDescriptorContent) {
        props.put("inputEncoding", this.inputEncoding);
        props.put("outputEncoding", this.outputEncoding);
        if (project.getName() != null) {
            props.put("project.name", project.getName());
        } else {
            props.put("project.name", "NO_PROJECT_NAME_SET");
        }
        if (project.getUrl() != null) {
            props.put("project.url", project.getUrl());
        } else {
            props.put("project.url", "NO_PROJECT_URL_SET");
        }
        props.put("parentProject", "<menu ref=\"parent\"/>");
        return StringUtils.interpolate((String)siteDescriptorContent, (Map)props);
    }
}

