/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractSiteMojo
extends AbstractMojo {
    protected String locales;
    protected SiteTool siteTool;
    protected I18N i18n;
    protected File siteDirectory;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected List reactorProjects;
    protected MavenProjectBuilder mavenProjectBuilder;
    private String inputEncoding;
    private String outputEncoding;

    protected String getInputEncoding() {
        return this.inputEncoding == null ? "ISO-8859-1" : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected void populateReportItems(DecorationModel decorationModel, Locale locale, Map reportsByOutputName) {
        Iterator i = decorationModel.getMenus().iterator();
        while (i.hasNext()) {
            Menu menu = (Menu)i.next();
            this.populateItemRefs(menu.getItems(), locale, reportsByOutputName);
        }
    }

    private void populateItemRefs(List items, Locale locale, Map reportsByOutputName) {
        Iterator i = items.iterator();
        while (i.hasNext()) {
            MenuItem item = (MenuItem)i.next();
            if (item.getRef() != null) {
                if (reportsByOutputName.containsKey(item.getRef())) {
                    MavenReport report = (MavenReport)reportsByOutputName.get(item.getRef());
                    if (item.getName() == null) {
                        item.setName(report.getName(locale));
                    }
                    if (item.getHref() == null || item.getHref().length() == 0) {
                        item.setHref(report.getOutputName() + ".html");
                    }
                } else {
                    this.getLog().warn((CharSequence)("Unrecognised reference: '" + item.getRef() + "'"));
                    i.remove();
                }
            }
            this.populateItemRefs(item.getItems(), locale, reportsByOutputName);
        }
    }

    protected static String toRelative(File basedir, String absolutePath) {
        String basedirPath;
        String relative = (absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/')) ? absolutePath.substring(basedirPath.length() + 1) : absolutePath;
        return relative;
    }
}

