/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DocumentRenderingContext;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.WriterFactory;

public class ReportDocumentRenderer
implements DocumentRenderer {
    private final MavenReport report;
    private final DocumentRenderingContext docRenderingContext;
    private final String reportMojoInfo;
    private final ClassLoader classLoader;
    private final Log log;

    public ReportDocumentRenderer(MavenReportExecution mavenReportExecution, DocumentRenderingContext docRenderingContext, Log log) {
        this.report = mavenReportExecution.getMavenReport();
        this.docRenderingContext = docRenderingContext;
        this.reportMojoInfo = mavenReportExecution.getGoal() == null ? null : mavenReportExecution.getPlugin().getArtifactId() + ':' + mavenReportExecution.getPlugin().getVersion() + ':' + mavenReportExecution.getGoal();
        this.classLoader = mavenReportExecution.getClassLoader();
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDocument(Writer writer, SiteRenderer siteRenderer, SiteRenderingContext siteRenderingContext) throws RendererException, IOException {
        Locale locale = siteRenderingContext.getLocale();
        String localReportName = this.report.getName(locale);
        String msg = "Generating \"" + MessageUtils.buffer().strong((Object)localReportName) + "\" report";
        this.log.info((CharSequence)(this.reportMojoInfo == null ? msg : StringUtils.rightPad((String)msg, (int)40) + MessageUtils.buffer().strong((Object)" --- ").mojo((Object)this.reportMojoInfo)));
        SiteRendererSink mainSink = new SiteRendererSink(this.docRenderingContext);
        MultiPageSinkFactory multiPageSinkFactory = new MultiPageSinkFactory(this.report, this.docRenderingContext);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            if (this.report instanceof MavenMultiPageReport) {
                ((MavenMultiPageReport)this.report).generate((Sink)mainSink, (SinkFactory)multiPageSinkFactory, locale);
            } else {
                this.report.generate((Sink)mainSink, locale);
            }
        }
        catch (MavenReportException e) {
            String report = this.reportMojoInfo == null ? '\"' + localReportName + '\"' : this.reportMojoInfo;
            throw new RendererException("Error generating " + report + " report", (Throwable)e);
        }
        catch (RuntimeException re) {
            String report = this.reportMojoInfo == null ? '\"' + localReportName + '\"' : this.reportMojoInfo;
            throw new RendererException("Error generating " + report + " report", (Throwable)re);
        }
        catch (LinkageError e) {
            String report = this.reportMojoInfo == null ? '\"' + localReportName + '\"' : this.reportMojoInfo;
            this.log.warn((CharSequence)("An issue has occurred with " + report + " report, skipping LinkageError " + e.getMessage() + ", please report an issue to Maven dev team."), (Throwable)e);
        }
        finally {
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            mainSink.close();
        }
        if (this.report.isExternalReport()) {
            return;
        }
        siteRenderer.mergeDocumentIntoSite(writer, (DocumentContent)mainSink, siteRenderingContext);
        String outputName = "";
        List<MultiPageSubSink> sinks = multiPageSinkFactory.sinks();
        this.log.debug((CharSequence)("Multipage report: " + sinks.size() + " subreports"));
        for (MultiPageSubSink mySink : sinks) {
            outputName = mySink.getOutputName();
            this.log.debug((CharSequence)("  Rendering " + outputName));
            if (!mySink.getOutputDirectory().exists()) {
                mySink.getOutputDirectory().mkdirs();
            }
            File outputFile = new File(mySink.getOutputDirectory(), outputName);
            try {
                Writer out = WriterFactory.newWriter((File)outputFile, (String)siteRenderingContext.getOutputEncoding());
                Throwable throwable = null;
                try {
                    siteRenderer.mergeDocumentIntoSite(out, (DocumentContent)mySink, siteRenderingContext);
                    mySink.close();
                    mySink = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            finally {
                if (mySink == null) continue;
                mySink.close();
            }
        }
    }

    public String getOutputName() {
        return this.docRenderingContext.getOutputName();
    }

    public DocumentRenderingContext getRenderingContext() {
        return this.docRenderingContext;
    }

    public boolean isOverwrite() {
        return true;
    }

    public boolean isExternalReport() {
        return this.report.isExternalReport();
    }

    public String getReportMojoInfo() {
        return this.reportMojoInfo;
    }

    private static class MultiPageSinkFactory
    implements SinkFactory {
        private MavenReport report;
        private DocumentRenderingContext docRenderingContext;
        private List<MultiPageSubSink> sinks = new ArrayList<MultiPageSubSink>();

        MultiPageSinkFactory(MavenReport report, DocumentRenderingContext docRenderingContext) {
            this.report = report;
            this.docRenderingContext = docRenderingContext;
        }

        public Sink createSink(File outputDirectory, String outputName) {
            String document = PathTool.getRelativeFilePath((String)this.report.getReportOutputDirectory().getPath(), (String)new File(outputDirectory, outputName).getPath());
            document = document.substring(0, document.lastIndexOf(46));
            DocumentRenderingContext subSinkContext = new DocumentRenderingContext(this.docRenderingContext.getBasedir(), this.docRenderingContext.getBasedirRelativePath(), document, this.docRenderingContext.getParserId(), this.docRenderingContext.getExtension(), this.docRenderingContext.isEditable(), this.docRenderingContext.getGenerator());
            MultiPageSubSink sink = new MultiPageSubSink(outputDirectory, outputName, subSinkContext);
            this.sinks.add(sink);
            return sink;
        }

        public Sink createSink(File arg0, String arg1, String arg2) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0, String arg1) throws IOException {
            return null;
        }

        public List<MultiPageSubSink> sinks() {
            return this.sinks;
        }
    }

    private static class MultiPageSubSink
    extends SiteRendererSink {
        private File outputDirectory;
        private String outputName;

        MultiPageSubSink(File outputDirectory, String outputName, DocumentRenderingContext docRenderingContext) {
            super(docRenderingContext);
            this.outputName = outputName;
            this.outputDirectory = outputDirectory;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public File getOutputDirectory() {
            return this.outputDirectory;
        }
    }
}

