/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.source;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractJarSourceMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    private MavenProject project;
    protected String packaging;
    private MavenProject executedProject;
    private boolean attach = true;
    private MavenProjectHelper projectHelper;
    protected File outputDirectory;
    protected String finalName;

    public abstract void execute() throws MojoExecutionException;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public MavenProject getExecutedProject() {
        return this.executedProject;
    }

    public void setExecutedProject(MavenProject executedProject) {
        this.executedProject = executedProject;
    }

    protected File[] addDirectories(List compileSourceRoots, List resources, File[] sourceDirectories) {
        int count = 0;
        Iterator i = compileSourceRoots.iterator();
        while (i.hasNext()) {
            sourceDirectories[count] = new File((String)i.next());
            ++count;
        }
        i = resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            sourceDirectories[count] = new File(resource.getDirectory());
            ++count;
        }
        return sourceDirectories;
    }

    protected File[] getTestSources() {
        List testCompileSourceRoots = this.executedProject.getTestCompileSourceRoots();
        List testResources = this.executedProject.getTestResources();
        File[] testSourceDirectories = new File[testCompileSourceRoots.size() + testResources.size()];
        testSourceDirectories = this.addDirectories(testCompileSourceRoots, testResources, testSourceDirectories);
        return testSourceDirectories;
    }

    protected File[] getDefaultSources() {
        List compileSourceRoots = this.executedProject.getCompileSourceRoots();
        List resources = this.executedProject.getResources();
        File[] sourceDirectories = new File[compileSourceRoots.size() + resources.size()];
        sourceDirectories = this.addDirectories(compileSourceRoots, resources, sourceDirectories);
        return sourceDirectories;
    }

    protected void createJar(File outputFile, File[] sourceDirectories, Archiver archiver) throws IOException, ArchiverException {
        this.makeSourceBundle(outputFile, sourceDirectories, archiver);
    }

    protected void attachArtifact(File outputFile, String classifier) {
        if (!this.attach) {
            this.getLog().info((CharSequence)"NOT adding java-sources to attached artifacts list.");
        } else {
            this.projectHelper.attachArtifact(this.project, "java-source", classifier, outputFile);
        }
    }

    protected void makeSourceBundle(File outputFile, File[] sourceDirectories, Archiver archiver) throws ArchiverException, IOException {
        String[] includes = DEFAULT_INCLUDES;
        for (int i = 0; i < sourceDirectories.length; ++i) {
            if (!sourceDirectories[i].exists()) continue;
            archiver.addDirectory(sourceDirectories[i], includes, FileUtils.getDefaultExcludes());
        }
        archiver.setDestFile(outputFile);
        archiver.createArchive();
    }

    protected Archiver createArchiver() throws ArchiverException {
        JarArchiver archiver = new JarArchiver();
        if (this.project.getBuild() != null) {
            List resources = this.project.getBuild().getResources();
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
                archiver.addDirectory(new File(r.getDirectory()));
            }
        }
        return archiver;
    }
}

