/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Singleton
@Named
public class MavenCrypto {
    private final DefaultSecDispatcher secDispatcher;
    private final PlexusCipher plexusCipher;

    @Inject
    public MavenCrypto(DefaultSecDispatcher secDispatcher, PlexusCipher plexusCipher) {
        this.secDispatcher = secDispatcher;
        this.plexusCipher = plexusCipher;
        this.secDispatcher.setConfigurationFile("~/.m2/settings-security.xml");
    }

    public String decrypt(String value) throws MavenCryptoException {
        try {
            return this.secDispatcher.decrypt(value);
        }
        catch (SecDispatcherException e) {
            throw new MavenCryptoException("decrypt failed", e);
        }
    }

    public void decryptProperties(Properties properties) throws MavenCryptoException {
        String[] keys;
        for (String key : keys = new String[]{"scm.password", "scm.passphrase"}) {
            String value = properties.getProperty(key);
            if (value == null) continue;
            properties.put(key, this.decryptDecorated(value));
        }
    }

    public String encryptAndDecorate(String passwd) throws MavenCryptoException {
        try {
            String master = this.getMaster();
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            return cipher.encryptAndDecorate(passwd, masterPasswd);
        }
        catch (PlexusCipherException e) {
            throw new MavenCryptoException("encrypt failed", e);
        }
    }

    public boolean isEncryptedString(String str) {
        return this.plexusCipher.isEncryptedString(str);
    }

    private String decryptDecorated(String value) throws MavenCryptoException {
        try {
            String master = this.getMaster();
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            return cipher.decryptDecorated(value, masterPasswd);
        }
        catch (PlexusCipherException e) {
            throw new MavenCryptoException("decrypt failed", e);
        }
    }

    private String getMaster() throws MavenCryptoException {
        String configurationFile = this.secDispatcher.getConfigurationFile();
        if (configurationFile.startsWith("~")) {
            configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
        }
        String file = System.getProperty("settings.security", configurationFile);
        String master = null;
        try {
            SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
            if (sec != null) {
                master = sec.getMaster();
            }
        }
        catch (SecDispatcherException e) {
            throw new MavenCryptoException("config file read failed", e);
        }
        if (master == null) {
            throw new MavenCryptoException("Master password is not set in the setting security file: " + file);
        }
        return master;
    }

    public static class MavenCryptoException
    extends Exception {
        private MavenCryptoException(String message) {
            super(message);
        }

        private MavenCryptoException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

