/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.tools.ReportComparator;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSiteTool
extends AbstractLogEnabled
implements SiteTool {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    protected I18N i18n;
    protected DecorationModelInheritanceAssembler assembler;
    protected MavenProjectBuilder mavenProjectBuilder;

    @Override
    public Artifact getSkinArtifactFromRepository(ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories, DecorationModel decoration) throws SiteToolException {
        Artifact artifact;
        if (localRepository == null) {
            throw new IllegalArgumentException("The parameter 'localRepository' can not be null");
        }
        if (remoteArtifactRepositories == null) {
            throw new IllegalArgumentException("The parameter 'remoteArtifactRepositories' can not be null");
        }
        if (decoration == null) {
            throw new IllegalArgumentException("The parameter 'decoration' can not be null");
        }
        Skin skin = decoration.getSkin();
        if (skin == null) {
            skin = Skin.getDefaultSkin();
        }
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.artifactFactory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.artifactResolver.resolve(artifact, remoteArtifactRepositories, localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new SiteToolException("InvalidVersionSpecificationException: The skin version '" + version + "' is not valid: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new SiteToolException("ArtifactResolutionException: Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new SiteToolException("ArtifactNotFoundException: The skin does not exist: " + e.getMessage(), (Exception)((Object)e));
        }
        return artifact;
    }

    @Override
    public Artifact getDefaultSkinArtifact(ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories) throws SiteToolException {
        return this.getSkinArtifactFromRepository(localRepository, remoteArtifactRepositories, new DecorationModel());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getRelativePath(String to, String from) {
        if (to == null) {
            throw new IllegalArgumentException("The parameter 'to' can not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("The parameter 'from' can not be null");
        }
        URL toUrl = null;
        URL fromUrl = null;
        String toPath = to;
        String fromPath = from;
        try {
            toUrl = new URL(to);
        }
        catch (MalformedURLException e) {
            try {
                toUrl = new File(DefaultSiteTool.getNormalizedPath(to)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                this.getLogger().warn("Unable to load a URL for '" + to + "': " + e.getMessage());
            }
        }
        try {
            fromUrl = new URL(from);
        }
        catch (MalformedURLException e) {
            try {
                fromUrl = new File(DefaultSiteTool.getNormalizedPath(from)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                this.getLogger().warn("Unable to load a URL for '" + from + "': " + e.getMessage());
            }
        }
        if (toUrl != null && fromUrl != null) {
            if (!toUrl.getProtocol().equalsIgnoreCase(fromUrl.getProtocol()) || !toUrl.getHost().equalsIgnoreCase(fromUrl.getHost()) || toUrl.getPort() != fromUrl.getPort()) return to;
            toPath = toUrl.getFile();
            fromPath = fromUrl.getFile();
        } else if (toUrl != null && fromUrl == null || toUrl == null && fromUrl != null) {
            return to;
        }
        toPath = new File(toPath).getPath();
        fromPath = new File(fromPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = toPath.substring(0, 1).toLowerCase() + toPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = fromPath.substring(0, 1).toLowerCase() + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return to;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return to;
        }
        StringTokenizer toTokeniser = new StringTokenizer(toPath, File.separator);
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, File.separator);
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(File.separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, File.separator);
        fromTokeniser = new StringTokenizer(fromPath, File.separator);
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        StringBuilder relativePath = new StringBuilder();
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath.append("..");
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath.append(File.separatorChar);
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath.append(File.separatorChar);
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath.append(toTokeniser.nextToken());
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath.append(File.separatorChar);
        }
        if (!this.getLogger().isDebugEnabled() || relativePath.equals(to)) return relativePath.toString();
        this.getLogger().debug("Mapped url: " + to + " to relative path: " + relativePath);
        return relativePath.toString();
    }

    @Override
    public File getSiteDescriptorFromBasedir(String siteDirectory, File basedir, Locale locale) {
        File siteDir;
        File siteDescriptor;
        if (basedir == null) {
            throw new IllegalArgumentException("The parameter 'basedir' can not be null");
        }
        if (siteDirectory == null) {
            siteDirectory = "src/site";
        }
        if (locale == null) {
            locale = new Locale("");
        }
        if (!(siteDescriptor = new File(siteDir = new File(basedir, siteDirectory), "site_" + locale.getLanguage() + ".xml")).isFile()) {
            siteDescriptor = new File(siteDir, "site.xml");
        }
        return siteDescriptor;
    }

    @Override
    public File getSiteDescriptorFromRepository(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Locale locale) throws SiteToolException {
        if (project == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (localRepository == null) {
            throw new IllegalArgumentException("The parameter 'localRepository' can not be null");
        }
        if (repositories == null) {
            throw new IllegalArgumentException("The parameter 'remoteArtifactRepositories' can not be null");
        }
        if (locale == null) {
            locale = new Locale("");
        }
        try {
            return this.resolveSiteDescriptor(project, localRepository, repositories, locale);
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("ArtifactNotFoundException: Unable to locate site descriptor: " + (Object)((Object)e));
            return null;
        }
        catch (ArtifactResolutionException e) {
            throw new SiteToolException("ArtifactResolutionException: Unable to locate site descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SiteToolException("IOException: Unable to locate site descriptor: " + e.getMessage(), e);
        }
    }

    @Override
    public DecorationModel getDecorationModel(MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, List<ArtifactRepository> repositories, String siteDirectory, Locale locale, String inputEncoding, String outputEncoding) throws SiteToolException {
        if (project == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (reactorProjects == null) {
            throw new IllegalArgumentException("The parameter 'reactorProjects' can not be null");
        }
        if (localRepository == null) {
            throw new IllegalArgumentException("The parameter 'localRepository' can not be null");
        }
        if (repositories == null) {
            throw new IllegalArgumentException("The parameter 'repositories' can not be null");
        }
        if (inputEncoding == null) {
            throw new IllegalArgumentException("The parameter 'inputEncoding' can not be null");
        }
        if (outputEncoding == null) {
            throw new IllegalArgumentException("The parameter 'outputEncoding' can not be null");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("reports", "<menu ref=\"reports\"/>\n");
        props.put("modules", "<menu ref=\"modules\"/>\n");
        MavenProject parentProject = this.getParentProject(project, reactorProjects, localRepository);
        DecorationModel decorationModel = this.getDecorationModel(project, parentProject, reactorProjects, localRepository, repositories, siteDirectory, locale, props, inputEncoding, outputEncoding);
        if (decorationModel == null) {
            String siteDescriptorContent;
            try {
                siteDescriptorContent = IOUtil.toString((InputStream)this.getClass().getResourceAsStream("/default-site.xml"), (String)"UTF-8");
            }
            catch (IOException e) {
                throw new SiteToolException("Error reading default site descriptor: " + e.getMessage(), e);
            }
            siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(props, project, siteDescriptorContent, inputEncoding, outputEncoding);
            decorationModel = this.readDecorationModel(siteDescriptorContent);
        }
        if (parentProject != null) {
            this.populateParentMenu(decorationModel, locale, project, parentProject, true);
        }
        this.populateModulesMenu(project, reactorProjects, localRepository, decorationModel, locale, true);
        if (decorationModel.getBannerLeft() == null) {
            Banner banner = new Banner();
            banner.setName(project.getName());
            decorationModel.setBannerLeft(banner);
        }
        if (project.getUrl() != null) {
            this.assembler.resolvePaths(decorationModel, project.getUrl());
        } else {
            this.getLogger().warn("No URL defined for the project - decoration links will not be resolved");
        }
        return decorationModel;
    }

    @Override
    public void populateReportsMenu(DecorationModel decorationModel, Locale locale, Map<String, List<MavenReport>> categories) {
        Menu menu;
        if (decorationModel == null) {
            throw new IllegalArgumentException("The parameter 'decorationModel' can not be null");
        }
        if (categories == null) {
            throw new IllegalArgumentException("The parameter 'categories' can not be null");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((menu = decorationModel.getMenuRef("reports")) != null) {
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-tool", locale, "decorationModel.menu.projectdocumentation"));
            }
            boolean found = false;
            if (menu.getItems().isEmpty()) {
                MenuItem item;
                List<MavenReport> categoryReports = categories.get("Project Info");
                if (!DefaultSiteTool.isEmptyList(categoryReports)) {
                    item = this.createCategoryMenu(this.i18n.getString("site-tool", locale, "decorationModel.menu.projectinformation"), "/project-info.html", categoryReports, locale);
                    menu.getItems().add(item);
                    found = true;
                }
                if (!DefaultSiteTool.isEmptyList(categoryReports = categories.get("Project Reports"))) {
                    item = this.createCategoryMenu(this.i18n.getString("site-tool", locale, "decorationModel.menu.projectreports"), "/project-reports.html", categoryReports, locale);
                    menu.getItems().add(item);
                    found = true;
                }
            }
            if (!found) {
                decorationModel.removeMenuRef("reports");
            }
        }
    }

    @Override
    public String getInterpolatedSiteDescriptorContent(Map<String, String> props, MavenProject aProject, String siteDescriptorContent, String inputEncoding, String outputEncoding) throws SiteToolException {
        if (props == null) {
            throw new IllegalArgumentException("The parameter 'props' can not be null");
        }
        if (aProject == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (siteDescriptorContent == null) {
            throw new IllegalArgumentException("The parameter 'siteDescriptorContent' can not be null");
        }
        if (inputEncoding == null) {
            throw new IllegalArgumentException("The parameter 'inputEncoding' can not be null");
        }
        if (outputEncoding == null) {
            throw new IllegalArgumentException("The parameter 'outputEncoding' can not be null");
        }
        HashMap<String, String> modulesProps = new HashMap<String, String>();
        modulesProps.put("modules", "<menu ref=\"modules\"/>");
        siteDescriptorContent = StringUtils.interpolate((String)siteDescriptorContent, modulesProps);
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        try {
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        }
        catch (IOException e) {
            throw new SiteToolException("IOException: cannot interpolate environment properties: " + e.getMessage(), e);
        }
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)aProject));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)aProject.getProperties()));
        siteDescriptorContent = interpolator.interpolate(siteDescriptorContent, "project");
        props.put("inputEncoding", inputEncoding);
        props.put("outputEncoding", outputEncoding);
        props.put("parentProject", "<menu ref=\"parent\"/>");
        props.put("reports", "<menu ref=\"reports\"/>");
        return StringUtils.interpolate((String)siteDescriptorContent, props);
    }

    @Override
    public MavenProject getParentProject(MavenProject aProject, List<MavenProject> reactorProjects, ArtifactRepository localRepository) {
        if (aProject == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (reactorProjects == null) {
            throw new IllegalArgumentException("The parameter 'reactorProjects' can not be null");
        }
        if (localRepository == null) {
            throw new IllegalArgumentException("The parameter 'localRepository' can not be null");
        }
        MavenProject parentProject = null;
        MavenProject origParent = aProject.getParent();
        if (origParent != null) {
            for (MavenProject reactorProject : reactorProjects) {
                if (!reactorProject.getGroupId().equals(origParent.getGroupId()) || !reactorProject.getArtifactId().equals(origParent.getArtifactId()) || !reactorProject.getVersion().equals(origParent.getVersion())) continue;
                parentProject = reactorProject;
                break;
            }
            if (parentProject == null && aProject.getBasedir() != null && StringUtils.isNotEmpty((String)aProject.getModel().getParent().getRelativePath())) {
                try {
                    MavenProject mavenProject;
                    File pomFile = new File(aProject.getBasedir(), aProject.getModel().getParent().getRelativePath());
                    if (pomFile.isDirectory()) {
                        pomFile = new File(pomFile, "pom.xml");
                    }
                    if ((pomFile = new File(DefaultSiteTool.getNormalizedPath(pomFile.getPath()))).isFile() && (mavenProject = this.mavenProjectBuilder.build(pomFile, localRepository, null)).getGroupId().equals(origParent.getGroupId()) && mavenProject.getArtifactId().equals(origParent.getArtifactId()) && mavenProject.getVersion().equals(origParent.getVersion())) {
                        parentProject = mavenProject;
                    }
                }
                catch (ProjectBuildingException e) {
                    this.getLogger().info("Unable to load parent project from a relative path: " + e.getMessage());
                }
            }
            if (parentProject == null) {
                try {
                    parentProject = this.mavenProjectBuilder.buildFromRepository(aProject.getParentArtifact(), aProject.getRemoteArtifactRepositories(), localRepository);
                    this.getLogger().info("Parent project loaded from repository: " + parentProject.getId());
                }
                catch (ProjectBuildingException e) {
                    this.getLogger().warn("Unable to load parent project from repository: " + e.getMessage());
                }
            }
            if (parentProject == null) {
                parentProject = origParent;
            }
        }
        return parentProject;
    }

    @Override
    public void populateParentMenu(DecorationModel decorationModel, Locale locale, MavenProject project, MavenProject parentProject, boolean keepInheritedRefs) {
        Menu menu;
        if (decorationModel == null) {
            throw new IllegalArgumentException("The parameter 'decorationModel' can not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (parentProject == null) {
            throw new IllegalArgumentException("The parameter 'parentProject' can not be null");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((menu = decorationModel.getMenuRef("parent")) == null) {
            return;
        }
        if (!keepInheritedRefs || !menu.isInheritAsRef()) {
            String parentUrl = parentProject.getUrl();
            if (parentUrl != null) {
                parentUrl = parentUrl.endsWith("/") ? parentUrl + "index.html" : parentUrl + "/index.html";
                parentUrl = this.getRelativePath(parentUrl, project.getUrl());
            } else {
                File parentBasedir = parentProject.getBasedir();
                if (parentBasedir != null) {
                    String parentPath = parentBasedir.getAbsolutePath();
                    String projectPath = project.getBasedir().getAbsolutePath();
                    parentUrl = this.getRelativePath(parentPath, projectPath) + "/index.html";
                }
            }
            if (parentUrl == null) {
                this.getLogger().warn("Unable to find a URL to the parent project. The parent menu will NOT be added.");
            } else {
                if (menu.getName() == null) {
                    menu.setName(this.i18n.getString("site-tool", locale, "decorationModel.menu.parentproject"));
                }
                MenuItem item = new MenuItem();
                item.setName(parentProject.getName());
                item.setHref(parentUrl);
                menu.addItem(item);
            }
        }
    }

    @Override
    public void populateProjectParentMenu(DecorationModel decorationModel, Locale locale, MavenProject project, MavenProject parentProject, boolean keepInheritedRefs) {
        this.populateParentMenu(decorationModel, locale, project, parentProject, keepInheritedRefs);
    }

    @Override
    public void populateModules(MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, DecorationModel decorationModel, Locale locale, boolean keepInheritedRefs) throws SiteToolException {
        this.populateModulesMenu(project, reactorProjects, localRepository, decorationModel, locale, keepInheritedRefs);
    }

    @Override
    public void populateModulesMenu(MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, DecorationModel decorationModel, Locale locale, boolean keepInheritedRefs) throws SiteToolException {
        Menu menu;
        if (project == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (reactorProjects == null) {
            throw new IllegalArgumentException("The parameter 'reactorProjects' can not be null");
        }
        if (localRepository == null) {
            throw new IllegalArgumentException("The parameter 'localRepository' can not be null");
        }
        if (decorationModel == null) {
            throw new IllegalArgumentException("The parameter 'decorationModel' can not be null");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((menu = decorationModel.getMenuRef("modules")) == null) {
            return;
        }
        if (!keepInheritedRefs || !menu.isInheritAsRef()) {
            if (project.getModules().size() > 0) {
                List<MavenProject> projects = reactorProjects;
                if (menu.getName() == null) {
                    menu.setName(this.i18n.getString("site-tool", locale, "decorationModel.menu.projectmodules"));
                }
                if (projects.size() == 1) {
                    this.getLogger().debug("Attempting to load module information from local filesystem");
                    ArrayList<Model> models = new ArrayList<Model>(project.getModules().size());
                    for (String module : project.getModules()) {
                        Model model;
                        File f = new File(project.getBasedir(), module + "/pom.xml");
                        if (f.exists()) {
                            try {
                                model = this.mavenProjectBuilder.build(f, localRepository, null).getModel();
                            }
                            catch (ProjectBuildingException e) {
                                throw new SiteToolException("Unable to read local module-POM", (Exception)((Object)e));
                            }
                        } else {
                            this.getLogger().warn("No filesystem module-POM available");
                            model = new Model();
                            model.setName(module);
                            model.setUrl(module);
                        }
                        models.add(model);
                    }
                    this.populateModulesMenuItemsFromModels(project, models, menu);
                } else {
                    this.populateModulesMenuItemsFromReactorProjects(project, reactorProjects, menu);
                }
            } else {
                decorationModel.removeMenuRef("modules");
            }
        }
    }

    @Override
    public List<Locale> getAvailableLocales(String locales) {
        List<Locale> localesList = new ArrayList<Locale>();
        if (locales != null) {
            String[] localesArray = StringUtils.split((String)locales, (String)",");
            for (int i = 0; i < localesArray.length; ++i) {
                Locale locale = this.codeToLocale(localesArray[i]);
                if (locale == null) continue;
                if (!Arrays.asList(Locale.getAvailableLocales()).contains(locale)) {
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn("The locale parsed defined by '" + locale + "' is not available in this Java Virtual Machine (" + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ") - IGNORING");
                    continue;
                }
                if (!locale.getLanguage().equals(DEFAULT_LOCALE.getLanguage()) && !this.i18n.getBundle("site-tool", locale).getLocale().getLanguage().equals(locale.getLanguage())) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("The locale '").append(locale).append("' (");
                    sb.append(locale.getDisplayName(Locale.ENGLISH));
                    sb.append(") is not currently support by Maven - IGNORING. ");
                    sb.append("\n");
                    sb.append("Contribution are welcome and greatly appreciated! ");
                    sb.append("\n");
                    sb.append("If you want to contribute a new translation, please visit ");
                    sb.append("http://maven.apache.org/plugins/maven-site-plugin/i18n.html ");
                    sb.append("for detailed instructions.");
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn(sb.toString());
                    continue;
                }
                localesList.add(locale);
            }
        }
        if (localesList.isEmpty()) {
            localesList = Collections.singletonList(DEFAULT_LOCALE);
        }
        return localesList;
    }

    @Override
    public Locale codeToLocale(String localeCode) {
        if (localeCode == null) {
            return null;
        }
        if ("default".equalsIgnoreCase(localeCode)) {
            return Locale.getDefault();
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
        int maxTokens = 3;
        if (tokenizer.countTokens() > 3) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Invalid java.util.Locale format for '" + localeCode + "' entry - IGNORING");
            }
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken();
                }
            }
        }
        return new Locale(language, country, variant);
    }

    protected static String getNormalizedPath(String path) {
        String normalized = FilenameUtils.normalize((String)path);
        if (normalized == null) {
            normalized = path;
        }
        return normalized == null ? null : normalized.replace('\\', '/');
    }

    private File resolveSiteDescriptor(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Locale locale) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        File result;
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site_" + locale.getLanguage());
        boolean found = false;
        try {
            this.artifactResolver.resolve(artifact, repositories, localRepository);
            result = artifact.getFile();
            if (result.length() > 0L) {
                found = true;
            } else {
                this.getLogger().debug("Skipped site descriptor for locale " + locale.getLanguage());
            }
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("Unable to locate site descriptor for locale " + locale.getLanguage() + ": " + (Object)((Object)e));
            result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            result.getParentFile().mkdirs();
            result.createNewFile();
        }
        if (!found) {
            artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site");
            try {
                this.artifactResolver.resolve(artifact, repositories, localRepository);
            }
            catch (ArtifactNotFoundException e) {
                result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                result.getParentFile().mkdirs();
                result.createNewFile();
                throw e;
            }
            result = artifact.getFile();
            if (result.length() == 0L) {
                this.getLogger().debug("Skipped remote site descriptor check");
                result = null;
            }
        }
        return result;
    }

    private DecorationModel getDecorationModel(MavenProject project, MavenProject parentProject, List<MavenProject> reactorProjects, ArtifactRepository localRepository, List<ArtifactRepository> repositories, String siteDirectory, Locale locale, Map<String, String> origProps, String inputEncoding, String outputEncoding) throws SiteToolException {
        File siteDescriptor;
        HashMap<String, String> props = new HashMap<String, String>(origProps);
        if (project.getBasedir() == null) {
            try {
                siteDescriptor = this.getSiteDescriptorFromRepository(project, localRepository, repositories, locale);
            }
            catch (SiteToolException e) {
                throw new SiteToolException("The site descriptor cannot be resolved from the repository: " + e.getMessage(), e);
            }
        } else {
            siteDescriptor = this.getSiteDescriptorFromBasedir(siteDirectory, project.getBasedir(), locale);
        }
        String siteDescriptorContent = null;
        long siteDescriptorLastModified = 0L;
        try {
            if (siteDescriptor != null && siteDescriptor.exists()) {
                this.getLogger().debug("Reading site descriptor from " + siteDescriptor);
                XmlStreamReader siteDescriptorReader = ReaderFactory.newXmlReader((File)siteDescriptor);
                siteDescriptorContent = IOUtil.toString((Reader)siteDescriptorReader);
                siteDescriptorLastModified = siteDescriptor.lastModified();
            }
        }
        catch (IOException e) {
            throw new SiteToolException("The site descriptor cannot be read!", e);
        }
        DecorationModel decoration = null;
        if (siteDescriptorContent != null) {
            siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(props, project, siteDescriptorContent, inputEncoding, outputEncoding);
            decoration = this.readDecorationModel(siteDescriptorContent);
            decoration.setLastModified(siteDescriptorLastModified);
        }
        if (parentProject != null) {
            this.getLogger().debug("Parent project loaded ...");
            MavenProject parentParentProject = this.getParentProject(parentProject, reactorProjects, localRepository);
            DecorationModel parent = this.getDecorationModel(parentProject, parentParentProject, reactorProjects, localRepository, repositories, siteDirectory, locale, props, inputEncoding, outputEncoding);
            if (decoration == null && parent != null) {
                decoration = new DecorationModel();
            }
            this.assembler.assembleModelInheritance(project.getName(), decoration, parent, project.getUrl(), parentProject.getUrl() == null ? project.getUrl() : parentProject.getUrl());
        }
        if (decoration != null && decoration.getSkin() != null) {
            this.getLogger().debug("Skin used: " + decoration.getSkin());
        }
        return decoration;
    }

    private DecorationModel readDecorationModel(String siteDescriptorContent) throws SiteToolException {
        DecorationModel decoration;
        try {
            decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
        }
        catch (XmlPullParserException e) {
            throw new SiteToolException("Error parsing site descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SiteToolException("Error reading site descriptor", e);
        }
        return decoration;
    }

    private void populateModulesMenuItemsFromReactorProjects(MavenProject project, List<MavenProject> reactorProjects, Menu menu) {
        for (MavenProject moduleProject : this.getModuleProjects(project, reactorProjects, 1)) {
            this.appendMenuItem(project, menu, moduleProject.getName(), moduleProject.getUrl(), moduleProject.getArtifactId());
        }
    }

    private List<MavenProject> getModuleProjects(MavenProject project, List<MavenProject> reactorProjects, int levels) {
        boolean infinite;
        ArrayList<MavenProject> moduleProjects = new ArrayList<MavenProject>();
        boolean bl = infinite = levels == -1;
        if (reactorProjects != null && (infinite || levels > 0)) {
            for (MavenProject reactorProject : reactorProjects) {
                if (!this.isModuleOfProject(project, reactorProject)) continue;
                moduleProjects.add(reactorProject);
                moduleProjects.addAll(this.getModuleProjects(reactorProject, reactorProjects, infinite ? levels : levels - 1));
            }
        }
        return moduleProjects;
    }

    private boolean isModuleOfProject(MavenProject parentProject, MavenProject potentialModule) {
        boolean result = false;
        List modules = parentProject.getModules();
        if (modules != null && parentProject != potentialModule) {
            File parentBaseDir = parentProject.getBasedir();
            for (String module : modules) {
                File moduleBaseDir = new File(parentBaseDir, module);
                try {
                    String rhs;
                    String lhs = potentialModule.getBasedir().getCanonicalPath();
                    if (!lhs.equals(rhs = moduleBaseDir.getCanonicalPath())) continue;
                    result = true;
                    break;
                }
                catch (IOException e) {
                    this.getLogger().error("Error encountered when trying to resolve canonical module paths: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private void populateModulesMenuItemsFromModels(MavenProject project, List<Model> models, Menu menu) {
        if (models != null && models.size() > 1) {
            for (Model model : models) {
                String reactorUrl = model.getUrl();
                String name = model.getName();
                this.appendMenuItem(project, menu, name, reactorUrl, model.getArtifactId());
            }
        }
    }

    private void appendMenuItem(MavenProject project, Menu menu, String name, String href, String defaultHref) {
        String selectedHref = href;
        if (selectedHref == null) {
            selectedHref = defaultHref;
        }
        MenuItem item = new MenuItem();
        item.setName(name);
        String baseUrl = project.getUrl();
        if (baseUrl != null) {
            selectedHref = this.getRelativePath(selectedHref, baseUrl);
        }
        if (selectedHref.endsWith("/")) {
            item.setHref(selectedHref + "index.html");
        } else {
            item.setHref(selectedHref + "/index.html");
        }
        menu.addItem(item);
    }

    private MenuItem createCategoryMenu(String name, String href, List<MavenReport> categoryReports, Locale locale) {
        MenuItem item = new MenuItem();
        item.setName(name);
        item.setCollapse(true);
        item.setHref(href);
        Collections.sort(categoryReports, new ReportComparator(locale));
        for (MavenReport report : categoryReports) {
            MenuItem subitem = new MenuItem();
            subitem.setName(report.getName(locale));
            subitem.setHref(report.getOutputName() + ".html");
            item.getItems().add(subitem);
        }
        return item;
    }

    private static boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }
}

