/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4RunListener
extends RunListener {
    private static final Pattern PARENS = Pattern.compile("^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$");
    protected final Reporter reporter;
    private boolean failureFlag;

    public JUnit4RunListener(Reporter reporter) {
        this.reporter = reporter;
    }

    public void testIgnored(Description description) throws Exception {
        this.reporter.testSkipped((ReportEntry)this.createReportEntry(description));
    }

    public void testStarted(Description description) throws Exception {
        this.reporter.testStarting((ReportEntry)this.createReportEntry(description));
        this.failureFlag = false;
    }

    public void testFailure(Failure failure) throws Exception {
        SimpleReportEntry report = new SimpleReportEntry(this.extractClassName(failure.getDescription()), failure.getTestHeader(), (StackTraceWriter)new JUnit4StackTraceWriter(failure));
        if (failure.getException() instanceof AssertionError) {
            this.reporter.testFailed((ReportEntry)report);
        } else {
            this.reporter.testError((ReportEntry)report);
        }
        this.failureFlag = true;
    }

    public void testAssumptionFailure(Failure failure) {
        this.reporter.testAssumptionFailure((ReportEntry)this.createReportEntry(failure.getDescription()));
        this.failureFlag = true;
    }

    public void testFinished(Description description) throws Exception {
        if (!this.failureFlag) {
            this.reporter.testSucceeded((ReportEntry)this.createReportEntry(description));
        }
    }

    private SimpleReportEntry createReportEntry(Description description) {
        return new SimpleReportEntry(this.extractClassName(description), description.getDisplayName());
    }

    protected String extractClassName(Description description) {
        String displayName = description.getDisplayName();
        Matcher m = PARENS.matcher(displayName);
        if (!m.find()) {
            return displayName;
        }
        return m.group(1);
    }
}

