/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcList;
import org.apache.orc.mapred.OrcMap;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcTimestamp;
import org.apache.orc.mapred.OrcUnion;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.orc.storage.ql.exec.vector.UnionColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.storage.serde2.io.DateWritable;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;

public class OrcMapredRecordReader<V extends WritableComparable>
implements org.apache.hadoop.mapred.RecordReader<NullWritable, V> {
    private final TypeDescription schema;
    private final RecordReader batchReader;
    private final VectorizedRowBatch batch;
    private int rowInBatch;

    public OrcMapredRecordReader(RecordReader reader, TypeDescription schema) throws IOException {
        this.batchReader = reader;
        this.batch = schema.createRowBatch();
        this.schema = schema;
        this.rowInBatch = 0;
    }

    protected OrcMapredRecordReader(Reader fileReader, Reader.Options options) throws IOException {
        this.batchReader = fileReader.rows(options);
        this.schema = options.getSchema() == null ? fileReader.getSchema() : options.getSchema();
        this.batch = this.schema.createRowBatch();
        this.rowInBatch = 0;
    }

    boolean ensureBatch() throws IOException {
        if (this.rowInBatch >= this.batch.size) {
            this.rowInBatch = 0;
            return this.batchReader.nextBatch(this.batch);
        }
        return true;
    }

    public boolean next(NullWritable key, V value) throws IOException {
        if (!this.ensureBatch()) {
            return false;
        }
        if (this.schema.getCategory() == TypeDescription.Category.STRUCT) {
            OrcStruct result = (OrcStruct)value;
            List children = this.schema.getChildren();
            int numberOfChildren = children.size();
            for (int i = 0; i < numberOfChildren; ++i) {
                result.setFieldValue(i, OrcMapredRecordReader.nextValue(this.batch.cols[i], this.rowInBatch, (TypeDescription)children.get(i), result.getFieldValue(i)));
            }
        } else {
            OrcMapredRecordReader.nextValue(this.batch.cols[0], this.rowInBatch, this.schema, value);
        }
        ++this.rowInBatch;
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public V createValue() {
        return (V)OrcStruct.createValue(this.schema);
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        this.batchReader.close();
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    static BooleanWritable nextBoolean(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            BooleanWritable result = previous == null || previous.getClass() != BooleanWritable.class ? new BooleanWritable() : (BooleanWritable)previous;
            result.set(((LongColumnVector)vector).vector[row] != 0L);
            return result;
        }
        return null;
    }

    static ByteWritable nextByte(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            ByteWritable result = previous == null || previous.getClass() != ByteWritable.class ? new ByteWritable() : (ByteWritable)previous;
            result.set((byte)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static ShortWritable nextShort(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            ShortWritable result = previous == null || previous.getClass() != ShortWritable.class ? new ShortWritable() : (ShortWritable)previous;
            result.set((short)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static IntWritable nextInt(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            IntWritable result = previous == null || previous.getClass() != IntWritable.class ? new IntWritable() : (IntWritable)previous;
            result.set((int)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static LongWritable nextLong(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            LongWritable result = previous == null || previous.getClass() != LongWritable.class ? new LongWritable() : (LongWritable)previous;
            result.set(((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static FloatWritable nextFloat(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            FloatWritable result = previous == null || previous.getClass() != FloatWritable.class ? new FloatWritable() : (FloatWritable)previous;
            result.set((float)((DoubleColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static DoubleWritable nextDouble(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            DoubleWritable result = previous == null || previous.getClass() != DoubleWritable.class ? new DoubleWritable() : (DoubleWritable)previous;
            result.set(((DoubleColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static Text nextString(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            Text result = previous == null || previous.getClass() != Text.class ? new Text() : (Text)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.vector[row], bytes.start[row], bytes.length[row]);
            return result;
        }
        return null;
    }

    static BytesWritable nextBinary(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            BytesWritable result = previous == null || previous.getClass() != BytesWritable.class ? new BytesWritable() : (BytesWritable)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.vector[row], bytes.start[row], bytes.length[row]);
            return result;
        }
        return null;
    }

    static HiveDecimalWritable nextDecimal(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HiveDecimalWritable result = previous == null || previous.getClass() != HiveDecimalWritable.class ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
            result.set(((DecimalColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static DateWritable nextDate(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            DateWritable result = previous == null || previous.getClass() != DateWritable.class ? new DateWritable() : (DateWritable)previous;
            int date = (int)((LongColumnVector)vector).vector[row];
            result.set(date);
            return result;
        }
        return null;
    }

    static OrcTimestamp nextTimestamp(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            OrcTimestamp result = previous == null || previous.getClass() != OrcTimestamp.class ? new OrcTimestamp() : (OrcTimestamp)previous;
            TimestampColumnVector tcv = (TimestampColumnVector)vector;
            result.setTime(tcv.time[row]);
            result.setNanos(tcv.nanos[row]);
            return result;
        }
        return null;
    }

    static OrcStruct nextStruct(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            List childrenTypes = schema.getChildren();
            int numChildren = childrenTypes.size();
            OrcStruct result = previous == null || previous.getClass() != OrcStruct.class ? new OrcStruct(schema) : (OrcStruct)previous;
            StructColumnVector struct = (StructColumnVector)vector;
            for (int f = 0; f < numChildren; ++f) {
                result.setFieldValue(f, OrcMapredRecordReader.nextValue(struct.fields[f], row, (TypeDescription)childrenTypes.get(f), result.getFieldValue(f)));
            }
            return result;
        }
        return null;
    }

    static OrcUnion nextUnion(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            List childrenTypes = schema.getChildren();
            OrcUnion result = previous == null || previous.getClass() != OrcUnion.class ? new OrcUnion(schema) : (OrcUnion)previous;
            UnionColumnVector union = (UnionColumnVector)vector;
            byte tag = (byte)union.tags[row];
            result.set(tag, OrcMapredRecordReader.nextValue(union.fields[tag], row, (TypeDescription)childrenTypes.get(tag), result.getObject()));
            return result;
        }
        return null;
    }

    static OrcList nextList(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            int idx;
            List childrenTypes = schema.getChildren();
            TypeDescription valueType = (TypeDescription)childrenTypes.get(0);
            OrcList result = previous == null || previous.getClass() != ArrayList.class ? new OrcList(schema) : (OrcList)previous;
            ListColumnVector list = (ListColumnVector)vector;
            int length = (int)list.lengths[row];
            int offset = (int)list.offsets[row];
            result.ensureCapacity(length);
            int oldLength = result.size();
            for (idx = 0; idx < length && idx < oldLength; ++idx) {
                result.set(idx, OrcMapredRecordReader.nextValue(list.child, offset + idx, valueType, result.get(idx)));
            }
            if (length < oldLength) {
                for (int i = oldLength - 1; i >= length; --i) {
                    result.remove(i);
                }
            } else if (oldLength < length) {
                while (idx < length) {
                    result.add(OrcMapredRecordReader.nextValue(list.child, offset + idx, valueType, null));
                    ++idx;
                }
            }
            return result;
        }
        return null;
    }

    static OrcMap nextMap(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            OrcMap result;
            MapColumnVector map = (MapColumnVector)vector;
            int length = (int)map.lengths[row];
            int offset = (int)map.offsets[row];
            List childrenTypes = schema.getChildren();
            TypeDescription keyType = (TypeDescription)childrenTypes.get(0);
            TypeDescription valueType = (TypeDescription)childrenTypes.get(1);
            if (previous == null || previous.getClass() != OrcMap.class) {
                result = new OrcMap(schema);
            } else {
                result = (OrcMap)previous;
                result.clear();
            }
            for (int e = 0; e < length; ++e) {
                result.put(OrcMapredRecordReader.nextValue(map.keys, e + offset, keyType, null), OrcMapredRecordReader.nextValue(map.values, e + offset, valueType, null));
            }
            return result;
        }
        return null;
    }

    public static WritableComparable nextValue(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return OrcMapredRecordReader.nextBoolean(vector, row, previous);
            }
            case BYTE: {
                return OrcMapredRecordReader.nextByte(vector, row, previous);
            }
            case SHORT: {
                return OrcMapredRecordReader.nextShort(vector, row, previous);
            }
            case INT: {
                return OrcMapredRecordReader.nextInt(vector, row, previous);
            }
            case LONG: {
                return OrcMapredRecordReader.nextLong(vector, row, previous);
            }
            case FLOAT: {
                return OrcMapredRecordReader.nextFloat(vector, row, previous);
            }
            case DOUBLE: {
                return OrcMapredRecordReader.nextDouble(vector, row, previous);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return OrcMapredRecordReader.nextString(vector, row, previous);
            }
            case BINARY: {
                return OrcMapredRecordReader.nextBinary(vector, row, previous);
            }
            case DECIMAL: {
                return OrcMapredRecordReader.nextDecimal(vector, row, previous);
            }
            case DATE: {
                return OrcMapredRecordReader.nextDate(vector, row, previous);
            }
            case TIMESTAMP: {
                return OrcMapredRecordReader.nextTimestamp(vector, row, previous);
            }
            case STRUCT: {
                return OrcMapredRecordReader.nextStruct(vector, row, schema, previous);
            }
            case UNION: {
                return OrcMapredRecordReader.nextUnion(vector, row, schema, previous);
            }
            case LIST: {
                return OrcMapredRecordReader.nextList(vector, row, schema, previous);
            }
            case MAP: {
                return OrcMapredRecordReader.nextMap(vector, row, schema, previous);
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema);
    }
}

