/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.data.FieldSpec;

public interface IndexCreationContext {
    public FieldSpec getFieldSpec();

    public File getIndexDir();

    public boolean isOnHeap();

    public int getLengthOfLongestEntry();

    public int getMaxNumberOfMultiValueElements();

    public int getMaxRowLengthInBytes();

    public boolean isSorted();

    public int getCardinality();

    public int getTotalNumberOfEntries();

    public int getTotalDocs();

    public boolean hasDictionary();

    public Comparable<?> getMinValue();

    public Comparable<?> getMaxValue();

    public static Builder builder() {
        return new Builder();
    }

    public static class Text
    extends Wrapper {
        private final boolean _commitOnClose;
        private final boolean _isFst;
        private final FSTType _fstType;
        private final String[] _sortedUniqueElementsArray;

        public Text(IndexCreationContext wrapped, FSTType fstType, boolean commitOnClose) {
            super(wrapped);
            this._commitOnClose = commitOnClose;
            this._fstType = fstType;
            this._sortedUniqueElementsArray = null;
            this._isFst = false;
        }

        public Text(IndexCreationContext wrapped, FSTType fstType, String[] sortedUniqueElementsArray) {
            super(wrapped);
            this._commitOnClose = true;
            this._fstType = fstType;
            this._sortedUniqueElementsArray = sortedUniqueElementsArray;
            this._isFst = true;
        }

        public boolean isCommitOnClose() {
            return this._commitOnClose;
        }

        public FSTType getFstType() {
            return this._fstType;
        }

        public boolean isFst() {
            return this._isFst;
        }

        public String[] getSortedUniqueElementsArray() {
            return this._sortedUniqueElementsArray;
        }
    }

    public static class Range
    extends Wrapper {
        private final int _rangeIndexVersion;

        Range(IndexCreationContext delegate, int rangeIndexVersion) {
            super(delegate);
            this._rangeIndexVersion = rangeIndexVersion;
        }

        public int getRangeIndexVersion() {
            return this._rangeIndexVersion;
        }
    }

    public static class Json
    extends Wrapper {
        Json(IndexCreationContext delegate) {
            super(delegate);
        }
    }

    public static class Inverted
    extends Wrapper {
        Inverted(IndexCreationContext delegate) {
            super(delegate);
        }
    }

    public static class Geospatial
    extends Wrapper {
        private final H3IndexConfig _h3IndexConfig;

        Geospatial(IndexCreationContext delegate, H3IndexConfig h3IndexConfig) {
            super(delegate);
            this._h3IndexConfig = h3IndexConfig;
        }

        public H3IndexConfig getH3IndexConfig() {
            return this._h3IndexConfig;
        }
    }

    public static class Forward
    extends Wrapper {
        private final ChunkCompressionType _chunkCompressionType;
        private final Map<String, Map<String, String>> _columnProperties;

        Forward(IndexCreationContext delegate, ChunkCompressionType chunkCompressionType, @Nullable Map<String, Map<String, String>> columnProperties) {
            super(delegate);
            this._chunkCompressionType = chunkCompressionType;
            this._columnProperties = columnProperties;
        }

        public ChunkCompressionType getChunkCompressionType() {
            return this._chunkCompressionType;
        }

        @Nullable
        public Map<String, Map<String, String>> getColumnProperties() {
            return this._columnProperties;
        }
    }

    public static class BloomFilter
    extends Wrapper {
        private final BloomFilterConfig _bloomFilterConfig;

        public BloomFilter(IndexCreationContext wrapped, BloomFilterConfig bloomFilterConfig) {
            super(wrapped);
            this._bloomFilterConfig = bloomFilterConfig;
        }

        public BloomFilterConfig getBloomFilterConfig() {
            return this._bloomFilterConfig;
        }
    }

    public static class Wrapper
    implements IndexCreationContext {
        private final IndexCreationContext _delegate;

        Wrapper(IndexCreationContext delegate) {
            this._delegate = delegate;
        }

        @Override
        public FieldSpec getFieldSpec() {
            return this._delegate.getFieldSpec();
        }

        @Override
        public File getIndexDir() {
            return this._delegate.getIndexDir();
        }

        @Override
        public boolean isOnHeap() {
            return this._delegate.isOnHeap();
        }

        @Override
        public int getLengthOfLongestEntry() {
            return this._delegate.getLengthOfLongestEntry();
        }

        @Override
        public int getMaxNumberOfMultiValueElements() {
            return this._delegate.getMaxNumberOfMultiValueElements();
        }

        @Override
        public int getMaxRowLengthInBytes() {
            return this._delegate.getMaxRowLengthInBytes();
        }

        @Override
        public boolean isSorted() {
            return this._delegate.isSorted();
        }

        @Override
        public int getCardinality() {
            return this._delegate.getCardinality();
        }

        @Override
        public int getTotalNumberOfEntries() {
            return this._delegate.getTotalNumberOfEntries();
        }

        @Override
        public int getTotalDocs() {
            return this._delegate.getTotalDocs();
        }

        @Override
        public boolean hasDictionary() {
            return this._delegate.hasDictionary();
        }

        public Comparable getMinValue() {
            return this._delegate.getMinValue();
        }

        public Comparable getMaxValue() {
            return this._delegate.getMaxValue();
        }
    }

    public static final class Common
    implements IndexCreationContext {
        private final File _indexDir;
        private final int _lengthOfLongestEntry;
        private final int _maxNumberOfMultiValueElements;
        private final int _maxRowLengthInBytes;
        private final boolean _onHeap;
        private final FieldSpec _fieldSpec;
        private final boolean _sorted;
        private final int _cardinality;
        private final int _totalNumberOfEntries;
        private final int _totalDocs;
        private final boolean _hasDictionary;
        private final Comparable<?> _minValue;
        private final Comparable<?> _maxValue;

        public Common(File indexDir, int lengthOfLongestEntry, int maxNumberOfMultiValueElements, int maxRowLengthInBytes, boolean onHeap, FieldSpec fieldSpec, boolean sorted, int cardinality, int totalNumberOfEntries, int totalDocs, boolean hasDictionary, Comparable<?> minValue, Comparable<?> maxValue) {
            this._indexDir = indexDir;
            this._lengthOfLongestEntry = lengthOfLongestEntry;
            this._maxNumberOfMultiValueElements = maxNumberOfMultiValueElements;
            this._maxRowLengthInBytes = maxRowLengthInBytes;
            this._onHeap = onHeap;
            this._fieldSpec = fieldSpec;
            this._sorted = sorted;
            this._cardinality = cardinality;
            this._totalNumberOfEntries = totalNumberOfEntries;
            this._totalDocs = totalDocs;
            this._hasDictionary = hasDictionary;
            this._minValue = minValue;
            this._maxValue = maxValue;
        }

        @Override
        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        @Override
        public File getIndexDir() {
            return this._indexDir;
        }

        @Override
        public boolean isOnHeap() {
            return this._onHeap;
        }

        @Override
        public int getLengthOfLongestEntry() {
            return this._lengthOfLongestEntry;
        }

        @Override
        public int getMaxNumberOfMultiValueElements() {
            return this._maxNumberOfMultiValueElements;
        }

        @Override
        public int getMaxRowLengthInBytes() {
            return this._maxRowLengthInBytes;
        }

        @Override
        public boolean isSorted() {
            return this._sorted;
        }

        @Override
        public int getCardinality() {
            return this._cardinality;
        }

        @Override
        public int getTotalNumberOfEntries() {
            return this._totalNumberOfEntries;
        }

        @Override
        public int getTotalDocs() {
            return this._totalDocs;
        }

        @Override
        public boolean hasDictionary() {
            return this._hasDictionary;
        }

        @Override
        public Comparable<?> getMinValue() {
            return this._minValue;
        }

        @Override
        public Comparable<?> getMaxValue() {
            return this._maxValue;
        }

        public BloomFilter forBloomFilter(BloomFilterConfig bloomFilterConfig) {
            return new BloomFilter(this, bloomFilterConfig);
        }

        public Forward forForwardIndex(ChunkCompressionType chunkCompressionType, @Nullable Map<String, Map<String, String>> columnProperties) {
            return new Forward(this, chunkCompressionType, columnProperties);
        }

        public Text forFSTIndex(FSTType fstType, String[] sortedUniqueElementsArray) {
            return new Text((IndexCreationContext)this, fstType, sortedUniqueElementsArray);
        }

        public Geospatial forGeospatialIndex(H3IndexConfig h3IndexConfig) {
            return new Geospatial(this, h3IndexConfig);
        }

        public Inverted forInvertedIndex() {
            return new Inverted(this);
        }

        public Json forJsonIndex() {
            return new Json(this);
        }

        public Range forRangeIndex(int rangeIndexVersion) {
            return new Range(this, rangeIndexVersion);
        }

        public Text forTextIndex(FSTType fstType, boolean commitOnClose) {
            return new Text((IndexCreationContext)this, fstType, commitOnClose);
        }
    }

    public static final class Builder {
        private File _indexDir;
        private int _lengthOfLongestEntry;
        private int _maxNumberOfMultiValueElements;
        private int _maxRowLengthInBytes;
        private boolean _onHeap = false;
        private FieldSpec _fieldSpec;
        private boolean _sorted;
        private int _cardinality;
        private int _totalNumberOfEntries;
        private int _totalDocs;
        private boolean _hasDictionary = true;
        private Comparable<?> _minValue;
        private Comparable<?> _maxValue;

        public Builder withColumnIndexCreationInfo(ColumnIndexCreationInfo columnIndexCreationInfo) {
            return this.withLengthOfLongestEntry(columnIndexCreationInfo.getLengthOfLongestEntry()).withMaxNumberOfMultiValueElements(columnIndexCreationInfo.getMaxNumberOfMultiValueElements()).withMaxRowLengthInBytes(columnIndexCreationInfo.getMaxRowLengthInBytes());
        }

        public Builder withIndexDir(File indexDir) {
            this._indexDir = indexDir;
            return this;
        }

        public Builder onHeap(boolean onHeap) {
            this._onHeap = onHeap;
            return this;
        }

        public Builder withColumnMetadata(ColumnMetadata columnMetadata) {
            return this.withFieldSpec(columnMetadata.getFieldSpec()).sorted(columnMetadata.isSorted()).withCardinality(columnMetadata.getCardinality()).withTotalNumberOfEntries(columnMetadata.getTotalNumberOfEntries()).withTotalDocs(columnMetadata.getTotalDocs()).withDictionary(columnMetadata.hasDictionary()).withMinValue(columnMetadata.getMinValue()).withMaxValue(columnMetadata.getMaxValue());
        }

        public Builder withLengthOfLongestEntry(int lengthOfLongestEntry) {
            this._lengthOfLongestEntry = lengthOfLongestEntry;
            return this;
        }

        public Builder withMaxNumberOfMultiValueElements(int maxNumberOfMultiValueElements) {
            this._maxNumberOfMultiValueElements = maxNumberOfMultiValueElements;
            return this;
        }

        public Builder withMaxRowLengthInBytes(int maxRowLengthInBytes) {
            this._maxRowLengthInBytes = maxRowLengthInBytes;
            return this;
        }

        public Builder withFieldSpec(FieldSpec fieldSpec) {
            this._fieldSpec = fieldSpec;
            return this;
        }

        public Builder sorted(boolean sorted) {
            this._sorted = sorted;
            return this;
        }

        public Builder withCardinality(int cardinality) {
            this._cardinality = cardinality;
            return this;
        }

        public Builder withTotalNumberOfEntries(int totalNumberOfEntries) {
            this._totalNumberOfEntries = totalNumberOfEntries;
            return this;
        }

        public Builder withTotalDocs(int totalDocs) {
            this._totalDocs = totalDocs;
            return this;
        }

        public Builder withDictionary(boolean hasDictionary) {
            this._hasDictionary = hasDictionary;
            return this;
        }

        public Builder withMinValue(Comparable<?> minValue) {
            this._minValue = minValue;
            return this;
        }

        public Builder withMaxValue(Comparable<?> maxValue) {
            this._maxValue = maxValue;
            return this;
        }

        public Common build() {
            return new Common(Objects.requireNonNull(this._indexDir), this._lengthOfLongestEntry, this._maxNumberOfMultiValueElements, this._maxRowLengthInBytes, this._onHeap, Objects.requireNonNull(this._fieldSpec), this._sorted, this._cardinality, this._totalNumberOfEntries, this._totalDocs, this._hasDictionary, this._minValue, this._maxValue);
        }
    }
}

