/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFileSegmentNameGenerator
implements SegmentNameGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputFileSegmentNameGenerator.class);
    private static final String PARAMETER_TEMPLATE = "${filePathPattern:\\%d}";
    private final Pattern _filePathPattern;
    private final String _segmentNameTemplate;
    private final URI _inputFileUri;
    private final String _segmentName;
    private final boolean _appendUUIDToSegmentName;

    public InputFileSegmentNameGenerator(String filePathPattern, String segmentNameTemplate, String inputFileUri) {
        this(filePathPattern, segmentNameTemplate, inputFileUri, false);
    }

    public InputFileSegmentNameGenerator(String filePathPattern, String segmentNameTemplate, String inputFileUri, boolean appendUUIDToSegmentName) {
        Preconditions.checkArgument((filePathPattern != null ? 1 : 0) != 0, (Object)"Missing filePathPattern for InputFileSegmentNameGenerator");
        try {
            this._filePathPattern = Pattern.compile(filePathPattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid filePathPattern: %s for InputFileSegmentNameGenerator", filePathPattern), e);
        }
        Preconditions.checkArgument((segmentNameTemplate != null ? 1 : 0) != 0, (Object)"Missing segmentNameTemplate for InputFileSegmentNameGenerator");
        this._segmentNameTemplate = segmentNameTemplate;
        try {
            this._inputFileUri = new URI(inputFileUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid inputFileUri: %s for InputFileSegmentNameGenerator", inputFileUri), e);
        }
        this._appendUUIDToSegmentName = appendUUIDToSegmentName;
        this._segmentName = this.makeSegmentName();
    }

    private String makeSegmentName() {
        String segmentName;
        String inputFilePath = this._inputFileUri.getPath();
        Matcher m = this._filePathPattern.matcher(inputFilePath);
        if (!m.matches()) {
            LOGGER.warn(String.format("No match for pattern '%s' in '%s'", this._filePathPattern, inputFilePath));
            segmentName = this.safeConvertPathToFilename(inputFilePath);
        } else {
            segmentName = this._segmentNameTemplate;
            for (int i = 1; i <= m.groupCount(); ++i) {
                segmentName = segmentName.replace(String.format(PARAMETER_TEMPLATE, i), m.group(i));
            }
        }
        return this._appendUUIDToSegmentName ? JOINER.join((Object)segmentName, (Object)UUID.randomUUID(), new Object[0]) : segmentName;
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        return this._segmentName;
    }

    private String safeConvertPathToFilename(String inputFilePath) {
        inputFilePath = inputFilePath.replaceFirst("^[/]+", "");
        return inputFilePath.replaceAll("[/\\.]", "_");
    }

    public String toString() {
        return String.format("InputFileSegmentNameGenerator: filePathPattern=%s, segmentNameTemplate=%s, inputFileUri=%s, segmentName=%s", this._filePathPattern, this._segmentNameTemplate, this._inputFileUri, this._segmentName);
    }
}

