/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;

public class SimpleSegmentNameGenerator
implements SegmentNameGenerator {
    private final String _segmentNamePrefix;
    private final String _segmentNamePostfix;
    private final boolean _appendUUIDToSegmentName;

    public SimpleSegmentNameGenerator(String segmentNamePrefix, @Nullable String segmentNamePostfix) {
        this(segmentNamePrefix, segmentNamePostfix, false);
    }

    public SimpleSegmentNameGenerator(String segmentNamePrefix, @Nullable String segmentNamePostfix, boolean appendUUIDToSegmentName) {
        Preconditions.checkArgument((segmentNamePrefix != null ? 1 : 0) != 0, (Object)"Missing segmentNamePrefix for SimpleSegmentNameGenerator");
        Preconditions.checkArgument((boolean)this.isValidSegmentName(segmentNamePrefix), (String)"Invalid segmentNamePrefix: %s for SimpleSegmentNameGenerator", (Object)segmentNamePrefix);
        Preconditions.checkArgument((segmentNamePostfix == null || this.isValidSegmentName(segmentNamePostfix) ? 1 : 0) != 0, (String)"Invalid segmentNamePostfix: %s for SimpleSegmentNameGenerator", (Object)segmentNamePostfix);
        this._segmentNamePrefix = segmentNamePrefix;
        this._segmentNamePostfix = segmentNamePostfix;
        this._appendUUIDToSegmentName = appendUUIDToSegmentName;
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        Preconditions.checkArgument((minTimeValue == null || this.isValidSegmentName(minTimeValue.toString()) ? 1 : 0) != 0, (String)"Invalid minTimeValue: %s for SimpleSegmentNameGenerator", (Object)minTimeValue);
        Preconditions.checkArgument((maxTimeValue == null || this.isValidSegmentName(maxTimeValue.toString()) ? 1 : 0) != 0, (String)"Invalid maxTimeValue: %s for SimpleSegmentNameGenerator", (Object)maxTimeValue);
        return JOINER.join((Object)this._segmentNamePrefix, minTimeValue, new Object[]{maxTimeValue, this._segmentNamePostfix, sequenceId >= 0 ? Integer.valueOf(sequenceId) : null, this._appendUUIDToSegmentName ? UUID.randomUUID() : null});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SimpleSegmentNameGenerator: tableName=").append(this._segmentNamePrefix);
        if (this._segmentNamePostfix != null) {
            stringBuilder.append(", segmentNamePostfix=").append(this._segmentNamePostfix);
        }
        return stringBuilder.toString();
    }
}

