/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.evaluator.json;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.pinot.segment.spi.evaluator.json.JsonPathEvaluator;
import org.apache.pinot.segment.spi.evaluator.json.JsonPathEvaluatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonPathEvaluators {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathEvaluators.class);
    private static final AtomicReferenceFieldUpdater<JsonPathEvaluators, JsonPathEvaluatorProvider> UPDATER = AtomicReferenceFieldUpdater.newUpdater(JsonPathEvaluators.class, JsonPathEvaluatorProvider.class, "_provider");
    private static final JsonPathEvaluators INSTANCE = new JsonPathEvaluators();
    private static final DefaultProvider DEFAULT_PROVIDER = new DefaultProvider();
    private volatile JsonPathEvaluatorProvider _provider;

    public static boolean registerProvider(JsonPathEvaluatorProvider provider) {
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)"");
        if (!UPDATER.compareAndSet(INSTANCE, null, provider)) {
            LOGGER.warn("failed to register {} - {} already registered", (Object)provider, (Object)JsonPathEvaluators.INSTANCE._provider);
            return false;
        }
        return true;
    }

    public static JsonPathEvaluator create(String jsonPath, Object defaultValue) {
        JsonPathEvaluator defaultEvaluator = DEFAULT_PROVIDER.create(jsonPath, defaultValue);
        return Holder.PROVIDER.create(defaultEvaluator, jsonPath, defaultValue);
    }

    private static class DefaultProvider
    implements JsonPathEvaluatorProvider {
        private static final MethodHandle FACTORY;

        private DefaultProvider() {
        }

        public JsonPathEvaluator create(String jsonPath, Object defaultValue) {
            return this.create(null, jsonPath, defaultValue);
        }

        @Override
        public JsonPathEvaluator create(JsonPathEvaluator delegate, String jsonPath, Object defaultValue) {
            try {
                return FACTORY.invokeExact(jsonPath, defaultValue);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        static {
            String className = "org.apache.pinot.core.common.evaluators.DefaultJsonPathEvaluator";
            MethodHandle factory = null;
            try {
                Class<?> clazz = Class.forName(className, false, JsonPathEvaluators.class.getClassLoader());
                factory = MethodHandles.publicLookup().findStatic(clazz, "create", MethodType.methodType(JsonPathEvaluator.class, String.class, Object.class));
            }
            catch (Throwable implausible) {
                LOGGER.error("could not construct MethodHandle for {}", (Object)className, (Object)implausible);
            }
            FACTORY = factory;
        }
    }

    private static final class Holder {
        static final JsonPathEvaluatorProvider PROVIDER;

        private Holder() {
        }

        static {
            JsonPathEvaluatorProvider provider = INSTANCE._provider;
            if (provider == null) {
                provider = DEFAULT_PROVIDER;
                if (!UPDATER.compareAndSet(INSTANCE, null, provider)) {
                    provider = INSTANCE._provider;
                }
            }
            PROVIDER = provider;
        }
    }
}

