/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.metadata;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.partition.PartitionFunctionFactory;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.apache.pinot.spi.utils.BytesUtils;

public class ColumnMetadataImpl
implements ColumnMetadata {
    private final FieldSpec _fieldSpec;
    private final int _totalDocs;
    private final int _cardinality;
    private final boolean _sorted;
    private final Comparable<?> _minValue;
    private final Comparable<?> _maxValue;
    private final boolean _hasDictionary;
    private final int _columnMaxLength;
    private final char _paddingCharacter;
    private final int _bitsPerElement;
    private final int _maxNumberOfMultiValues;
    private final int _totalNumberOfEntries;
    private final PartitionFunction _partitionFunction;
    private final Set<Integer> _partitions;
    private final boolean _autoGenerated;

    private ColumnMetadataImpl(FieldSpec fieldSpec, int totalDocs, int cardinality, boolean sorted, Comparable<?> minValue, Comparable<?> maxValue, boolean hasDictionary, int columnMaxLength, char paddingCharacter, int bitsPerElement, int maxNumberOfMultiValues, int totalNumberOfEntries, @Nullable PartitionFunction partitionFunction, @Nullable Set<Integer> partitions, boolean autoGenerated) {
        this._fieldSpec = fieldSpec;
        this._totalDocs = totalDocs;
        this._cardinality = cardinality;
        this._sorted = sorted;
        this._minValue = minValue;
        this._maxValue = maxValue;
        this._hasDictionary = hasDictionary;
        this._columnMaxLength = columnMaxLength;
        this._paddingCharacter = paddingCharacter;
        this._bitsPerElement = bitsPerElement;
        this._maxNumberOfMultiValues = maxNumberOfMultiValues;
        this._totalNumberOfEntries = totalNumberOfEntries;
        this._partitionFunction = partitionFunction;
        this._partitions = partitions;
        this._autoGenerated = autoGenerated;
    }

    @Override
    public FieldSpec getFieldSpec() {
        return this._fieldSpec;
    }

    @Override
    public int getTotalDocs() {
        return this._totalDocs;
    }

    @Override
    public int getCardinality() {
        return this._cardinality;
    }

    @Override
    public boolean isSorted() {
        return this._sorted;
    }

    @Override
    public Comparable<?> getMinValue() {
        return this._minValue;
    }

    @Override
    public Comparable<?> getMaxValue() {
        return this._maxValue;
    }

    @Override
    public boolean hasDictionary() {
        return this._hasDictionary;
    }

    @Override
    public int getColumnMaxLength() {
        return this._columnMaxLength;
    }

    @Override
    public char getPaddingCharacter() {
        return this._paddingCharacter;
    }

    @Override
    public int getBitsPerElement() {
        return this._bitsPerElement;
    }

    @Override
    public int getMaxNumberOfMultiValues() {
        return this._maxNumberOfMultiValues;
    }

    @Override
    public int getTotalNumberOfEntries() {
        return this._totalNumberOfEntries;
    }

    @Override
    @Nullable
    public PartitionFunction getPartitionFunction() {
        return this._partitionFunction;
    }

    @Override
    @Nullable
    public Set<Integer> getPartitions() {
        return this._partitions;
    }

    @Override
    public boolean isAutoGenerated() {
        return this._autoGenerated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadataImpl that = (ColumnMetadataImpl)o;
        return this._totalDocs == that._totalDocs && this._cardinality == that._cardinality && this._sorted == that._sorted && this._hasDictionary == that._hasDictionary && this._columnMaxLength == that._columnMaxLength && this._paddingCharacter == that._paddingCharacter && this._bitsPerElement == that._bitsPerElement && this._maxNumberOfMultiValues == that._maxNumberOfMultiValues && this._totalNumberOfEntries == that._totalNumberOfEntries && this._autoGenerated == that._autoGenerated && Objects.equals(this._fieldSpec, that._fieldSpec) && Objects.equals(this._minValue, that._minValue) && Objects.equals(this._maxValue, that._maxValue) && Objects.equals(this._partitionFunction, that._partitionFunction) && Objects.equals(this._partitions, that._partitions);
    }

    public int hashCode() {
        return Objects.hash(this._fieldSpec, this._totalDocs, this._cardinality, this._sorted, this._minValue, this._maxValue, this._hasDictionary, this._columnMaxLength, Character.valueOf(this._paddingCharacter), this._bitsPerElement, this._maxNumberOfMultiValues, this._totalNumberOfEntries, this._partitionFunction, this._partitions, this._autoGenerated);
    }

    public String toString() {
        return "ColumnMetadataImpl{_fieldSpec=" + this._fieldSpec + ", _totalDocs=" + this._totalDocs + ", _cardinality=" + this._cardinality + ", _sorted=" + this._sorted + ", _minValue=" + this._minValue + ", _maxValue=" + this._maxValue + ", _hasDictionary=" + this._hasDictionary + ", _columnMaxLength=" + this._columnMaxLength + ", _paddingCharacter=" + this._paddingCharacter + ", _bitsPerElement=" + this._bitsPerElement + ", _maxNumberOfMultiValues=" + this._maxNumberOfMultiValues + ", _totalNumberOfEntries=" + this._totalNumberOfEntries + ", _partitionFunction=" + this._partitionFunction + ", _partitions=" + this._partitions + ", _autoGenerated=" + this._autoGenerated + '}';
    }

    public static ColumnMetadataImpl fromPropertiesConfiguration(String column, PropertiesConfiguration config) {
        MetricFieldSpec fieldSpec;
        Builder builder = new Builder().setTotalDocs(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "totalDocs"))).setCardinality(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "cardinality"))).setSorted(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "isSorted"), false)).setHasDictionary(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "hasDictionary"), true)).setBitsPerElement(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "bitsPerElement"))).setColumnMaxLength(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "lengthOfEachEntry"))).setMaxNumberOfMultiValues(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "maxNumberOfMultiValues"))).setTotalNumberOfEntries(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "totalNumberOfEntries"))).setAutoGenerated(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "isAutoGenerated"), false));
        FieldSpec.FieldType fieldType = FieldSpec.FieldType.valueOf((String)config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "columnType")).toUpperCase());
        FieldSpec.DataType dataType = FieldSpec.DataType.valueOf((String)config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "dataType")).toUpperCase());
        String defaultNullValueString = config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "defaultNullValue"), null);
        switch (fieldType) {
            case DIMENSION: {
                boolean isSingleValue = config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "isSingleValues"));
                fieldSpec = new DimensionFieldSpec(column, dataType, isSingleValue, (Object)defaultNullValueString);
                break;
            }
            case METRIC: {
                fieldSpec = new MetricFieldSpec(column, dataType, (Object)defaultNullValueString);
                break;
            }
            case TIME: {
                TimeUnit timeUnit = TimeUnit.valueOf(config.getString("segment.time.unit", "DAYS").toUpperCase());
                fieldSpec = new TimeFieldSpec(new TimeGranularitySpec(dataType, timeUnit, column));
                break;
            }
            case DATE_TIME: {
                String format = config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeFormat"));
                String granularity = config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeGranularity"));
                fieldSpec = new DateTimeFieldSpec(column, dataType, format, granularity, (Object)defaultNullValueString, null);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported field type: " + fieldType);
            }
        }
        builder.setFieldSpec((FieldSpec)fieldSpec);
        String minString = (String)config.getProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "minValue"));
        String maxString = (String)config.getProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "maxValue"));
        if (minString != null && maxString != null) {
            switch (dataType.getStoredType()) {
                case INT: {
                    builder.setMinValue(Integer.valueOf(minString));
                    builder.setMaxValue(Integer.valueOf(maxString));
                    break;
                }
                case LONG: {
                    builder.setMinValue(Long.valueOf(minString));
                    builder.setMaxValue(Long.valueOf(maxString));
                    break;
                }
                case FLOAT: {
                    builder.setMinValue(Float.valueOf(minString));
                    builder.setMaxValue(Float.valueOf(maxString));
                    break;
                }
                case DOUBLE: {
                    builder.setMinValue(Double.valueOf(minString));
                    builder.setMaxValue(Double.valueOf(maxString));
                    break;
                }
                case BIG_DECIMAL: {
                    builder.setMinValue(new BigDecimal(minString));
                    builder.setMaxValue(new BigDecimal(maxString));
                    break;
                }
                case STRING: {
                    builder.setMinValue((Comparable<?>)((Object)minString));
                    builder.setMaxValue((Comparable<?>)((Object)maxString));
                    break;
                }
                case BYTES: {
                    builder.setMinValue((Comparable<?>)BytesUtils.toByteArray((String)minString));
                    builder.setMaxValue((Comparable<?>)BytesUtils.toByteArray((String)maxString));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + column);
                }
            }
        }
        char paddingCharacter = '%';
        String padding = config.getString("segment.padding.character", null);
        if (padding != null) {
            paddingCharacter = StringEscapeUtils.unescapeJava((String)padding).charAt(0);
        }
        builder.setPaddingCharacter(paddingCharacter);
        String partitionFunctionName = config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionFunction"), null);
        if (partitionFunctionName != null) {
            int numPartitions = config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "numPartitions"));
            HashMap<String, String> partitionFunctionConfigMap = null;
            Configuration partitionFunctionConfig = config.subset(V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionFunctionConfig"));
            if (!partitionFunctionConfig.isEmpty()) {
                partitionFunctionConfigMap = new HashMap<String, String>();
                Iterator partitionFunctionConfigKeysIter = partitionFunctionConfig.getKeys();
                while (partitionFunctionConfigKeysIter.hasNext()) {
                    String functionConfigKey;
                    Object functionConfigValueObj = partitionFunctionConfig.getProperty(functionConfigKey = (String)partitionFunctionConfigKeysIter.next());
                    partitionFunctionConfigMap.put(functionConfigKey, functionConfigValueObj instanceof List ? String.join((CharSequence)",", (List)functionConfigValueObj) : functionConfigValueObj.toString());
                }
            }
            PartitionFunction partitionFunction = PartitionFunctionFactory.getPartitionFunction(partitionFunctionName, numPartitions, partitionFunctionConfigMap);
            builder.setPartitionFunction(partitionFunction);
            builder.setPartitions(ColumnPartitionMetadata.extractPartitions(config.getList(V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionValues"))));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FieldSpec _fieldSpec;
        private int _totalDocs;
        private int _cardinality;
        private boolean _sorted;
        private Comparable<?> _minValue;
        private Comparable<?> _maxValue;
        private boolean _hasDictionary;
        private int _columnMaxLength;
        private char _paddingCharacter;
        private int _bitsPerElement;
        private int _maxNumberOfMultiValues;
        private int _totalNumberOfEntries;
        private PartitionFunction _partitionFunction;
        private Set<Integer> _partitions;
        private boolean _autoGenerated;

        public Builder setFieldSpec(FieldSpec fieldSpec) {
            this._fieldSpec = fieldSpec;
            return this;
        }

        public Builder setTotalDocs(int totalDocs) {
            this._totalDocs = totalDocs;
            return this;
        }

        public Builder setCardinality(int cardinality) {
            this._cardinality = cardinality;
            return this;
        }

        public Builder setSorted(boolean sorted) {
            this._sorted = sorted;
            return this;
        }

        public Builder setMinValue(Comparable<?> minValue) {
            this._minValue = minValue;
            return this;
        }

        public Builder setMaxValue(Comparable<?> maxValue) {
            this._maxValue = maxValue;
            return this;
        }

        public Builder setHasDictionary(boolean hasDictionary) {
            this._hasDictionary = hasDictionary;
            return this;
        }

        public Builder setColumnMaxLength(int columnMaxLength) {
            this._columnMaxLength = columnMaxLength;
            return this;
        }

        public Builder setPaddingCharacter(char paddingCharacter) {
            this._paddingCharacter = paddingCharacter;
            return this;
        }

        public Builder setBitsPerElement(int bitsPerElement) {
            this._bitsPerElement = bitsPerElement;
            return this;
        }

        public Builder setMaxNumberOfMultiValues(int maxNumberOfMultiValues) {
            this._maxNumberOfMultiValues = maxNumberOfMultiValues;
            return this;
        }

        public Builder setTotalNumberOfEntries(int totalNumberOfEntries) {
            this._totalNumberOfEntries = totalNumberOfEntries;
            return this;
        }

        public Builder setPartitionFunction(PartitionFunction partitionFunction) {
            this._partitionFunction = partitionFunction;
            return this;
        }

        public Builder setPartitions(Set<Integer> partitions) {
            this._partitions = partitions;
            return this;
        }

        public Builder setAutoGenerated(boolean autoGenerated) {
            this._autoGenerated = autoGenerated;
            return this;
        }

        public ColumnMetadataImpl build() {
            return new ColumnMetadataImpl(this._fieldSpec, this._totalDocs, this._cardinality, this._sorted, this._minValue, this._maxValue, this._hasDictionary, this._columnMaxLength, this._paddingCharacter, this._bitsPerElement, this._maxNumberOfMultiValues, this._totalNumberOfEntries, this._partitionFunction, this._partitions, this._autoGenerated);
        }
    }
}

