/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.startree;

import org.apache.pinot.segment.spi.AggregationFunctionType;

public class AggregationFunctionColumnPair {
    public static final String DELIMITER = "__";
    public static final String STAR = "*";
    public static final AggregationFunctionColumnPair COUNT_STAR = new AggregationFunctionColumnPair(AggregationFunctionType.COUNT, "*");
    private final AggregationFunctionType _functionType;
    private final String _column;

    public AggregationFunctionColumnPair(AggregationFunctionType functionType, String column) {
        this._functionType = functionType;
        this._column = functionType == AggregationFunctionType.COUNT ? STAR : column;
    }

    public AggregationFunctionType getFunctionType() {
        return this._functionType;
    }

    public String getColumn() {
        return this._column;
    }

    public String toColumnName() {
        return AggregationFunctionColumnPair.toColumnName(this._functionType, this._column);
    }

    public static String toColumnName(AggregationFunctionType functionType, String column) {
        return functionType.getName() + DELIMITER + column;
    }

    public static AggregationFunctionColumnPair fromColumnName(String columnName) {
        String[] parts = columnName.split(DELIMITER, 2);
        AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType(parts[0]);
        if (functionType == AggregationFunctionType.COUNT) {
            return COUNT_STAR;
        }
        return new AggregationFunctionColumnPair(functionType, parts[1]);
    }

    public int hashCode() {
        return 31 * this._functionType.hashCode() + this._column.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AggregationFunctionColumnPair) {
            AggregationFunctionColumnPair anotherPair = (AggregationFunctionColumnPair)obj;
            return this._functionType == anotherPair._functionType && this._column.equals(anotherPair._column);
        }
        return false;
    }

    public String toString() {
        return this.toColumnName();
    }
}

