/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.apache.pinot.segment.spi.memory.PinotNativeOrderLBuffer;
import org.apache.pinot.segment.spi.memory.PinotNonNativeOrderLBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class PinotDataBuffer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotDataBuffer.class);
    public static final ByteOrder NATIVE_ORDER = ByteOrder.nativeOrder();
    public static final ByteOrder NON_NATIVE_ORDER = NATIVE_ORDER == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    public static final int BULK_BYTES_PROCESSING_THRESHOLD = 10;
    private static final AtomicLong DIRECT_BUFFER_COUNT = new AtomicLong();
    private static final AtomicLong DIRECT_BUFFER_USAGE = new AtomicLong();
    private static final AtomicLong MMAP_BUFFER_COUNT = new AtomicLong();
    private static final AtomicLong MMAP_BUFFER_USAGE = new AtomicLong();
    private static final AtomicLong ALLOCATION_FAILURE_COUNT = new AtomicLong();
    private static final Map<PinotDataBuffer, BufferContext> BUFFER_CONTEXT_MAP = new WeakHashMap<PinotDataBuffer, BufferContext>();
    private boolean _closeable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PinotDataBuffer allocateDirect(long size, ByteOrder byteOrder, @Nullable String description) {
        PinotDataBuffer buffer;
        try {
            buffer = size <= Integer.MAX_VALUE ? PinotByteBuffer.allocateDirect((int)size, byteOrder) : (byteOrder == NATIVE_ORDER ? PinotNativeOrderLBuffer.allocateDirect(size) : PinotNonNativeOrderLBuffer.allocateDirect(size));
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while allocating direct buffer of size: {} with description: {}", new Object[]{size, description, e});
            LOGGER.error("Buffer stats: {}", (Object)PinotDataBuffer.getBufferStats());
            ALLOCATION_FAILURE_COUNT.getAndIncrement();
            throw e;
        }
        DIRECT_BUFFER_COUNT.getAndIncrement();
        DIRECT_BUFFER_USAGE.getAndAdd(size);
        Map<PinotDataBuffer, BufferContext> map = BUFFER_CONTEXT_MAP;
        synchronized (map) {
            BUFFER_CONTEXT_MAP.put(buffer, new BufferContext(BufferContext.Type.DIRECT, size, null, description));
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PinotDataBuffer loadFile(File file, long offset, long size, ByteOrder byteOrder, @Nullable String description) throws IOException {
        PinotDataBuffer buffer;
        try {
            buffer = size <= Integer.MAX_VALUE ? PinotByteBuffer.loadFile(file, offset, (int)size, byteOrder) : (byteOrder == NATIVE_ORDER ? PinotNativeOrderLBuffer.loadFile(file, offset, size) : PinotNonNativeOrderLBuffer.loadFile(file, offset, size));
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while loading file: {} from offset: {} of size: {} with description: {}", new Object[]{file.getAbsolutePath(), offset, size, description, e});
            LOGGER.error("Buffer stats: {}", (Object)PinotDataBuffer.getBufferStats());
            ALLOCATION_FAILURE_COUNT.getAndIncrement();
            throw e;
        }
        DIRECT_BUFFER_COUNT.getAndIncrement();
        DIRECT_BUFFER_USAGE.getAndAdd(size);
        Map<PinotDataBuffer, BufferContext> map = BUFFER_CONTEXT_MAP;
        synchronized (map) {
            BUFFER_CONTEXT_MAP.put(buffer, new BufferContext(BufferContext.Type.DIRECT, size, file.getAbsolutePath().intern(), description));
        }
        return buffer;
    }

    @VisibleForTesting
    public static PinotDataBuffer loadBigEndianFile(File file) throws IOException {
        return PinotDataBuffer.loadFile(file, 0L, file.length(), ByteOrder.BIG_ENDIAN, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PinotDataBuffer mapFile(File file, boolean readOnly, long offset, long size, ByteOrder byteOrder, @Nullable String description) throws IOException {
        PinotDataBuffer buffer;
        try {
            buffer = size <= Integer.MAX_VALUE ? PinotByteBuffer.mapFile(file, readOnly, offset, (int)size, byteOrder) : (byteOrder == NATIVE_ORDER ? PinotNativeOrderLBuffer.mapFile(file, readOnly, offset, size) : PinotNonNativeOrderLBuffer.mapFile(file, readOnly, offset, size));
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while mapping file: {} from offset: {} of size: {} with description: {}", new Object[]{file.getAbsolutePath(), offset, size, description, e});
            LOGGER.error("Buffer stats: {}", (Object)PinotDataBuffer.getBufferStats());
            ALLOCATION_FAILURE_COUNT.getAndIncrement();
            throw e;
        }
        MMAP_BUFFER_COUNT.getAndIncrement();
        MMAP_BUFFER_USAGE.getAndAdd(size);
        Map<PinotDataBuffer, BufferContext> map = BUFFER_CONTEXT_MAP;
        synchronized (map) {
            BUFFER_CONTEXT_MAP.put(buffer, new BufferContext(BufferContext.Type.MMAP, size, file.getAbsolutePath().intern(), description));
        }
        return buffer;
    }

    @VisibleForTesting
    public static PinotDataBuffer mapReadOnlyBigEndianFile(File file) throws IOException {
        return PinotDataBuffer.mapFile(file, true, 0L, file.length(), ByteOrder.BIG_ENDIAN, null);
    }

    public static long getDirectBufferCount() {
        return DIRECT_BUFFER_COUNT.get();
    }

    public static long getDirectBufferUsage() {
        return DIRECT_BUFFER_USAGE.get();
    }

    public static long getMmapBufferCount() {
        return MMAP_BUFFER_COUNT.get();
    }

    public static long getMmapBufferUsage() {
        return MMAP_BUFFER_USAGE.get();
    }

    public static long getAllocationFailureCount() {
        return ALLOCATION_FAILURE_COUNT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getBufferInfo() {
        Map<PinotDataBuffer, BufferContext> map = BUFFER_CONTEXT_MAP;
        synchronized (map) {
            ArrayList<String> bufferInfo = new ArrayList<String>(BUFFER_CONTEXT_MAP.size());
            for (BufferContext bufferContext : BUFFER_CONTEXT_MAP.values()) {
                bufferInfo.add(bufferContext.toString());
            }
            return bufferInfo;
        }
    }

    private static String getBufferStats() {
        return String.format("Direct buffer count: %s, size: %s; Mmap buffer count: %s, size: %s", DIRECT_BUFFER_COUNT.get(), DIRECT_BUFFER_USAGE.get(), MMAP_BUFFER_COUNT.get(), MMAP_BUFFER_USAGE.get());
    }

    protected PinotDataBuffer(boolean closeable) {
        this._closeable = closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this._closeable) {
            BufferContext bufferContext;
            this.flush();
            this.release();
            Map<PinotDataBuffer, BufferContext> map = BUFFER_CONTEXT_MAP;
            synchronized (map) {
                bufferContext = BUFFER_CONTEXT_MAP.remove(this);
            }
            if (bufferContext != null) {
                if (bufferContext._type == BufferContext.Type.DIRECT) {
                    DIRECT_BUFFER_COUNT.getAndDecrement();
                    DIRECT_BUFFER_USAGE.getAndAdd(-bufferContext._size);
                } else {
                    MMAP_BUFFER_COUNT.getAndDecrement();
                    MMAP_BUFFER_USAGE.getAndAdd(-bufferContext._size);
                }
            }
            this._closeable = false;
        }
    }

    public abstract byte getByte(int var1);

    public abstract byte getByte(long var1);

    public abstract void putByte(int var1, byte var2);

    public abstract void putByte(long var1, byte var3);

    public abstract char getChar(int var1);

    public abstract char getChar(long var1);

    public abstract void putChar(int var1, char var2);

    public abstract void putChar(long var1, char var3);

    public abstract short getShort(int var1);

    public abstract short getShort(long var1);

    public abstract void putShort(int var1, short var2);

    public abstract void putShort(long var1, short var3);

    public abstract int getInt(int var1);

    public abstract int getInt(long var1);

    public abstract void putInt(int var1, int var2);

    public abstract void putInt(long var1, int var3);

    public abstract long getLong(int var1);

    public abstract long getLong(long var1);

    public abstract void putLong(int var1, long var2);

    public abstract void putLong(long var1, long var3);

    public abstract float getFloat(int var1);

    public abstract float getFloat(long var1);

    public abstract void putFloat(int var1, float var2);

    public abstract void putFloat(long var1, float var3);

    public abstract double getDouble(int var1);

    public abstract double getDouble(long var1);

    public abstract void putDouble(int var1, double var2);

    public abstract void putDouble(long var1, double var3);

    public abstract void copyTo(long var1, byte[] var3, int var4, int var5);

    public void copyTo(long offset, byte[] buffer) {
        this.copyTo(offset, buffer, 0, buffer.length);
    }

    public abstract void copyTo(long var1, PinotDataBuffer var3, long var4, long var6);

    public abstract void readFrom(long var1, byte[] var3, int var4, int var5);

    public void readFrom(long offset, byte[] buffer) {
        this.readFrom(offset, buffer, 0, buffer.length);
    }

    public abstract void readFrom(long var1, ByteBuffer var3);

    public abstract void readFrom(long var1, File var3, long var4, long var6) throws IOException;

    public abstract long size();

    public abstract ByteOrder order();

    public abstract PinotDataBuffer view(long var1, long var3, ByteOrder var5);

    public PinotDataBuffer view(long start, long end) {
        return this.view(start, end, this.order());
    }

    public abstract ByteBuffer toDirectByteBuffer(long var1, int var3, ByteOrder var4);

    public ByteBuffer toDirectByteBuffer(long offset, int size) {
        return this.toDirectByteBuffer(offset, size, this.order());
    }

    public abstract void flush();

    public abstract void release() throws IOException;

    private static class BufferContext {
        final Type _type;
        final long _size;
        final String _filePath;
        final String _description;

        BufferContext(Type type, long size, @Nullable String filePath, @Nullable String description) {
            this._type = type;
            this._size = size;
            this._filePath = filePath;
            this._description = description;
        }

        public String toString() {
            String context = "Type: " + (Object)((Object)this._type) + ", Size: " + this._size;
            if (this._filePath != null) {
                context = context + ", File Path: " + this._filePath;
            }
            if (this._description != null) {
                context = context + ", Description: " + this._description;
            }
            return context;
        }

        static enum Type {
            DIRECT,
            MMAP;

        }
    }
}

